/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging.rxjava3;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0014 \n*\t\u0018\u00010\b\u00a2\u0006\u0002\b\t0\b\u00a2\u0006\u0002\b\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/paging/rxjava3/ScheduledExecutor;", "Lio/reactivex/rxjava3/core/Scheduler;", "Ljava/util/concurrent/Executor;", "scheduler", "(Lio/reactivex/rxjava3/core/Scheduler;)V", "executor", "(Ljava/util/concurrent/Executor;)V", "createWorker", "Lio/reactivex/rxjava3/core/Scheduler$Worker;", "Lio/reactivex/rxjava3/annotations/NonNull;", "kotlin.jvm.PlatformType", "execute", "", "command", "Ljava/lang/Runnable;", "paging-rxjava3_release"})
public final class ScheduledExecutor
extends Scheduler
implements Executor {
    @NotNull
    private final Executor executor;
    @NotNull
    private final Scheduler scheduler;

    public ScheduledExecutor(@NotNull Scheduler scheduler) {
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        final Scheduler.Worker worker = scheduler.createWorker();
        this.executor = new Executor(){

            @Override
            public final void execute(Runnable command) {
                worker.schedule(command);
            }
        };
        this.scheduler = scheduler;
    }

    public ScheduledExecutor(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        Scheduler scheduler = Schedulers.from((Executor)executor);
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"from(executor)");
        this.scheduler = scheduler;
    }

    public Scheduler.Worker createWorker() {
        return this.scheduler.createWorker();
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.executor.execute(command);
    }
}

