/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging.testing;

import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u001e\u0010\u0011\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J#\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J(\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u00172\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Landroidx/paging/testing/StaticListPagingSource;", "Value", "", "Landroidx/paging/PagingSource;", "", "dataList", "", "(Ljava/util/List;)V", "jumpingSupported", "", "getJumpingSupported", "()Z", "computeIndexEnd", "params", "Landroidx/paging/PagingSource$LoadParams;", "key", "startIndex", "computeIndexStart", "getRefreshKey", "state", "Landroidx/paging/PagingState;", "(Landroidx/paging/PagingState;)Ljava/lang/Integer;", "load", "Landroidx/paging/PagingSource$LoadResult;", "(Landroidx/paging/PagingSource$LoadParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "paging-testing"})
public final class StaticListPagingSource<Value>
extends PagingSource<Integer, Value> {
    @NotNull
    private final List<Value> dataList;

    public StaticListPagingSource(@NotNull List<? extends Value> dataList) {
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        this.dataList = dataList;
    }

    @Nullable
    public Object load(@NotNull PagingSource.LoadParams<Integer> params, @NotNull Continuation<? super PagingSource.LoadResult<Integer, Value>> $completion) {
        Integer n = (Integer)params.getKey();
        int key = n != null ? n : 0;
        int indexStart = this.computeIndexStart(params, key);
        int indexEnd = this.computeIndexEnd(params, key, indexStart);
        List data = CollectionsKt.slice(this.dataList, (IntRange)new IntRange(indexStart, indexEnd));
        return new PagingSource.LoadResult.Page(data, (Object)(indexStart <= 0 || data.isEmpty() ? null : Boxing.boxInt((int)(indexStart - 1))), (Object)(indexEnd >= CollectionsKt.getLastIndex(this.dataList) || data.isEmpty() ? null : Boxing.boxInt((int)(indexEnd + 1))), indexStart, CollectionsKt.getLastIndex(this.dataList) - indexEnd);
    }

    private final int computeIndexStart(PagingSource.LoadParams<Integer> params, int key) {
        int n;
        PagingSource.LoadParams<Integer> loadParams = params;
        if (loadParams instanceof PagingSource.LoadParams.Prepend) {
            n = key - params.getLoadSize() + 1;
        } else if (loadParams instanceof PagingSource.LoadParams.Append) {
            n = key;
        } else if (loadParams instanceof PagingSource.LoadParams.Refresh) {
            n = key >= CollectionsKt.getLastIndex(this.dataList) ? this.dataList.size() - params.getLoadSize() : key;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return RangesKt.coerceAtLeast((int)n, (int)0);
    }

    private final int computeIndexEnd(PagingSource.LoadParams<Integer> params, int key, int startIndex) {
        int defaultOffset = startIndex + params.getLoadSize() - 1;
        return params instanceof PagingSource.LoadParams.Prepend ? RangesKt.coerceAtMost((int)defaultOffset, (int)key) : RangesKt.coerceAtMost((int)defaultOffset, (int)CollectionsKt.getLastIndex(this.dataList));
    }

    @Nullable
    public Integer getRefreshKey(@NotNull PagingState<Integer, Value> state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Integer anchorPosition = state.getAnchorPosition();
        return anchorPosition != null ? Integer.valueOf(RangesKt.coerceAtLeast((int)(anchorPosition - state.getConfig().initialLoadSize / 2), (int)0)) : null;
    }

    public boolean getJumpingSupported() {
        return true;
    }
}

