/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.MotionEvent;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.AutoScroller;
import androidx.recyclerview.selection.BandPredicate;
import androidx.recyclerview.selection.DefaultBandHost;
import androidx.recyclerview.selection.FocusDelegate;
import androidx.recyclerview.selection.GridModel;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.selection.MotionEvents;
import androidx.recyclerview.selection.OperationMonitor;
import androidx.recyclerview.selection.SelectionTracker;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Set;

class BandSelectionHelper<K>
implements RecyclerView.OnItemTouchListener {
    static final String TAG = "BandSelectionHelper";
    static final boolean DEBUG = false;
    private final BandHost mHost;
    private final ItemKeyProvider<K> mKeyProvider;
    private final SelectionTracker<K> mSelectionTracker;
    private final BandPredicate mBandPredicate;
    private final FocusDelegate<K> mFocusDelegate;
    private final OperationMonitor mLock;
    private final AutoScroller mScroller;
    private final GridModel.SelectionObserver mGridObserver;
    @Nullable
    private Point mCurrentPosition;
    @Nullable
    private Point mOrigin;
    @Nullable
    private GridModel mModel;

    BandSelectionHelper(@NonNull BandHost host, @NonNull AutoScroller scroller, @NonNull ItemKeyProvider<K> keyProvider, @NonNull SelectionTracker<K> selectionTracker, @NonNull BandPredicate bandPredicate, @NonNull FocusDelegate<K> focusDelegate, @NonNull OperationMonitor lock) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0);
        Preconditions.checkArgument((scroller != null ? 1 : 0) != 0);
        Preconditions.checkArgument((keyProvider != null ? 1 : 0) != 0);
        Preconditions.checkArgument((selectionTracker != null ? 1 : 0) != 0);
        Preconditions.checkArgument((bandPredicate != null ? 1 : 0) != 0);
        Preconditions.checkArgument((focusDelegate != null ? 1 : 0) != 0);
        Preconditions.checkArgument((lock != null ? 1 : 0) != 0);
        this.mHost = host;
        this.mKeyProvider = keyProvider;
        this.mSelectionTracker = selectionTracker;
        this.mBandPredicate = bandPredicate;
        this.mFocusDelegate = focusDelegate;
        this.mLock = lock;
        this.mHost.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                BandSelectionHelper.this.onScrolled(recyclerView, dx, dy);
            }
        });
        this.mScroller = scroller;
        this.mGridObserver = new GridModel.SelectionObserver<K>(){

            @Override
            public void onSelectionChanged(Set<K> updatedSelection) {
                BandSelectionHelper.this.mSelectionTracker.setProvisionalSelection(updatedSelection);
            }
        };
    }

    static <K> BandSelectionHelper create(@NonNull RecyclerView recyclerView, @NonNull AutoScroller scroller, @DrawableRes int bandOverlayId, @NonNull ItemKeyProvider<K> keyProvider, @NonNull SelectionTracker<K> selectionTracker, @NonNull SelectionTracker.SelectionPredicate<K> selectionPredicate, @NonNull BandPredicate bandPredicate, @NonNull FocusDelegate<K> focusDelegate, @NonNull OperationMonitor lock) {
        return new BandSelectionHelper<K>(new DefaultBandHost<K>(recyclerView, bandOverlayId, keyProvider, selectionPredicate), scroller, keyProvider, selectionTracker, bandPredicate, focusDelegate, lock);
    }

    @VisibleForTesting
    boolean isActive() {
        boolean active = this.mModel != null;
        return active;
    }

    void reset() {
        if (!this.isActive()) {
            return;
        }
        this.mHost.hideBand();
        if (this.mModel != null) {
            this.mModel.stopCapturing();
            this.mModel.onDestroy();
        }
        this.mModel = null;
        this.mOrigin = null;
        this.mScroller.reset();
        this.mLock.stop();
    }

    @VisibleForTesting
    boolean shouldStart(@NonNull MotionEvent e) {
        return MotionEvents.isPrimaryMouseButtonPressed(e) && MotionEvents.isActionMove(e) && this.mBandPredicate.canInitiate(e) && !this.isActive();
    }

    @VisibleForTesting
    boolean shouldStop(@NonNull MotionEvent e) {
        return this.isActive() && (MotionEvents.isActionUp(e) || MotionEvents.isActionPointerUp(e) || MotionEvents.isActionCancel(e));
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView unused, @NonNull MotionEvent e) {
        if (this.shouldStart(e)) {
            this.startBandSelect(e);
        } else if (this.shouldStop(e)) {
            this.endBandSelect();
        }
        return this.isActive();
    }

    public void onTouchEvent(@NonNull RecyclerView unused, @NonNull MotionEvent e) {
        if (this.shouldStop(e)) {
            this.endBandSelect();
            return;
        }
        if (!this.isActive()) {
            return;
        }
        this.mCurrentPosition = MotionEvents.getOrigin(e);
        this.mModel.resizeSelection(this.mCurrentPosition);
        this.resizeBand();
        this.mScroller.scroll(this.mCurrentPosition);
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    private void startBandSelect(@NonNull MotionEvent e) {
        Preconditions.checkState((!this.isActive() ? 1 : 0) != 0);
        if (!MotionEvents.isCtrlKeyPressed(e)) {
            this.mSelectionTracker.clearSelection();
        }
        Point origin = MotionEvents.getOrigin(e);
        this.mModel = this.mHost.createGridModel();
        this.mModel.addOnSelectionChangedListener(this.mGridObserver);
        this.mLock.start();
        this.mFocusDelegate.clearFocus();
        this.mOrigin = origin;
        this.mModel.startCapturing(this.mOrigin);
    }

    private void resizeBand() {
        Rect bounds = new Rect(Math.min(this.mOrigin.x, this.mCurrentPosition.x), Math.min(this.mOrigin.y, this.mCurrentPosition.y), Math.max(this.mOrigin.x, this.mCurrentPosition.x), Math.max(this.mOrigin.y, this.mCurrentPosition.y));
        this.mHost.showBand(bounds);
    }

    private void endBandSelect() {
        int firstSelected = this.mModel.getPositionNearestOrigin();
        if (firstSelected != -1 && this.mSelectionTracker.isSelected(this.mKeyProvider.getKey(firstSelected))) {
            this.mSelectionTracker.anchorRange(firstSelected);
        }
        this.mSelectionTracker.mergeProvisionalSelection();
        this.reset();
    }

    private void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
        if (!this.isActive()) {
            return;
        }
        this.mOrigin.y -= dy;
        this.resizeBand();
    }

    static abstract class BandHost<K> {
        BandHost() {
        }

        abstract GridModel<K> createGridModel();

        abstract void showBand(@NonNull Rect var1);

        abstract void hideBand();

        abstract void addOnScrollListener(@NonNull RecyclerView.OnScrollListener var1);
    }
}

