/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.GridModel;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.selection.SelectionTracker;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

final class DefaultBandHost<K>
extends GridModel.GridHost<K> {
    private static final Rect NILL_RECT = new Rect(0, 0, 0, 0);
    private final RecyclerView mRecyclerView;
    private final Drawable mBand;
    private final ItemKeyProvider<K> mKeyProvider;
    private final SelectionTracker.SelectionPredicate<K> mSelectionPredicate;

    DefaultBandHost(@NonNull RecyclerView recyclerView, @DrawableRes int bandOverlayId, @NonNull ItemKeyProvider<K> keyProvider, @NonNull SelectionTracker.SelectionPredicate<K> selectionPredicate) {
        Preconditions.checkArgument((recyclerView != null ? 1 : 0) != 0);
        this.mRecyclerView = recyclerView;
        this.mBand = this.mRecyclerView.getContext().getResources().getDrawable(bandOverlayId);
        Preconditions.checkArgument((this.mBand != null ? 1 : 0) != 0);
        Preconditions.checkArgument((keyProvider != null ? 1 : 0) != 0);
        Preconditions.checkArgument((selectionPredicate != null ? 1 : 0) != 0);
        this.mKeyProvider = keyProvider;
        this.mSelectionPredicate = selectionPredicate;
        this.mRecyclerView.addItemDecoration(new RecyclerView.ItemDecoration(){

            public void onDrawOver(Canvas canvas, RecyclerView unusedParent, RecyclerView.State unusedState) {
                DefaultBandHost.this.onDrawBand(canvas);
            }
        });
    }

    @Override
    GridModel<K> createGridModel() {
        return new GridModel<K>(this, this.mKeyProvider, this.mSelectionPredicate);
    }

    @Override
    int getAdapterPositionAt(int index) {
        return this.mRecyclerView.getChildAdapterPosition(this.mRecyclerView.getChildAt(index));
    }

    @Override
    void addOnScrollListener(@NonNull RecyclerView.OnScrollListener listener) {
        this.mRecyclerView.addOnScrollListener(listener);
    }

    @Override
    void removeOnScrollListener(@NonNull RecyclerView.OnScrollListener listener) {
        this.mRecyclerView.removeOnScrollListener(listener);
    }

    @Override
    Point createAbsolutePoint(@NonNull Point relativePoint) {
        return new Point(relativePoint.x + this.mRecyclerView.computeHorizontalScrollOffset(), relativePoint.y + this.mRecyclerView.computeVerticalScrollOffset());
    }

    @Override
    Rect getAbsoluteRectForChildViewAt(int index) {
        View child = this.mRecyclerView.getChildAt(index);
        Rect childRect = new Rect();
        child.getHitRect(childRect);
        childRect.left += this.mRecyclerView.computeHorizontalScrollOffset();
        childRect.right += this.mRecyclerView.computeHorizontalScrollOffset();
        childRect.top += this.mRecyclerView.computeVerticalScrollOffset();
        childRect.bottom += this.mRecyclerView.computeVerticalScrollOffset();
        return childRect;
    }

    @Override
    int getVisibleChildCount() {
        return this.mRecyclerView.getChildCount();
    }

    @Override
    int getColumnCount() {
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            return ((GridLayoutManager)layoutManager).getSpanCount();
        }
        return 1;
    }

    @Override
    void showBand(@NonNull Rect rect) {
        this.mBand.setBounds(rect);
        this.mRecyclerView.invalidate();
    }

    @Override
    void hideBand() {
        this.mBand.setBounds(NILL_RECT);
        this.mRecyclerView.invalidate();
    }

    private void onDrawBand(@NonNull Canvas c) {
        this.mBand.draw(c);
    }

    @Override
    boolean hasView(int pos) {
        return this.mRecyclerView.findViewHolderForAdapterPosition(pos) != null;
    }
}

