/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.graphics.Point;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Preconditions;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.selection.AutoScroller;
import androidx.recyclerview.widget.RecyclerView;

final class ViewAutoScroller
extends AutoScroller {
    private static final String TAG = "ViewAutoScroller";
    private static final float DEFAULT_SCROLL_THRESHOLD_RATIO = 0.125f;
    private static final int MAX_SCROLL_STEP = 70;
    private final float mScrollThresholdRatio;
    private final ScrollHost mHost;
    private final Runnable mRunner;
    @Nullable
    private Point mOrigin;
    @Nullable
    private Point mLastLocation;
    private boolean mPassedInitialMotionThreshold;

    ViewAutoScroller(@NonNull ScrollHost scrollHost) {
        this(scrollHost, 0.125f);
    }

    @VisibleForTesting
    ViewAutoScroller(@NonNull ScrollHost scrollHost, float scrollThresholdRatio) {
        Preconditions.checkArgument((scrollHost != null ? 1 : 0) != 0);
        this.mHost = scrollHost;
        this.mScrollThresholdRatio = scrollThresholdRatio;
        this.mRunner = new Runnable(){

            @Override
            public void run() {
                ViewAutoScroller.this.runScroll();
            }
        };
    }

    @Override
    public void reset() {
        this.mHost.removeCallback(this.mRunner);
        this.mOrigin = null;
        this.mLastLocation = null;
        this.mPassedInitialMotionThreshold = false;
    }

    @Override
    public void scroll(@NonNull Point location) {
        this.mLastLocation = location;
        if (this.mOrigin == null) {
            this.mOrigin = location;
        }
        this.mHost.runAtNextFrame(this.mRunner);
    }

    private void runScroll() {
        int pixelsPastView = 0;
        int verticalThreshold = (int)((float)this.mHost.getViewHeight() * this.mScrollThresholdRatio);
        if (this.mLastLocation.y <= verticalThreshold) {
            pixelsPastView = this.mLastLocation.y - verticalThreshold;
        } else if (this.mLastLocation.y >= this.mHost.getViewHeight() - verticalThreshold) {
            pixelsPastView = this.mLastLocation.y - this.mHost.getViewHeight() + verticalThreshold;
        }
        if (pixelsPastView == 0) {
            return;
        }
        if (!this.mPassedInitialMotionThreshold && !this.aboveMotionThreshold(this.mLastLocation)) {
            return;
        }
        this.mPassedInitialMotionThreshold = true;
        if (pixelsPastView > verticalThreshold) {
            pixelsPastView = verticalThreshold;
        }
        int numPixels = this.computeScrollDistance(pixelsPastView);
        this.mHost.scrollBy(numPixels);
        this.mHost.removeCallback(this.mRunner);
        this.mHost.runAtNextFrame(this.mRunner);
    }

    private boolean aboveMotionThreshold(@NonNull Point location) {
        int motionThreshold = (int)((float)this.mHost.getViewHeight() * this.mScrollThresholdRatio * (this.mScrollThresholdRatio * 2.0f));
        return Math.abs(this.mOrigin.y - location.y) >= motionThreshold;
    }

    @VisibleForTesting
    int computeScrollDistance(int pixelsPastView) {
        int absPastView;
        float outOfBoundsRatio;
        int topBottomThreshold = (int)((float)this.mHost.getViewHeight() * this.mScrollThresholdRatio);
        int direction = (int)Math.signum(pixelsPastView);
        int cappedScrollStep = (int)((float)(direction * 70) * this.smoothOutOfBoundsRatio(outOfBoundsRatio = Math.min(1.0f, (float)(absPastView = Math.abs(pixelsPastView)) / (float)topBottomThreshold)));
        return cappedScrollStep != 0 ? cappedScrollStep : direction;
    }

    private float smoothOutOfBoundsRatio(float ratio) {
        return (float)Math.pow(ratio, 10.0);
    }

    static ScrollHost createScrollHost(RecyclerView recyclerView) {
        return new RuntimeHost(recyclerView);
    }

    private static final class RuntimeHost
    extends ScrollHost {
        private final RecyclerView mRecyclerView;

        RuntimeHost(@NonNull RecyclerView recyclerView) {
            this.mRecyclerView = recyclerView;
        }

        @Override
        void runAtNextFrame(@NonNull Runnable r) {
            ViewCompat.postOnAnimation((View)this.mRecyclerView, (Runnable)r);
        }

        @Override
        void removeCallback(@NonNull Runnable r) {
            this.mRecyclerView.removeCallbacks(r);
        }

        @Override
        void scrollBy(int dy) {
            this.mRecyclerView.scrollBy(0, dy);
        }

        @Override
        int getViewHeight() {
            return this.mRecyclerView.getHeight();
        }
    }

    static abstract class ScrollHost {
        ScrollHost() {
        }

        abstract int getViewHeight();

        abstract void scrollBy(int var1);

        abstract void runAtNextFrame(@NonNull Runnable var1);

        abstract void removeCallback(@NonNull Runnable var1);
    }
}

