/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.selection.MutableSelection;
import androidx.recyclerview.selection.Range;
import androidx.recyclerview.selection.Selection;
import androidx.recyclerview.selection.SelectionTracker;
import androidx.recyclerview.selection.StorageStrategy;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class DefaultSelectionTracker<K>
extends SelectionTracker<K> {
    private static final String TAG = "DefaultSelectionTracker";
    private static final String EXTRA_SELECTION_PREFIX = "androidx.recyclerview.selection";
    private final Selection<K> mSelection = new Selection();
    private final List<SelectionTracker.SelectionObserver> mObservers = new ArrayList<SelectionTracker.SelectionObserver>(1);
    private final ItemKeyProvider<K> mKeyProvider;
    private final SelectionTracker.SelectionPredicate<K> mSelectionPredicate;
    private final StorageStrategy<K> mStorage;
    private final RangeCallbacks mRangeCallbacks;
    private final AdapterObserver mAdapterObserver;
    private final boolean mSingleSelect;
    private final String mSelectionId;
    @Nullable
    private Range mRange;

    public DefaultSelectionTracker(@NonNull String selectionId, @NonNull ItemKeyProvider keyProvider, @NonNull SelectionTracker.SelectionPredicate selectionPredicate, @NonNull StorageStrategy<K> storage) {
        Preconditions.checkArgument((selectionId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!selectionId.trim().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((keyProvider != null ? 1 : 0) != 0);
        Preconditions.checkArgument((selectionPredicate != null ? 1 : 0) != 0);
        Preconditions.checkArgument((storage != null ? 1 : 0) != 0);
        this.mSelectionId = selectionId;
        this.mKeyProvider = keyProvider;
        this.mSelectionPredicate = selectionPredicate;
        this.mStorage = storage;
        this.mRangeCallbacks = new RangeCallbacks();
        this.mSingleSelect = !selectionPredicate.canSelectMultiple();
        this.mAdapterObserver = new AdapterObserver(this);
    }

    @Override
    public void addObserver(@NonNull SelectionTracker.SelectionObserver callback) {
        Preconditions.checkArgument((callback != null ? 1 : 0) != 0);
        this.mObservers.add(callback);
    }

    @Override
    public boolean hasSelection() {
        return !this.mSelection.isEmpty();
    }

    @Override
    public Selection getSelection() {
        return this.mSelection;
    }

    @Override
    public void copySelection(@NonNull MutableSelection dest) {
        dest.copyFrom(this.mSelection);
    }

    @Override
    public boolean isSelected(@Nullable K key) {
        return this.mSelection.contains(key);
    }

    @Override
    protected void restoreSelection(@NonNull Selection other) {
        Preconditions.checkArgument((other != null ? 1 : 0) != 0);
        this.setItemsSelectedQuietly(other.mSelection, true);
        this.notifySelectionRestored();
    }

    @Override
    public boolean setItemsSelected(@NonNull Iterable<K> keys, boolean selected) {
        boolean changed = this.setItemsSelectedQuietly(keys, selected);
        this.notifySelectionChanged();
        return changed;
    }

    private boolean setItemsSelectedQuietly(@NonNull Iterable<K> keys, boolean selected) {
        boolean changed = false;
        for (K key : keys) {
            boolean itemChanged;
            boolean bl = selected ? this.canSetState(key, true) && this.mSelection.add(key) : (itemChanged = this.canSetState(key, false) && this.mSelection.remove(key));
            if (itemChanged) {
                this.notifyItemStateChanged(key, selected);
            }
            changed |= itemChanged;
        }
        return changed;
    }

    @Override
    public boolean clearSelection() {
        if (!this.hasSelection()) {
            return false;
        }
        this.clearProvisionalSelection();
        this.clearPrimarySelection();
        return true;
    }

    private void clearPrimarySelection() {
        if (!this.hasSelection()) {
            return;
        }
        Selection prev = this.clearSelectionQuietly();
        this.notifySelectionCleared(prev);
        this.notifySelectionChanged();
    }

    private Selection clearSelectionQuietly() {
        this.mRange = null;
        MutableSelection prevSelection = new MutableSelection();
        if (this.hasSelection()) {
            this.copySelection(prevSelection);
            this.mSelection.clear();
        }
        return prevSelection;
    }

    @Override
    public boolean select(@NonNull K key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0);
        if (this.mSelection.contains(key)) {
            return false;
        }
        if (!this.canSetState(key, true)) {
            return false;
        }
        if (this.mSingleSelect && this.hasSelection()) {
            Selection prev = this.clearSelectionQuietly();
            this.notifySelectionCleared(prev);
        }
        this.mSelection.add(key);
        this.notifyItemStateChanged(key, true);
        this.notifySelectionChanged();
        return true;
    }

    @Override
    public boolean deselect(@NonNull K key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0);
        if (this.mSelection.contains(key)) {
            if (!this.canSetState(key, false)) {
                return false;
            }
            this.mSelection.remove(key);
            this.notifyItemStateChanged(key, false);
            this.notifySelectionChanged();
            if (this.mSelection.isEmpty() && this.isRangeActive()) {
                this.endRange();
            }
            return true;
        }
        return false;
    }

    @Override
    public void startRange(int position) {
        if (this.mSelection.contains(this.mKeyProvider.getKey(position)) || this.select(this.mKeyProvider.getKey(position))) {
            this.anchorRange(position);
        }
    }

    @Override
    public void extendRange(int position) {
        this.extendRange(position, 0);
    }

    @Override
    public void endRange() {
        this.mRange = null;
        this.clearProvisionalSelection();
    }

    @Override
    public void anchorRange(int position) {
        Preconditions.checkArgument((position != -1 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.mSelection.contains(this.mKeyProvider.getKey(position)));
        this.mRange = new Range(position, this.mRangeCallbacks);
    }

    @Override
    public void extendProvisionalRange(int position) {
        if (this.mSingleSelect) {
            return;
        }
        Preconditions.checkState((boolean)this.isRangeActive(), (String)"Range start point not set.");
        this.extendRange(position, 1);
    }

    private void extendRange(int position, int type) {
        Preconditions.checkState((boolean)this.isRangeActive(), (String)"Range start point not set.");
        this.mRange.extendRange(position, type);
        this.notifySelectionChanged();
    }

    @Override
    public void setProvisionalSelection(@NonNull Set<K> newSelection) {
        if (this.mSingleSelect) {
            return;
        }
        Map<K, Boolean> delta = this.mSelection.setProvisionalSelection(newSelection);
        for (Map.Entry<K, Boolean> entry : delta.entrySet()) {
            this.notifyItemStateChanged(entry.getKey(), entry.getValue());
        }
        this.notifySelectionChanged();
    }

    @Override
    public void mergeProvisionalSelection() {
        this.mSelection.mergeProvisionalSelection();
        this.notifySelectionChanged();
    }

    @Override
    public void clearProvisionalSelection() {
        for (Object key : this.mSelection.mProvisionalSelection) {
            this.notifyItemStateChanged(key, false);
        }
        this.mSelection.clearProvisionalSelection();
    }

    @Override
    public boolean isRangeActive() {
        return this.mRange != null;
    }

    private boolean canSetState(@NonNull K key, boolean nextState) {
        return this.mSelectionPredicate.canSetStateForKey(key, nextState);
    }

    @Override
    RecyclerView.AdapterDataObserver getAdapterDataObserver() {
        return this.mAdapterObserver;
    }

    private void onDataSetChanged() {
        this.mSelection.clearProvisionalSelection();
        this.notifySelectionRefresh();
        for (K key : this.mSelection) {
            int lastListener;
            if (!this.canSetState(key, true)) {
                this.deselect(key);
                continue;
            }
            for (int i = lastListener = this.mObservers.size() - 1; i >= 0; --i) {
                this.mObservers.get(i).onItemStateChanged(key, true);
            }
        }
        this.notifySelectionChanged();
    }

    private void notifyItemStateChanged(@NonNull K key, boolean selected) {
        int lastListenerIndex;
        Preconditions.checkArgument((key != null ? 1 : 0) != 0);
        for (int i = lastListenerIndex = this.mObservers.size() - 1; i >= 0; --i) {
            this.mObservers.get(i).onItemStateChanged(key, selected);
        }
    }

    private void notifySelectionCleared(@NonNull Selection<K> selection) {
        for (Object key : selection.mSelection) {
            this.notifyItemStateChanged(key, false);
        }
        for (Object key : selection.mProvisionalSelection) {
            this.notifyItemStateChanged(key, false);
        }
    }

    private void notifySelectionChanged() {
        int lastListenerIndex;
        for (int i = lastListenerIndex = this.mObservers.size() - 1; i >= 0; --i) {
            this.mObservers.get(i).onSelectionChanged();
        }
    }

    private void notifySelectionRestored() {
        int lastListenerIndex;
        for (int i = lastListenerIndex = this.mObservers.size() - 1; i >= 0; --i) {
            this.mObservers.get(i).onSelectionRestored();
        }
    }

    private void notifySelectionRefresh() {
        int lastListenerIndex;
        for (int i = lastListenerIndex = this.mObservers.size() - 1; i >= 0; --i) {
            this.mObservers.get(i).onSelectionRefresh();
        }
    }

    private void updateForRange(int begin, int end, boolean selected, int type) {
        switch (type) {
            case 0: {
                this.updateForRegularRange(begin, end, selected);
                break;
            }
            case 1: {
                this.updateForProvisionalRange(begin, end, selected);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid range type: " + type);
            }
        }
    }

    private void updateForRegularRange(int begin, int end, boolean selected) {
        Preconditions.checkArgument((end >= begin ? 1 : 0) != 0);
        for (int i = begin; i <= end; ++i) {
            K key = this.mKeyProvider.getKey(i);
            if (key == null) continue;
            if (selected) {
                this.select(key);
                continue;
            }
            this.deselect(key);
        }
    }

    private void updateForProvisionalRange(int begin, int end, boolean selected) {
        Preconditions.checkArgument((end >= begin ? 1 : 0) != 0);
        for (int i = begin; i <= end; ++i) {
            K key = this.mKeyProvider.getKey(i);
            if (key == null) continue;
            boolean changedState = false;
            if (selected) {
                boolean canSelect = this.canSetState(key, true);
                if (canSelect && !this.mSelection.mSelection.contains(key)) {
                    this.mSelection.mProvisionalSelection.add(key);
                    changedState = true;
                }
            } else {
                this.mSelection.mProvisionalSelection.remove(key);
                changedState = true;
            }
            if (!changedState) continue;
            this.notifyItemStateChanged(key, selected);
        }
        this.notifySelectionChanged();
    }

    @VisibleForTesting
    String getInstanceStateKey() {
        return "androidx.recyclerview.selection:" + this.mSelectionId;
    }

    @Override
    public final void onSaveInstanceState(@NonNull Bundle state) {
        if (this.mSelection.isEmpty()) {
            return;
        }
        state.putBundle(this.getInstanceStateKey(), this.mStorage.asBundle(this.mSelection));
    }

    @Override
    public final void onRestoreInstanceState(@Nullable Bundle state) {
        if (state == null) {
            return;
        }
        Bundle selectionState = state.getBundle(this.getInstanceStateKey());
        if (selectionState == null) {
            return;
        }
        Selection<K> selection = this.mStorage.asSelection(selectionState);
        if (selection != null && !selection.isEmpty()) {
            this.restoreSelection((Selection)selection);
        }
    }

    private static final class AdapterObserver
    extends RecyclerView.AdapterDataObserver {
        private final DefaultSelectionTracker<?> mSelectionTracker;

        AdapterObserver(@NonNull DefaultSelectionTracker<?> selectionTracker) {
            Preconditions.checkArgument((selectionTracker != null ? 1 : 0) != 0);
            this.mSelectionTracker = selectionTracker;
        }

        public void onChanged() {
            ((DefaultSelectionTracker)this.mSelectionTracker).onDataSetChanged();
        }

        public void onItemRangeChanged(int startPosition, int itemCount, @Nullable Object payload) {
            if (!"Selection-Changed".equals(payload)) {
                ((DefaultSelectionTracker)this.mSelectionTracker).onDataSetChanged();
            }
        }

        public void onItemRangeInserted(int startPosition, int itemCount) {
            this.mSelectionTracker.endRange();
        }

        public void onItemRangeRemoved(int startPosition, int itemCount) {
            this.mSelectionTracker.endRange();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.mSelectionTracker.endRange();
        }
    }

    private final class RangeCallbacks
    extends Range.Callbacks {
        private RangeCallbacks() {
        }

        @Override
        void updateForRange(int begin, int end, boolean selected, int type) {
            switch (type) {
                case 0: {
                    DefaultSelectionTracker.this.updateForRegularRange(begin, end, selected);
                    break;
                }
                case 1: {
                    DefaultSelectionTracker.this.updateForProvisionalRange(begin, end, selected);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid range type: " + type);
                }
            }
        }
    }
}

