/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.graphics.Point;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Preconditions;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.selection.AutoScroller;
import androidx.recyclerview.selection.ItemDetailsLookup;
import androidx.recyclerview.selection.MotionEvents;
import androidx.recyclerview.selection.OperationMonitor;
import androidx.recyclerview.selection.SelectionTracker;
import androidx.recyclerview.widget.RecyclerView;

final class GestureSelectionHelper
implements RecyclerView.OnItemTouchListener {
    private static final String TAG = "GestureSelectionHelper";
    private final SelectionTracker<?> mSelectionMgr;
    private final ItemDetailsLookup<?> mDetailsLookup;
    private final AutoScroller mScroller;
    private final ViewDelegate mView;
    private final OperationMonitor mLock;
    private int mLastStartedItemPos = -1;
    private boolean mStarted = false;
    private Point mLastInterceptedPoint;

    GestureSelectionHelper(@NonNull SelectionTracker<?> selectionTracker, @NonNull ItemDetailsLookup<?> detailsLookup, @NonNull ViewDelegate view, @NonNull AutoScroller scroller, @NonNull OperationMonitor lock) {
        Preconditions.checkArgument((selectionTracker != null ? 1 : 0) != 0);
        Preconditions.checkArgument((detailsLookup != null ? 1 : 0) != 0);
        Preconditions.checkArgument((view != null ? 1 : 0) != 0);
        Preconditions.checkArgument((scroller != null ? 1 : 0) != 0);
        Preconditions.checkArgument((lock != null ? 1 : 0) != 0);
        this.mSelectionMgr = selectionTracker;
        this.mDetailsLookup = detailsLookup;
        this.mView = view;
        this.mScroller = scroller;
        this.mLock = lock;
    }

    void start() {
        Preconditions.checkState((!this.mStarted ? 1 : 0) != 0);
        if (this.mLastStartedItemPos < 0) {
            Log.w((String)TAG, (String)"Illegal state. Can't start without valid mLastStartedItemPos.");
            return;
        }
        Preconditions.checkState((boolean)this.mSelectionMgr.isRangeActive());
        this.mLock.checkStopped();
        this.mStarted = true;
        this.mLock.start();
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView unused, @NonNull MotionEvent e) {
        if (MotionEvents.isMouseEvent(e)) {
            // empty if block
        }
        switch (e.getActionMasked()) {
            case 0: {
                return this.handleInterceptedDownEvent(e);
            }
            case 2: {
                return this.mStarted;
            }
        }
        return false;
    }

    public void onTouchEvent(@NonNull RecyclerView unused, @NonNull MotionEvent e) {
        Preconditions.checkState((boolean)this.mStarted);
        switch (e.getActionMasked()) {
            case 2: {
                this.handleMoveEvent(e);
                break;
            }
            case 1: {
                this.handleUpEvent(e);
                break;
            }
            case 3: {
                this.handleCancelEvent(e);
            }
        }
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    private boolean handleInterceptedDownEvent(@NonNull MotionEvent e) {
        if (this.mDetailsLookup.getItemDetails(e) == null) {
            return false;
        }
        this.mLastStartedItemPos = this.mView.getItemUnder(e);
        return this.mLastStartedItemPos != -1;
    }

    private void handleUpEvent(@NonNull MotionEvent e) {
        this.mSelectionMgr.mergeProvisionalSelection();
        this.endSelection();
        if (this.mLastStartedItemPos > -1) {
            this.mSelectionMgr.startRange(this.mLastStartedItemPos);
        }
    }

    private void handleCancelEvent(@NonNull MotionEvent unused) {
        this.mSelectionMgr.clearProvisionalSelection();
        this.endSelection();
    }

    private void endSelection() {
        Preconditions.checkState((boolean)this.mStarted);
        this.mLastStartedItemPos = -1;
        this.mStarted = false;
        this.mScroller.reset();
        this.mLock.stop();
    }

    private void handleMoveEvent(@NonNull MotionEvent e) {
        this.mLastInterceptedPoint = MotionEvents.getOrigin(e);
        int lastGlidedItemPos = this.mView.getLastGlidedItemPosition(e);
        if (lastGlidedItemPos != -1) {
            this.extendSelection(lastGlidedItemPos);
        }
        this.mScroller.scroll(this.mLastInterceptedPoint);
    }

    private static float getInboundY(float max, float y) {
        if (y < 0.0f) {
            return 0.0f;
        }
        if (y > max) {
            return max;
        }
        return y;
    }

    private void extendSelection(int endPos) {
        this.mSelectionMgr.extendProvisionalRange(endPos);
    }

    static GestureSelectionHelper create(@NonNull SelectionTracker<?> selectionMgr, @NonNull ItemDetailsLookup<?> detailsLookup, @NonNull RecyclerView recyclerView, @NonNull AutoScroller scroller, @NonNull OperationMonitor lock) {
        return new GestureSelectionHelper(selectionMgr, detailsLookup, new RecyclerViewDelegate(recyclerView), scroller, lock);
    }

    @VisibleForTesting
    static final class RecyclerViewDelegate
    extends ViewDelegate {
        private final RecyclerView mRecyclerView;

        RecyclerViewDelegate(@NonNull RecyclerView recyclerView) {
            Preconditions.checkArgument((recyclerView != null ? 1 : 0) != 0);
            this.mRecyclerView = recyclerView;
        }

        @Override
        int getHeight() {
            return this.mRecyclerView.getHeight();
        }

        @Override
        int getItemUnder(@NonNull MotionEvent e) {
            View child = this.mRecyclerView.findChildViewUnder(e.getX(), e.getY());
            return child != null ? this.mRecyclerView.getChildAdapterPosition(child) : -1;
        }

        @Override
        int getLastGlidedItemPosition(@NonNull MotionEvent e) {
            View lastItem = this.mRecyclerView.getLayoutManager().getChildAt(this.mRecyclerView.getLayoutManager().getChildCount() - 1);
            int direction = ViewCompat.getLayoutDirection((View)this.mRecyclerView);
            boolean pastLastItem = RecyclerViewDelegate.isPastLastItem(lastItem.getTop(), lastItem.getLeft(), lastItem.getRight(), e, direction);
            float inboundY = GestureSelectionHelper.getInboundY(this.mRecyclerView.getHeight(), e.getY());
            return pastLastItem ? this.mRecyclerView.getAdapter().getItemCount() - 1 : this.mRecyclerView.getChildAdapterPosition(this.mRecyclerView.findChildViewUnder(e.getX(), inboundY));
        }

        @VisibleForTesting
        static boolean isPastLastItem(int top, int left, int right, @NonNull MotionEvent e, int direction) {
            if (direction == 0) {
                return e.getX() > (float)right && e.getY() > (float)top;
            }
            return e.getX() < (float)left && e.getY() > (float)top;
        }
    }

    @VisibleForTesting
    static abstract class ViewDelegate {
        ViewDelegate() {
        }

        abstract int getHeight();

        abstract int getItemUnder(@NonNull MotionEvent var1);

        abstract int getLastGlidedItemPosition(@NonNull MotionEvent var1);
    }
}

