/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.FocusDelegate;
import androidx.recyclerview.selection.ItemDetailsLookup;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.selection.MotionEvents;
import androidx.recyclerview.selection.SelectionTracker;

abstract class MotionInputHandler<K>
extends GestureDetector.SimpleOnGestureListener {
    protected final SelectionTracker<K> mSelectionTracker;
    private final ItemKeyProvider<K> mKeyProvider;
    private final FocusDelegate<K> mFocusDelegate;

    MotionInputHandler(@NonNull SelectionTracker<K> selectionTracker, @NonNull ItemKeyProvider<K> keyProvider, @NonNull FocusDelegate<K> focusDelegate) {
        Preconditions.checkArgument((selectionTracker != null ? 1 : 0) != 0);
        Preconditions.checkArgument((keyProvider != null ? 1 : 0) != 0);
        Preconditions.checkArgument((focusDelegate != null ? 1 : 0) != 0);
        this.mSelectionTracker = selectionTracker;
        this.mKeyProvider = keyProvider;
        this.mFocusDelegate = focusDelegate;
    }

    final boolean selectItem(@NonNull ItemDetailsLookup.ItemDetails<K> details) {
        Preconditions.checkArgument((details != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)MotionInputHandler.hasPosition(details));
        Preconditions.checkArgument((boolean)MotionInputHandler.hasSelectionKey(details));
        if (this.mSelectionTracker.select(details.getSelectionKey())) {
            this.mSelectionTracker.anchorRange(details.getPosition());
        }
        if (this.mSelectionTracker.getSelection().size() == 1) {
            this.mFocusDelegate.focusItem(details);
        } else {
            this.mFocusDelegate.clearFocus();
        }
        return true;
    }

    protected final boolean focusItem(@NonNull ItemDetailsLookup.ItemDetails<K> details) {
        Preconditions.checkArgument((details != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)MotionInputHandler.hasSelectionKey(details));
        this.mSelectionTracker.clearSelection();
        this.mFocusDelegate.focusItem(details);
        return true;
    }

    protected final void extendSelectionRange(@NonNull ItemDetailsLookup.ItemDetails<K> details) {
        Preconditions.checkState((boolean)this.mKeyProvider.hasAccess(0));
        Preconditions.checkArgument((boolean)MotionInputHandler.hasPosition(details));
        Preconditions.checkArgument((boolean)MotionInputHandler.hasSelectionKey(details));
        this.mSelectionTracker.extendRange(details.getPosition());
        this.mFocusDelegate.focusItem(details);
    }

    final boolean isRangeExtension(@NonNull MotionEvent e) {
        return MotionEvents.isShiftKeyPressed(e) && this.mSelectionTracker.isRangeActive() && this.mKeyProvider.hasAccess(0);
    }

    boolean shouldClearSelection(@NonNull MotionEvent e, @NonNull ItemDetailsLookup.ItemDetails<K> item) {
        return !MotionEvents.isCtrlKeyPressed(e) && !item.inSelectionHotspot(e) && !this.mSelectionTracker.isSelected(item.getSelectionKey());
    }

    static boolean hasSelectionKey(@Nullable ItemDetailsLookup.ItemDetails<?> item) {
        return item != null && item.getSelectionKey() != null;
    }

    static boolean hasPosition(@Nullable ItemDetailsLookup.ItemDetails<?> item) {
        return item != null && item.getPosition() != -1;
    }
}

