/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Selection<K>
implements Iterable<K> {
    final Set<K> mSelection;
    final Set<K> mProvisionalSelection;

    Selection() {
        this.mSelection = new HashSet<K>();
        this.mProvisionalSelection = new HashSet<K>();
    }

    Selection(@NonNull Set<K> selection) {
        this.mSelection = selection;
        this.mProvisionalSelection = new HashSet<K>();
    }

    public boolean contains(@Nullable K key) {
        return this.mSelection.contains(key) || this.mProvisionalSelection.contains(key);
    }

    @Override
    public Iterator<K> iterator() {
        return this.mSelection.iterator();
    }

    public int size() {
        return this.mSelection.size() + this.mProvisionalSelection.size();
    }

    public boolean isEmpty() {
        return this.mSelection.isEmpty() && this.mProvisionalSelection.isEmpty();
    }

    Map<K, Boolean> setProvisionalSelection(@NonNull Set<K> newSelection) {
        HashMap<K, Boolean> delta = new HashMap<K, Boolean>();
        for (K k : this.mProvisionalSelection) {
            if (newSelection.contains(k) || this.mSelection.contains(k)) continue;
            delta.put(k, false);
        }
        for (K k : this.mSelection) {
            if (newSelection.contains(k)) continue;
            delta.put(k, false);
        }
        for (K k : newSelection) {
            if (this.mSelection.contains(k) || this.mProvisionalSelection.contains(k)) continue;
            delta.put(k, true);
        }
        for (Map.Entry entry : delta.entrySet()) {
            Object key = entry.getKey();
            if (((Boolean)entry.getValue()).booleanValue()) {
                this.mProvisionalSelection.add(key);
                continue;
            }
            this.mProvisionalSelection.remove(key);
        }
        return delta;
    }

    void mergeProvisionalSelection() {
        this.mSelection.addAll(this.mProvisionalSelection);
        this.mProvisionalSelection.clear();
    }

    void clearProvisionalSelection() {
        this.mProvisionalSelection.clear();
    }

    boolean add(@NonNull K key) {
        return this.mSelection.add(key);
    }

    boolean remove(@NonNull K key) {
        return this.mSelection.remove(key);
    }

    void clear() {
        this.mSelection.clear();
    }

    void copyFrom(@NonNull Selection<K> source) {
        this.mSelection.clear();
        this.mSelection.addAll(source.mSelection);
        this.mProvisionalSelection.clear();
        this.mProvisionalSelection.addAll(source.mProvisionalSelection);
    }

    public String toString() {
        if (this.size() <= 0) {
            return "size=0, items=[]";
        }
        StringBuilder buffer = new StringBuilder(this.size() * 28);
        buffer.append("Selection{").append("primary{size=" + this.mSelection.size()).append(", entries=" + this.mSelection).append("}, provisional{size=" + this.mProvisionalSelection.size()).append(", entries=" + this.mProvisionalSelection).append("}}");
        return buffer.toString();
    }

    public int hashCode() {
        return this.mSelection.hashCode() ^ this.mProvisionalSelection.hashCode();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Selection && this.isEqualTo((Selection)other);
    }

    private boolean isEqualTo(Selection other) {
        return this.mSelection.equals(other.mSelection) && this.mProvisionalSelection.equals(other.mProvisionalSelection);
    }
}

