/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.BandSelectionHelper;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.selection.SelectionTracker;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class GridModel<K> {
    static final int NOT_SET = -1;
    private static final int UPPER = 0;
    private static final int LOWER = 1;
    private static final int LEFT = 0;
    private static final int RIGHT = 2;
    private static final int UPPER_LEFT = 0;
    private static final int UPPER_RIGHT = 2;
    private static final int LOWER_LEFT = 1;
    private static final int LOWER_RIGHT = 3;
    private final GridHost<K> mHost;
    private final ItemKeyProvider<K> mKeyProvider;
    private final SelectionTracker.SelectionPredicate<K> mSelectionPredicate;
    private final List<SelectionObserver> mOnSelectionChangedListeners = new ArrayList<SelectionObserver>();
    private final SparseArray<SparseIntArray> mColumns = new SparseArray();
    private final List<Limits> mColumnBounds = new ArrayList<Limits>();
    private final List<Limits> mRowBounds = new ArrayList<Limits>();
    private final SparseBooleanArray mKnownPositions = new SparseBooleanArray();
    private final Set<K> mSelection = new HashSet<K>();
    private Point mPointer;
    private RelativePoint mRelOrigin;
    private RelativePoint mRelPointer;
    private boolean mIsActive;
    private int mPositionNearestOrigin = -1;
    private final RecyclerView.OnScrollListener mScrollListener;

    GridModel(GridHost host, ItemKeyProvider<K> keyProvider, SelectionTracker.SelectionPredicate<K> selectionPredicate) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0);
        Preconditions.checkArgument((keyProvider != null ? 1 : 0) != 0);
        Preconditions.checkArgument((selectionPredicate != null ? 1 : 0) != 0);
        this.mHost = host;
        this.mKeyProvider = keyProvider;
        this.mSelectionPredicate = selectionPredicate;
        this.mScrollListener = new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                GridModel.this.onScrolled(recyclerView, dx, dy);
            }
        };
        this.mHost.addOnScrollListener(this.mScrollListener);
    }

    void startCapturing(Point relativeOrigin) {
        this.recordVisibleChildren();
        if (this.isEmpty()) {
            return;
        }
        this.mIsActive = true;
        this.mPointer = this.mHost.createAbsolutePoint(relativeOrigin);
        this.mRelOrigin = this.createRelativePoint(this.mPointer);
        this.mRelPointer = this.createRelativePoint(this.mPointer);
        this.computeCurrentSelection();
        this.notifySelectionChanged();
    }

    void stopCapturing() {
        this.mIsActive = false;
    }

    void resizeSelection(Point relativePointer) {
        this.mPointer = this.mHost.createAbsolutePoint(relativePointer);
        this.updateModel();
    }

    int getPositionNearestOrigin() {
        return this.mPositionNearestOrigin;
    }

    void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        if (!this.mIsActive) {
            return;
        }
        this.mPointer.x += dx;
        this.mPointer.y += dy;
        this.recordVisibleChildren();
        this.updateModel();
    }

    private void recordVisibleChildren() {
        for (int i = 0; i < this.mHost.getVisibleChildCount(); ++i) {
            int adapterPosition = this.mHost.getAdapterPositionAt(i);
            if (!this.mHost.hasView(adapterPosition) || !this.mSelectionPredicate.canSetStateAtPosition(adapterPosition, true) || this.mKnownPositions.get(adapterPosition)) continue;
            this.mKnownPositions.put(adapterPosition, true);
            this.recordItemData(this.mHost.getAbsoluteRectForChildViewAt(i), adapterPosition);
        }
    }

    private boolean isEmpty() {
        return this.mColumnBounds.size() == 0 || this.mRowBounds.size() == 0;
    }

    private void recordItemData(Rect absoluteChildRect, int adapterPosition) {
        if (this.mColumnBounds.size() != this.mHost.getColumnCount()) {
            this.recordLimits(this.mColumnBounds, new Limits(absoluteChildRect.left, absoluteChildRect.right));
        }
        this.recordLimits(this.mRowBounds, new Limits(absoluteChildRect.top, absoluteChildRect.bottom));
        SparseIntArray columnList = (SparseIntArray)this.mColumns.get(absoluteChildRect.left);
        if (columnList == null) {
            columnList = new SparseIntArray();
            this.mColumns.put(absoluteChildRect.left, (Object)columnList);
        }
        columnList.put(absoluteChildRect.top, adapterPosition);
    }

    private void recordLimits(List<Limits> limitsList, Limits limits) {
        int index = Collections.binarySearch(limitsList, limits);
        if (index < 0) {
            limitsList.add(~index, limits);
        }
    }

    private void updateModel() {
        RelativePoint old = this.mRelPointer;
        this.mRelPointer = this.createRelativePoint(this.mPointer);
        if (old != null && this.mRelPointer.equals(old)) {
            return;
        }
        this.computeCurrentSelection();
        this.notifySelectionChanged();
    }

    private void computeCurrentSelection() {
        if (this.areItemsCoveredByBand(this.mRelPointer, this.mRelOrigin)) {
            this.updateSelection(this.computeBounds());
        } else {
            this.mSelection.clear();
            this.mPositionNearestOrigin = -1;
        }
    }

    private void notifySelectionChanged() {
        for (SelectionObserver listener : this.mOnSelectionChangedListeners) {
            listener.onSelectionChanged(this.mSelection);
        }
    }

    private void updateSelection(Rect rect) {
        int columnStart = Collections.binarySearch(this.mColumnBounds, new Limits(rect.left, rect.left));
        Preconditions.checkArgument((columnStart >= 0 ? 1 : 0) != 0, (Object)"Rect doesn't intesect any known column.");
        int columnEnd = columnStart;
        int i = columnStart;
        while (i < this.mColumnBounds.size() && this.mColumnBounds.get((int)i).lowerLimit <= rect.right) {
            columnEnd = i++;
        }
        int rowStart = Collections.binarySearch(this.mRowBounds, new Limits(rect.top, rect.top));
        if (rowStart < 0) {
            this.mPositionNearestOrigin = -1;
            return;
        }
        int rowEnd = rowStart;
        int i2 = rowStart;
        while (i2 < this.mRowBounds.size() && this.mRowBounds.get((int)i2).lowerLimit <= rect.bottom) {
            rowEnd = i2++;
        }
        this.updateSelection(columnStart, columnEnd, rowStart, rowEnd);
    }

    private void updateSelection(int columnStartIndex, int columnEndIndex, int rowStartIndex, int rowEndIndex) {
        this.mSelection.clear();
        for (int column = columnStartIndex; column <= columnEndIndex; ++column) {
            SparseIntArray items = (SparseIntArray)this.mColumns.get(this.mColumnBounds.get((int)column).lowerLimit);
            for (int row = rowStartIndex; row <= rowEndIndex; ++row) {
                int rowKey = this.mRowBounds.get((int)row).lowerLimit;
                int position = items.get(rowKey, -1);
                if (position == -1) continue;
                K key = this.mKeyProvider.getKey(position);
                if (key != null && this.canSelect(key)) {
                    this.mSelection.add(key);
                }
                if (!this.isPossiblePositionNearestOrigin(column, columnStartIndex, columnEndIndex, row, rowStartIndex, rowEndIndex)) continue;
                this.mPositionNearestOrigin = position;
            }
        }
    }

    private boolean canSelect(K key) {
        return this.mSelectionPredicate.canSetStateForKey(key, true);
    }

    private boolean isPossiblePositionNearestOrigin(int columnIndex, int columnStartIndex, int columnEndIndex, int rowIndex, int rowStartIndex, int rowEndIndex) {
        int corner = this.computeCornerNearestOrigin();
        switch (corner) {
            case 0: {
                return columnIndex == columnStartIndex && rowIndex == rowStartIndex;
            }
            case 2: {
                return columnIndex == columnEndIndex && rowIndex == rowStartIndex;
            }
            case 1: {
                return columnIndex == columnStartIndex && rowIndex == rowEndIndex;
            }
            case 3: {
                return rowIndex == rowEndIndex;
            }
        }
        throw new RuntimeException("Invalid corner type.");
    }

    void addOnSelectionChangedListener(SelectionObserver listener) {
        this.mOnSelectionChangedListeners.add(listener);
    }

    void onDestroy() {
        this.mOnSelectionChangedListeners.clear();
        this.mHost.removeOnScrollListener(this.mScrollListener);
    }

    RelativePoint createRelativePoint(Point point) {
        return new RelativePoint(new RelativeCoordinate(this.mColumnBounds, point.x), new RelativeCoordinate(this.mRowBounds, point.y));
    }

    private Rect computeBounds() {
        Rect rect = new Rect();
        rect.left = this.getCoordinateValue(this.min(this.mRelOrigin.mX, this.mRelPointer.mX), this.mColumnBounds, true);
        rect.right = this.getCoordinateValue(this.max(this.mRelOrigin.mX, this.mRelPointer.mX), this.mColumnBounds, false);
        rect.top = this.getCoordinateValue(this.min(this.mRelOrigin.mY, this.mRelPointer.mY), this.mRowBounds, true);
        rect.bottom = this.getCoordinateValue(this.max(this.mRelOrigin.mY, this.mRelPointer.mY), this.mRowBounds, false);
        return rect;
    }

    private int computeCornerNearestOrigin() {
        int cornerValue = 0;
        cornerValue = this.mRelOrigin.mY.equals(this.min(this.mRelOrigin.mY, this.mRelPointer.mY)) ? (cornerValue |= 0) : (cornerValue |= 1);
        cornerValue = this.mRelOrigin.mX.equals(this.min(this.mRelOrigin.mX, this.mRelPointer.mX)) ? (cornerValue |= 0) : (cornerValue |= 2);
        return cornerValue;
    }

    private RelativeCoordinate min(@NonNull RelativeCoordinate first, @NonNull RelativeCoordinate second) {
        return first.compareTo(second) < 0 ? first : second;
    }

    private RelativeCoordinate max(@NonNull RelativeCoordinate first, @NonNull RelativeCoordinate second) {
        return first.compareTo(second) > 0 ? first : second;
    }

    private int getCoordinateValue(@NonNull RelativeCoordinate coordinate, @NonNull List<Limits> limitsList, boolean isStartOfRange) {
        switch (coordinate.type) {
            case 1: {
                return limitsList.get((int)0).lowerLimit;
            }
            case 0: {
                return limitsList.get((int)(limitsList.size() - 1)).upperLimit;
            }
            case 2: {
                if (isStartOfRange) {
                    return coordinate.limitsAfterCoordinate.lowerLimit;
                }
                return coordinate.limitsBeforeCoordinate.upperLimit;
            }
            case 3: {
                return coordinate.limitsBeforeCoordinate.lowerLimit;
            }
        }
        throw new RuntimeException("Invalid coordinate value.");
    }

    private boolean areItemsCoveredByBand(@NonNull RelativePoint first, @NonNull RelativePoint second) {
        return this.doesCoordinateLocationCoverItems(first.mX, second.mX) && this.doesCoordinateLocationCoverItems(first.mY, second.mY);
    }

    private boolean doesCoordinateLocationCoverItems(@NonNull RelativeCoordinate pointerCoordinate, @NonNull RelativeCoordinate originCoordinate) {
        if (pointerCoordinate.type == 1 && originCoordinate.type == 1) {
            return false;
        }
        if (pointerCoordinate.type == 0 && originCoordinate.type == 0) {
            return false;
        }
        return pointerCoordinate.type != 2 || originCoordinate.type != 2 || !pointerCoordinate.limitsBeforeCoordinate.equals(originCoordinate.limitsBeforeCoordinate) || !pointerCoordinate.limitsAfterCoordinate.equals(originCoordinate.limitsAfterCoordinate);
    }

    static abstract class GridHost<K>
    extends BandSelectionHelper.BandHost<K> {
        GridHost() {
        }

        abstract void removeOnScrollListener(@NonNull RecyclerView.OnScrollListener var1);

        abstract Point createAbsolutePoint(@NonNull Point var1);

        abstract Rect getAbsoluteRectForChildViewAt(int var1);

        abstract int getAdapterPositionAt(int var1);

        abstract int getColumnCount();

        abstract int getVisibleChildCount();

        abstract boolean hasView(int var1);
    }

    private static class RelativePoint {
        final RelativeCoordinate mX;
        final RelativeCoordinate mY;

        RelativePoint(@NonNull List<Limits> columnLimits, @NonNull List<Limits> rowLimits, Point point) {
            this.mX = new RelativeCoordinate(columnLimits, point.x);
            this.mY = new RelativeCoordinate(rowLimits, point.y);
        }

        RelativePoint(@NonNull RelativeCoordinate x, @NonNull RelativeCoordinate y) {
            this.mX = x;
            this.mY = y;
        }

        public int hashCode() {
            return this.mX.toComparisonValue() ^ this.mY.toComparisonValue();
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof RelativePoint)) {
                return false;
            }
            RelativePoint otherPoint = (RelativePoint)other;
            return this.mX.equals(otherPoint.mX) && this.mY.equals(otherPoint.mY);
        }
    }

    private static class RelativeCoordinate
    implements Comparable<RelativeCoordinate> {
        static final int AFTER_LAST_ITEM = 0;
        static final int BEFORE_FIRST_ITEM = 1;
        static final int BETWEEN_TWO_ITEMS = 2;
        static final int WITHIN_LIMITS = 3;
        public final int type;
        public Limits limitsBeforeCoordinate;
        public Limits limitsAfterCoordinate;
        public Limits mFirstKnownItem;
        public Limits mLastKnownItem;

        RelativeCoordinate(List<Limits> limitsList, int value) {
            int index = Collections.binarySearch(limitsList, new Limits(value, value));
            if (index >= 0) {
                this.type = 3;
                this.limitsBeforeCoordinate = limitsList.get(index);
            } else if (~index == 0) {
                this.type = 1;
                this.mFirstKnownItem = limitsList.get(0);
            } else if (~index == limitsList.size()) {
                Limits lastLimits = limitsList.get(limitsList.size() - 1);
                if (lastLimits.lowerLimit <= value && value <= lastLimits.upperLimit) {
                    this.type = 3;
                    this.limitsBeforeCoordinate = lastLimits;
                } else {
                    this.type = 0;
                    this.mLastKnownItem = lastLimits;
                }
            } else {
                Limits limitsBeforeIndex = limitsList.get(~index - 1);
                if (limitsBeforeIndex.lowerLimit <= value && value <= limitsBeforeIndex.upperLimit) {
                    this.type = 3;
                    this.limitsBeforeCoordinate = limitsList.get(~index - 1);
                } else {
                    this.type = 2;
                    this.limitsBeforeCoordinate = limitsList.get(~index - 1);
                    this.limitsAfterCoordinate = limitsList.get(~index);
                }
            }
        }

        int toComparisonValue() {
            if (this.type == 1) {
                return this.mFirstKnownItem.lowerLimit - 1;
            }
            if (this.type == 0) {
                return this.mLastKnownItem.upperLimit + 1;
            }
            if (this.type == 2) {
                return this.limitsBeforeCoordinate.upperLimit + 1;
            }
            return this.limitsBeforeCoordinate.lowerLimit;
        }

        public int hashCode() {
            return this.mFirstKnownItem.lowerLimit ^ this.mLastKnownItem.upperLimit ^ this.limitsBeforeCoordinate.upperLimit ^ this.limitsBeforeCoordinate.lowerLimit;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RelativeCoordinate)) {
                return false;
            }
            RelativeCoordinate otherCoordinate = (RelativeCoordinate)other;
            return this.toComparisonValue() == otherCoordinate.toComparisonValue();
        }

        @Override
        public int compareTo(RelativeCoordinate other) {
            return this.toComparisonValue() - other.toComparisonValue();
        }
    }

    private static class Limits
    implements Comparable<Limits> {
        public int lowerLimit;
        public int upperLimit;

        Limits(int lowerLimit, int upperLimit) {
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
        }

        @Override
        public int compareTo(Limits other) {
            return this.lowerLimit - other.lowerLimit;
        }

        public int hashCode() {
            return this.lowerLimit ^ this.upperLimit;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Limits)) {
                return false;
            }
            return ((Limits)other).lowerLimit == this.lowerLimit && ((Limits)other).upperLimit == this.upperLimit;
        }

        public String toString() {
            return "(" + this.lowerLimit + ", " + this.upperLimit + ")";
        }
    }

    public static abstract class SelectionObserver<K> {
        abstract void onSelectionChanged(Set<K> var1);
    }
}

