/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.graphics.Point;
import android.view.MotionEvent;
import androidx.annotation.NonNull;

final class MotionEvents {
    private MotionEvents() {
    }

    static boolean isMouseEvent(@NonNull MotionEvent e) {
        return e.getToolType(0) == 3;
    }

    static boolean isTouchEvent(@NonNull MotionEvent e) {
        return e.getToolType(0) == 1;
    }

    static boolean isActionMove(@NonNull MotionEvent e) {
        return e.getActionMasked() == 2;
    }

    static boolean isActionDown(@NonNull MotionEvent e) {
        return e.getActionMasked() == 0;
    }

    static boolean isActionUp(@NonNull MotionEvent e) {
        return e.getActionMasked() == 1;
    }

    static boolean isActionPointerUp(@NonNull MotionEvent e) {
        return e.getActionMasked() == 6;
    }

    static boolean isActionPointerDown(@NonNull MotionEvent e) {
        return e.getActionMasked() == 5;
    }

    static boolean isActionCancel(@NonNull MotionEvent e) {
        return e.getActionMasked() == 3;
    }

    static Point getOrigin(@NonNull MotionEvent e) {
        return new Point((int)e.getX(), (int)e.getY());
    }

    static boolean isPrimaryMouseButtonPressed(@NonNull MotionEvent e) {
        return MotionEvents.isButtonPressed(e, 1);
    }

    static boolean isSecondaryMouseButtonPressed(@NonNull MotionEvent e) {
        return MotionEvents.isButtonPressed(e, 2);
    }

    static boolean isTertiaryMouseButtonPressed(@NonNull MotionEvent e) {
        return MotionEvents.isButtonPressed(e, 4);
    }

    private static boolean isButtonPressed(MotionEvent e, int button) {
        if (button == 0) {
            return false;
        }
        return (e.getButtonState() & button) == button;
    }

    static boolean isShiftKeyPressed(@NonNull MotionEvent e) {
        return MotionEvents.hasBit(e.getMetaState(), 1);
    }

    static boolean isCtrlKeyPressed(@NonNull MotionEvent e) {
        return MotionEvents.hasBit(e.getMetaState(), 4096);
    }

    static boolean isAltKeyPressed(@NonNull MotionEvent e) {
        return MotionEvents.hasBit(e.getMetaState(), 2);
    }

    static boolean isTouchpadScroll(@NonNull MotionEvent e) {
        return MotionEvents.isMouseEvent(e) && MotionEvents.isActionMove(e) && e.getButtonState() == 0;
    }

    static boolean isPointerDragEvent(MotionEvent e) {
        return MotionEvents.isPrimaryMouseButtonPressed(e) && MotionEvents.isActionMove(e);
    }

    private static boolean hasBit(int metaState, int bit) {
        return (metaState & bit) != 0;
    }
}

