/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.util.SparseArray;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.widget.RecyclerView;
import java.util.HashMap;
import java.util.Map;

public final class StableIdKeyProvider
extends ItemKeyProvider<Long> {
    private final SparseArray<Long> mPositionToKey = new SparseArray();
    private final Map<Long, Integer> mKeyToPosition = new HashMap<Long, Integer>();
    private final RecyclerView mRecyclerView;

    public StableIdKeyProvider(@NonNull RecyclerView recyclerView) {
        super(1);
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.addOnChildAttachStateChangeListener(new RecyclerView.OnChildAttachStateChangeListener(){

            public void onChildViewAttachedToWindow(View view) {
                StableIdKeyProvider.this.onAttached(view);
            }

            public void onChildViewDetachedFromWindow(View view) {
                StableIdKeyProvider.this.onDetached(view);
            }
        });
    }

    void onAttached(@NonNull View view) {
        RecyclerView.ViewHolder holder = this.mRecyclerView.findContainingViewHolder(view);
        int position = holder.getAdapterPosition();
        long id = holder.getItemId();
        if (position != -1 && id != -1L) {
            this.mPositionToKey.put(position, (Object)id);
            this.mKeyToPosition.put(id, position);
        }
    }

    void onDetached(@NonNull View view) {
        RecyclerView.ViewHolder holder = this.mRecyclerView.findContainingViewHolder(view);
        int position = holder.getAdapterPosition();
        long id = holder.getItemId();
        if (position != -1 && id != -1L) {
            this.mPositionToKey.delete(position);
            this.mKeyToPosition.remove(id);
        }
    }

    @Override
    @Nullable
    public Long getKey(int position) {
        return (Long)this.mPositionToKey.get(position, null);
    }

    @Override
    public int getPosition(@NonNull Long key) {
        if (this.mKeyToPosition.containsKey(key)) {
            return this.mKeyToPosition.get(key);
        }
        return -1;
    }
}

