/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public abstract class ItemDetailsLookup<K> {
    final boolean overItem(@NonNull MotionEvent e) {
        return this.getItemPosition(e) != -1;
    }

    final boolean overItemWithSelectionKey(@NonNull MotionEvent e) {
        return this.overItem(e) && ItemDetailsLookup.hasSelectionKey(this.getItemDetails(e));
    }

    final boolean inItemDragRegion(@NonNull MotionEvent e) {
        return this.overItem(e) && this.getItemDetails(e).inDragRegion(e);
    }

    final boolean inItemSelectRegion(@NonNull MotionEvent e) {
        return this.overItem(e) && this.getItemDetails(e).inSelectionHotspot(e);
    }

    final int getItemPosition(@NonNull MotionEvent e) {
        ItemDetails<K> item = this.getItemDetails(e);
        return item != null ? item.getPosition() : -1;
    }

    private static boolean hasSelectionKey(@Nullable ItemDetails<?> item) {
        return item != null && item.getSelectionKey() != null;
    }

    private static boolean hasPosition(@Nullable ItemDetails<?> item) {
        return item != null && item.getPosition() != -1;
    }

    @Nullable
    public abstract ItemDetails<K> getItemDetails(@NonNull MotionEvent var1);

    public static abstract class ItemDetails<K> {
        public abstract int getPosition();

        public boolean hasSelectionKey() {
            return this.getSelectionKey() != null;
        }

        @Nullable
        public abstract K getSelectionKey();

        public boolean inSelectionHotspot(@NonNull MotionEvent e) {
            return false;
        }

        public boolean inDragRegion(@NonNull MotionEvent e) {
            return false;
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof ItemDetails && this.isEqualTo((ItemDetails)obj);
        }

        private boolean isEqualTo(@NonNull ItemDetails other) {
            K key = this.getSelectionKey();
            boolean sameKeys = false;
            sameKeys = key == null ? other.getSelectionKey() == null : key.equals(other.getSelectionKey());
            return sameKeys && this.getPosition() == other.getPosition();
        }

        public int hashCode() {
            return this.getPosition() >>> 8;
        }
    }
}

