/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

public final class OperationMonitor {
    private static final String TAG = "OperationMonitor";
    private int mNumOps = 0;
    private List<OnChangeListener> mListeners = new ArrayList<OnChangeListener>();

    @MainThread
    synchronized void start() {
        ++this.mNumOps;
        if (this.mNumOps == 1) {
            for (OnChangeListener l : this.mListeners) {
                l.onChanged();
            }
        }
    }

    @MainThread
    synchronized void stop() {
        Preconditions.checkState((this.mNumOps > 0 ? 1 : 0) != 0);
        --this.mNumOps;
        if (this.mNumOps == 0) {
            for (OnChangeListener l : this.mListeners) {
                l.onChanged();
            }
        }
    }

    public synchronized boolean isStarted() {
        return this.mNumOps > 0;
    }

    public void addListener(@NonNull OnChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0);
        this.mListeners.add(listener);
    }

    public void removeListener(@NonNull OnChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0);
        this.mListeners.remove(listener);
    }

    void checkStarted() {
        Preconditions.checkState((this.mNumOps > 0 ? 1 : 0) != 0);
    }

    void checkStopped() {
        Preconditions.checkState((this.mNumOps == 0 ? 1 : 0) != 0);
    }

    public static interface OnChangeListener {
        public void onChanged();
    }
}

