/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.ToolHandlerRegistry;
import androidx.recyclerview.widget.RecyclerView;

final class TouchEventRouter
implements RecyclerView.OnItemTouchListener {
    private static final String TAG = "TouchEventRouter";
    private final GestureDetector mDetector;
    private final ToolHandlerRegistry<RecyclerView.OnItemTouchListener> mDelegates;

    TouchEventRouter(@NonNull GestureDetector detector, @NonNull RecyclerView.OnItemTouchListener defaultDelegate) {
        Preconditions.checkArgument((detector != null ? 1 : 0) != 0);
        Preconditions.checkArgument((defaultDelegate != null ? 1 : 0) != 0);
        this.mDetector = detector;
        this.mDelegates = new ToolHandlerRegistry<RecyclerView.OnItemTouchListener>(defaultDelegate);
    }

    TouchEventRouter(@NonNull GestureDetector detector) {
        this(detector, new RecyclerView.OnItemTouchListener(){

            public boolean onInterceptTouchEvent(@NonNull RecyclerView unused, @NonNull MotionEvent e) {
                return false;
            }

            public void onTouchEvent(@NonNull RecyclerView unused, @NonNull MotionEvent e) {
            }

            public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            }
        });
    }

    void register(int toolType, @NonNull RecyclerView.OnItemTouchListener delegate) {
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0);
        this.mDelegates.set(toolType, delegate);
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        boolean handled = this.mDelegates.get(e).onInterceptTouchEvent(rv, e);
        return handled |= this.mDetector.onTouchEvent(e);
    }

    public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        this.mDelegates.get(e).onTouchEvent(rv, e);
        this.mDetector.onTouchEvent(e);
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }
}

