/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Preconditions;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.selection.AutoScroller;
import androidx.recyclerview.selection.MotionEvents;
import androidx.recyclerview.selection.OperationMonitor;
import androidx.recyclerview.selection.SelectionTracker;
import androidx.recyclerview.widget.RecyclerView;

final class GestureSelectionHelper
implements RecyclerView.OnItemTouchListener {
    private static final String TAG = "GestureSelectionHelper";
    private final SelectionTracker<?> mSelectionMgr;
    private final SelectionTracker.SelectionPredicate<?> mSelectionPredicate;
    private final AutoScroller mScroller;
    private final ViewDelegate mView;
    private final OperationMonitor mLock;
    private boolean mStarted = false;

    GestureSelectionHelper(@NonNull SelectionTracker<?> selectionTracker, @NonNull SelectionTracker.SelectionPredicate<?> selectionPredicate, @NonNull ViewDelegate view, @NonNull AutoScroller scroller, @NonNull OperationMonitor lock) {
        Preconditions.checkArgument((selectionTracker != null ? 1 : 0) != 0);
        Preconditions.checkArgument((selectionPredicate != null ? 1 : 0) != 0);
        Preconditions.checkArgument((view != null ? 1 : 0) != 0);
        Preconditions.checkArgument((scroller != null ? 1 : 0) != 0);
        Preconditions.checkArgument((lock != null ? 1 : 0) != 0);
        this.mSelectionMgr = selectionTracker;
        this.mSelectionPredicate = selectionPredicate;
        this.mView = view;
        this.mScroller = scroller;
        this.mLock = lock;
    }

    void start() {
        Preconditions.checkState((!this.mStarted ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.mSelectionMgr.isRangeActive());
        this.mLock.checkStopped();
        this.mStarted = true;
        this.mLock.start();
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView unused, @NonNull MotionEvent e) {
        switch (e.getActionMasked()) {
            case 1: 
            case 2: 
            case 3: {
                return this.mStarted;
            }
        }
        return false;
    }

    public void onTouchEvent(@NonNull RecyclerView unused, @NonNull MotionEvent e) {
        this.handleTouch(e);
    }

    private boolean handleTouch(MotionEvent e) {
        if (!this.mStarted) {
            return false;
        }
        if (!this.mSelectionMgr.isRangeActive()) {
            Log.e((String)TAG, (String)"Internal state of GestureSelectionHelper out of sync w/ SelectionTracker (isRangeActive is false). Ignoring event and resetting state.");
            this.endSelection();
            return false;
        }
        switch (e.getActionMasked()) {
            case 2: {
                this.handleMoveEvent(e);
                return true;
            }
            case 1: {
                this.handleUpEvent();
                return true;
            }
            case 3: {
                this.handleCancelEvent();
                return true;
            }
        }
        return false;
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    private void handleUpEvent() {
        this.mSelectionMgr.mergeProvisionalSelection();
        this.endSelection();
    }

    private void handleCancelEvent() {
        this.mSelectionMgr.clearProvisionalSelection();
        this.endSelection();
    }

    private void endSelection() {
        Preconditions.checkState((boolean)this.mStarted);
        this.mStarted = false;
        this.mScroller.reset();
        this.mLock.stop();
    }

    private void handleMoveEvent(@NonNull MotionEvent e) {
        int lastGlidedItemPos = this.mView.getLastGlidedItemPosition(e);
        if (this.mSelectionPredicate.canSetStateAtPosition(lastGlidedItemPos, true)) {
            this.extendSelection(lastGlidedItemPos);
        }
        this.mScroller.scroll(MotionEvents.getOrigin(e));
    }

    static float getInboundY(float max, float y) {
        if (y < 0.0f) {
            return 0.0f;
        }
        if (y > max) {
            return max;
        }
        return y;
    }

    private void extendSelection(int endPos) {
        this.mSelectionMgr.extendProvisionalRange(endPos);
    }

    static GestureSelectionHelper create(@NonNull SelectionTracker<?> selectionMgr, @NonNull SelectionTracker.SelectionPredicate<?> selectionPredicate, @NonNull RecyclerView recyclerView, @NonNull AutoScroller scroller, @NonNull OperationMonitor lock) {
        return new GestureSelectionHelper(selectionMgr, selectionPredicate, new RecyclerViewDelegate(recyclerView), scroller, lock);
    }

    @VisibleForTesting
    static final class RecyclerViewDelegate
    extends ViewDelegate {
        private final RecyclerView mRecyclerView;

        RecyclerViewDelegate(@NonNull RecyclerView recyclerView) {
            Preconditions.checkArgument((recyclerView != null ? 1 : 0) != 0);
            this.mRecyclerView = recyclerView;
        }

        @Override
        int getHeight() {
            return this.mRecyclerView.getHeight();
        }

        @Override
        int getItemUnder(@NonNull MotionEvent e) {
            View child = this.mRecyclerView.findChildViewUnder(e.getX(), e.getY());
            return child != null ? this.mRecyclerView.getChildAdapterPosition(child) : -1;
        }

        @Override
        int getLastGlidedItemPosition(@NonNull MotionEvent e) {
            View lastItem = this.mRecyclerView.getLayoutManager().getChildAt(this.mRecyclerView.getLayoutManager().getChildCount() - 1);
            int direction = ViewCompat.getLayoutDirection((View)this.mRecyclerView);
            boolean pastLastItem = RecyclerViewDelegate.isPastLastItem(lastItem.getTop(), lastItem.getLeft(), lastItem.getRight(), e, direction);
            float inboundY = GestureSelectionHelper.getInboundY(this.mRecyclerView.getHeight(), e.getY());
            return pastLastItem ? this.mRecyclerView.getAdapter().getItemCount() - 1 : this.mRecyclerView.getChildAdapterPosition(this.mRecyclerView.findChildViewUnder(e.getX(), inboundY));
        }

        @VisibleForTesting
        static boolean isPastLastItem(int top, int left, int right, @NonNull MotionEvent e, int direction) {
            if (direction == 0) {
                return e.getX() > (float)right && e.getY() > (float)top;
            }
            return e.getX() < (float)left && e.getY() > (float)top;
        }
    }

    @VisibleForTesting
    static abstract class ViewDelegate {
        ViewDelegate() {
        }

        abstract int getHeight();

        abstract int getItemUnder(@NonNull MotionEvent var1);

        abstract int getLastGlidedItemPosition(@NonNull MotionEvent var1);
    }
}

