/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;

final class Range {
    static final int TYPE_PRIMARY = 0;
    static final int TYPE_PROVISIONAL = 1;
    private static final String TAG = "Range";
    private final Callbacks mCallbacks;
    private final int mBegin;
    private int mEnd = -1;

    Range(int position, @NonNull Callbacks callbacks) {
        this.mBegin = position;
        this.mCallbacks = callbacks;
    }

    void extendRange(int position, int type) {
        Preconditions.checkArgument((position != -1 ? 1 : 0) != 0, (Object)"Position cannot be NO_POSITION.");
        if (this.mEnd == -1 || this.mEnd == this.mBegin) {
            this.mEnd = -1;
            this.establishRange(position, type);
        } else {
            this.reviseRange(position, type);
        }
    }

    private void establishRange(int position, int type) {
        Preconditions.checkArgument((this.mEnd == -1 ? 1 : 0) != 0, (Object)"End has already been set.");
        this.mEnd = position;
        if (position > this.mBegin) {
            this.updateRange(this.mBegin + 1, position, true, type);
        } else if (position < this.mBegin) {
            this.updateRange(position, this.mBegin - 1, true, type);
        }
    }

    private void reviseRange(int position, int type) {
        Preconditions.checkArgument((this.mEnd != -1 ? 1 : 0) != 0, (Object)"End must already be set.");
        Preconditions.checkArgument((this.mBegin != this.mEnd ? 1 : 0) != 0, (Object)"Beging and end point to same position.");
        if (position == this.mEnd) {
            // empty if block
        }
        if (this.mEnd > this.mBegin) {
            this.reviseAscending(position, type);
        } else if (this.mEnd < this.mBegin) {
            this.reviseDescending(position, type);
        }
        this.mEnd = position;
    }

    private void reviseAscending(int position, int type) {
        if (position < this.mEnd) {
            if (position < this.mBegin) {
                this.updateRange(this.mBegin + 1, this.mEnd, false, type);
                this.updateRange(position, this.mBegin - 1, true, type);
            } else {
                this.updateRange(position + 1, this.mEnd, false, type);
            }
        } else if (position > this.mEnd) {
            this.updateRange(this.mEnd + 1, position, true, type);
        }
    }

    private void reviseDescending(int position, int type) {
        if (position > this.mEnd) {
            if (position > this.mBegin) {
                this.updateRange(this.mEnd, this.mBegin - 1, false, type);
                this.updateRange(this.mBegin + 1, position, true, type);
            } else {
                this.updateRange(this.mEnd, position - 1, false, type);
            }
        } else if (position < this.mEnd) {
            this.updateRange(position, this.mEnd - 1, true, type);
        }
    }

    private void updateRange(int begin, int end, boolean selected, int type) {
        this.mCallbacks.updateForRange(begin, end, selected, type);
    }

    public String toString() {
        return "Range{begin=" + this.mBegin + ", end=" + this.mEnd + "}";
    }

    private void log(int type, String message) {
        String opType = type == 0 ? "PRIMARY" : "PROVISIONAL";
        Log.d((String)TAG, (String)(String.valueOf(this) + ": " + message + " (" + opType + ")"));
    }

    static abstract class Callbacks {
        Callbacks() {
        }

        abstract void updateForRange(int var1, int var2, boolean var3, int var4);
    }
}

