/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.DummyOnItemTouchListener;
import androidx.recyclerview.selection.ToolHandlerRegistry;
import androidx.recyclerview.widget.RecyclerView;

final class EventRouter
implements RecyclerView.OnItemTouchListener {
    private final ToolHandlerRegistry<RecyclerView.OnItemTouchListener> mDelegates = new ToolHandlerRegistry<DummyOnItemTouchListener>(new DummyOnItemTouchListener());

    EventRouter() {
    }

    void set(int toolType, @NonNull RecyclerView.OnItemTouchListener delegate) {
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0);
        this.mDelegates.set(toolType, delegate);
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        return this.mDelegates.get(e).onInterceptTouchEvent(rv, e);
    }

    public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        this.mDelegates.get(e).onTouchEvent(rv, e);
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }
}

