/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.util.Log;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.FocusDelegate;
import androidx.recyclerview.selection.ItemDetailsLookup;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.selection.MotionEvents;
import androidx.recyclerview.selection.MotionInputHandler;
import androidx.recyclerview.selection.OnContextClickListener;
import androidx.recyclerview.selection.OnItemActivatedListener;
import androidx.recyclerview.selection.SelectionTracker;

final class MouseInputHandler<K>
extends MotionInputHandler<K> {
    private static final String TAG = "MouseInputDelegate";
    private final ItemDetailsLookup<K> mDetailsLookup;
    private final OnContextClickListener mOnContextClickListener;
    private final OnItemActivatedListener<K> mOnItemActivatedListener;
    private final FocusDelegate<K> mFocusDelegate;
    private boolean mHandledTapUp;
    private boolean mHandledOnDown;

    MouseInputHandler(@NonNull SelectionTracker<K> selectionTracker, @NonNull ItemKeyProvider<K> keyProvider, @NonNull ItemDetailsLookup<K> detailsLookup, @NonNull OnContextClickListener onContextClickListener, @NonNull OnItemActivatedListener<K> onItemActivatedListener, @NonNull FocusDelegate<K> focusDelegate) {
        super(selectionTracker, keyProvider, focusDelegate);
        Preconditions.checkArgument((detailsLookup != null ? 1 : 0) != 0);
        Preconditions.checkArgument((onContextClickListener != null ? 1 : 0) != 0);
        Preconditions.checkArgument((onItemActivatedListener != null ? 1 : 0) != 0);
        this.mDetailsLookup = detailsLookup;
        this.mOnContextClickListener = onContextClickListener;
        this.mOnItemActivatedListener = onItemActivatedListener;
        this.mFocusDelegate = focusDelegate;
    }

    public boolean onDown(@NonNull MotionEvent e) {
        if (MotionEvents.isAltKeyPressed(e) && MotionEvents.isPrimaryMouseButtonPressed(e) || MotionEvents.isSecondaryMouseButtonPressed(e)) {
            this.mHandledOnDown = true;
            return this.onRightClick(e);
        }
        return false;
    }

    public boolean onScroll(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float distanceX, float distanceY) {
        return !MotionEvents.isTouchpadScroll(e2);
    }

    public boolean onSingleTapUp(@NonNull MotionEvent e) {
        if (this.mHandledOnDown) {
            this.mHandledOnDown = false;
            return false;
        }
        if (!this.mDetailsLookup.overItemWithSelectionKey(e)) {
            this.mSelectionTracker.clearSelection();
            this.mFocusDelegate.clearFocus();
            return false;
        }
        if (MotionEvents.isTertiaryMouseButtonPressed(e)) {
            return false;
        }
        if (this.mSelectionTracker.hasSelection()) {
            this.onItemClick(e, this.mDetailsLookup.getItemDetails(e));
            this.mHandledTapUp = true;
            return true;
        }
        return false;
    }

    private void onItemClick(@NonNull MotionEvent e, @NonNull ItemDetailsLookup.ItemDetails<K> item) {
        if (!this.mSelectionTracker.hasSelection()) {
            Log.e((String)TAG, (String)"Call to onItemClick w/o selection.");
            return;
        }
        Preconditions.checkArgument((item != null ? 1 : 0) != 0);
        if (this.shouldExtendRange(e)) {
            this.extendSelectionRange(item);
        } else {
            if (this.shouldClearSelection(e, item)) {
                this.mSelectionTracker.clearSelection();
            }
            if (this.mSelectionTracker.isSelected(item.getSelectionKey())) {
                if (this.mSelectionTracker.deselect(item.getSelectionKey())) {
                    this.mFocusDelegate.clearFocus();
                }
            } else {
                this.selectOrFocusItem(item, e);
            }
        }
    }

    public boolean onSingleTapConfirmed(@NonNull MotionEvent e) {
        if (this.mHandledTapUp) {
            this.mHandledTapUp = false;
            return false;
        }
        if (this.mSelectionTracker.hasSelection()) {
            return false;
        }
        if (!this.mDetailsLookup.overItem(e)) {
            return false;
        }
        if (MotionEvents.isTertiaryMouseButtonPressed(e)) {
            return false;
        }
        ItemDetailsLookup.ItemDetails<K> item = this.mDetailsLookup.getItemDetails(e);
        if (item == null || !item.hasSelectionKey()) {
            return false;
        }
        if (this.mFocusDelegate.hasFocusedItem() && MotionEvents.isShiftKeyPressed(e)) {
            this.mSelectionTracker.startRange(this.mFocusDelegate.getFocusedPosition());
            this.mSelectionTracker.extendRange(item.getPosition());
        } else {
            this.selectOrFocusItem(item, e);
        }
        return true;
    }

    public boolean onDoubleTap(@NonNull MotionEvent e) {
        this.mHandledTapUp = false;
        if (!this.mDetailsLookup.overItemWithSelectionKey(e)) {
            return false;
        }
        if (MotionEvents.isTertiaryMouseButtonPressed(e)) {
            return false;
        }
        ItemDetailsLookup.ItemDetails<K> item = this.mDetailsLookup.getItemDetails(e);
        return item != null && this.mOnItemActivatedListener.onItemActivated(item, e);
    }

    private boolean onRightClick(@NonNull MotionEvent e) {
        ItemDetailsLookup.ItemDetails<K> item;
        if (this.mDetailsLookup.overItemWithSelectionKey(e) && (item = this.mDetailsLookup.getItemDetails(e)) != null && !this.mSelectionTracker.isSelected(item.getSelectionKey())) {
            this.mSelectionTracker.clearSelection();
            this.selectItem(item);
        }
        return this.mOnContextClickListener.onContextClick(e);
    }

    private void selectOrFocusItem(@NonNull ItemDetailsLookup.ItemDetails<K> item, @NonNull MotionEvent e) {
        if (item.inSelectionHotspot(e) || MotionEvents.isCtrlKeyPressed(e)) {
            this.selectItem(item);
        } else {
            this.focusItem(item);
        }
    }
}

