/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.recyclerview.selection.MotionEvents;
import androidx.recyclerview.selection.Resettable;
import androidx.recyclerview.selection.SelectionTracker;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;

final class ResetManager<K> {
    private static final String TAG = "ResetManager";
    private final List<Resettable> mResetHandlers = new ArrayList<Resettable>();
    private final RecyclerView.OnItemTouchListener mInputListener = new RecyclerView.OnItemTouchListener(){

        public boolean onInterceptTouchEvent(@NonNull RecyclerView unused, @NonNull MotionEvent e) {
            if (MotionEvents.isActionCancel(e)) {
                ResetManager.this.callResetHandlers();
            }
            return false;
        }

        public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        }

        public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        }
    };
    private final SelectionTracker.SelectionObserver<K> mSelectionObserver = new SelectionTracker.SelectionObserver<K>(){

        @Override
        protected void onSelectionCleared() {
            ResetManager.this.callResetHandlers();
        }
    };

    ResetManager() {
    }

    SelectionTracker.SelectionObserver<K> getSelectionObserver() {
        return this.mSelectionObserver;
    }

    RecyclerView.OnItemTouchListener getInputListener() {
        return this.mInputListener;
    }

    void addResetHandler(@NonNull Resettable handler) {
        this.mResetHandlers.add(handler);
    }

    void callResetHandlers() {
        for (Resettable handler : this.mResetHandlers) {
            if (!handler.isResetRequired()) continue;
            handler.reset();
        }
    }
}

