/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.MotionEvents;
import androidx.recyclerview.selection.Resettable;
import androidx.recyclerview.widget.RecyclerView;

final class GestureDetectorWrapper
implements RecyclerView.OnItemTouchListener,
Resettable {
    private final GestureDetector mDetector;
    private boolean mDisallowIntercept;

    GestureDetectorWrapper(@NonNull GestureDetector detector) {
        Preconditions.checkArgument((detector != null ? 1 : 0) != 0);
        this.mDetector = detector;
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        if (this.mDisallowIntercept && MotionEvents.isActionDown(e)) {
            this.mDisallowIntercept = false;
        }
        return !this.mDisallowIntercept && this.mDetector.onTouchEvent(e);
    }

    public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (!disallowIntercept) {
            return;
        }
        this.mDisallowIntercept = disallowIntercept;
        this.sendCancelEvent();
    }

    @Override
    public boolean isResetRequired() {
        return true;
    }

    @Override
    public void reset() {
        this.mDisallowIntercept = false;
        this.sendCancelEvent();
    }

    private void sendCancelEvent() {
        this.mDetector.onTouchEvent(MotionEvents.createCancelEvent());
    }
}

