/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.BandPredicate;
import androidx.recyclerview.selection.BandSelectionHelper;
import androidx.recyclerview.selection.DefaultSelectionTracker;
import androidx.recyclerview.selection.EventBridge;
import androidx.recyclerview.selection.EventRouter;
import androidx.recyclerview.selection.FocusDelegate;
import androidx.recyclerview.selection.GestureDetectorWrapper;
import androidx.recyclerview.selection.GestureRouter;
import androidx.recyclerview.selection.GestureSelectionHelper;
import androidx.recyclerview.selection.ItemDetailsLookup;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.selection.MotionInputHandler;
import androidx.recyclerview.selection.MouseInputHandler;
import androidx.recyclerview.selection.MutableSelection;
import androidx.recyclerview.selection.OnContextClickListener;
import androidx.recyclerview.selection.OnDragInitiatedListener;
import androidx.recyclerview.selection.OnItemActivatedListener;
import androidx.recyclerview.selection.OperationMonitor;
import androidx.recyclerview.selection.PointerDragEventInterceptor;
import androidx.recyclerview.selection.R;
import androidx.recyclerview.selection.ResetManager;
import androidx.recyclerview.selection.Selection;
import androidx.recyclerview.selection.SelectionPredicates;
import androidx.recyclerview.selection.StorageStrategy;
import androidx.recyclerview.selection.TouchInputHandler;
import androidx.recyclerview.selection.ViewAutoScroller;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Set;

public abstract class SelectionTracker<K> {
    private static final String TAG = "SelectionTracker";
    public static final String SELECTION_CHANGED_MARKER = "Selection-Changed";

    public abstract void addObserver(@NonNull SelectionObserver<K> var1);

    public abstract boolean hasSelection();

    @NonNull
    public abstract Selection<K> getSelection();

    public abstract void copySelection(@NonNull MutableSelection<K> var1);

    public abstract boolean isSelected(@Nullable K var1);

    protected abstract void restoreSelection(@NonNull Selection<K> var1);

    public abstract boolean clearSelection();

    public abstract boolean setItemsSelected(@NonNull Iterable<K> var1, boolean var2);

    public abstract boolean select(@NonNull K var1);

    public abstract boolean deselect(@NonNull K var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    protected abstract RecyclerView.AdapterDataObserver getAdapterDataObserver();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public abstract void startRange(int var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public abstract void extendRange(int var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public abstract void endRange();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public abstract boolean isRangeActive();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public abstract void anchorRange(int var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected abstract void extendProvisionalRange(int var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected abstract void setProvisionalSelection(@NonNull Set<K> var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected abstract void clearProvisionalSelection();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected abstract void mergeProvisionalSelection();

    public abstract void onSaveInstanceState(@NonNull Bundle var1);

    public abstract void onRestoreInstanceState(@Nullable Bundle var1);

    public static final class Builder<K> {
        final RecyclerView mRecyclerView;
        private final RecyclerView.Adapter<?> mAdapter;
        private final Context mContext;
        private final String mSelectionId;
        private final StorageStrategy<K> mStorage;
        SelectionPredicate<K> mSelectionPredicate = SelectionPredicates.createSelectAnything();
        private OperationMonitor mMonitor = new OperationMonitor();
        private ItemKeyProvider<K> mKeyProvider;
        private ItemDetailsLookup<K> mDetailsLookup;
        private FocusDelegate<K> mFocusDelegate = FocusDelegate.dummy();
        private OnItemActivatedListener<K> mOnItemActivatedListener;
        private OnDragInitiatedListener mOnDragInitiatedListener;
        private OnContextClickListener mOnContextClickListener;
        private BandPredicate mBandPredicate;
        private int mBandOverlayId = R.drawable.selection_band_overlay;
        private int[] mGestureToolTypes = new int[]{1};
        private int[] mPointerToolTypes = new int[]{3};

        public Builder(@NonNull String selectionId, @NonNull RecyclerView recyclerView, @NonNull ItemKeyProvider<K> keyProvider, @NonNull ItemDetailsLookup<K> detailsLookup, @NonNull StorageStrategy<K> storage) {
            Preconditions.checkArgument((selectionId != null ? 1 : 0) != 0);
            Preconditions.checkArgument((!selectionId.trim().isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((recyclerView != null ? 1 : 0) != 0);
            this.mSelectionId = selectionId;
            this.mRecyclerView = recyclerView;
            this.mContext = recyclerView.getContext();
            this.mAdapter = recyclerView.getAdapter();
            Preconditions.checkArgument((this.mAdapter != null ? 1 : 0) != 0);
            Preconditions.checkArgument((keyProvider != null ? 1 : 0) != 0);
            Preconditions.checkArgument((detailsLookup != null ? 1 : 0) != 0);
            Preconditions.checkArgument((storage != null ? 1 : 0) != 0);
            this.mDetailsLookup = detailsLookup;
            this.mKeyProvider = keyProvider;
            this.mStorage = storage;
            this.mBandPredicate = new BandPredicate.NonDraggableArea(this.mRecyclerView, detailsLookup);
        }

        @NonNull
        public Builder<K> withSelectionPredicate(@NonNull SelectionPredicate<K> predicate) {
            Preconditions.checkArgument((predicate != null ? 1 : 0) != 0);
            this.mSelectionPredicate = predicate;
            return this;
        }

        @NonNull
        public Builder<K> withOperationMonitor(@NonNull OperationMonitor monitor) {
            Preconditions.checkArgument((monitor != null ? 1 : 0) != 0);
            this.mMonitor = monitor;
            return this;
        }

        @NonNull
        public Builder<K> withFocusDelegate(@NonNull FocusDelegate<K> delegate) {
            Preconditions.checkArgument((delegate != null ? 1 : 0) != 0);
            this.mFocusDelegate = delegate;
            return this;
        }

        @NonNull
        public Builder<K> withOnItemActivatedListener(@NonNull OnItemActivatedListener<K> listener) {
            Preconditions.checkArgument((listener != null ? 1 : 0) != 0);
            this.mOnItemActivatedListener = listener;
            return this;
        }

        @NonNull
        public Builder<K> withOnContextClickListener(@NonNull OnContextClickListener listener) {
            Preconditions.checkArgument((listener != null ? 1 : 0) != 0);
            this.mOnContextClickListener = listener;
            return this;
        }

        @NonNull
        public Builder<K> withOnDragInitiatedListener(@NonNull OnDragInitiatedListener listener) {
            Preconditions.checkArgument((listener != null ? 1 : 0) != 0);
            this.mOnDragInitiatedListener = listener;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder<K> withGestureTooltypes(int ... toolTypes) {
            Log.w((String)SelectionTracker.TAG, (String)"Setting gestureTooltypes is likely to result in unexpected behavior.");
            this.mGestureToolTypes = toolTypes;
            return this;
        }

        @NonNull
        public Builder<K> withBandOverlay(@DrawableRes int bandOverlayId) {
            this.mBandOverlayId = bandOverlayId;
            return this;
        }

        @NonNull
        public Builder<K> withBandPredicate(@NonNull BandPredicate bandPredicate) {
            this.mBandPredicate = bandPredicate;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder<K> withPointerTooltypes(int ... toolTypes) {
            Log.w((String)SelectionTracker.TAG, (String)"Setting pointerTooltypes is likely to result in unexpected behavior.");
            this.mPointerToolTypes = toolTypes;
            return this;
        }

        @NonNull
        public SelectionTracker<K> build() {
            DefaultSelectionTracker tracker = new DefaultSelectionTracker(this.mSelectionId, this.mKeyProvider, this.mSelectionPredicate, this.mStorage);
            EventBridge.install(this.mAdapter, tracker, this.mKeyProvider, (Consumer<Runnable>)((Consumer)arg_0 -> ((RecyclerView)this.mRecyclerView).post(arg_0)));
            ViewAutoScroller scroller = new ViewAutoScroller(ViewAutoScroller.createScrollHost(this.mRecyclerView));
            GestureRouter<MotionInputHandler> gestureRouter = new GestureRouter<MotionInputHandler>();
            GestureDetector gestureDetector = new GestureDetector(this.mContext, gestureRouter);
            final GestureSelectionHelper gestureSelectionHelper = GestureSelectionHelper.create(tracker, this.mSelectionPredicate, this.mRecyclerView, scroller, this.mMonitor);
            EventRouter eventRouter = new EventRouter();
            GestureDetectorWrapper gestureDetectorWrapper = new GestureDetectorWrapper(gestureDetector);
            this.mRecyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)eventRouter);
            this.mRecyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)gestureDetectorWrapper);
            ResetManager resetMgr = new ResetManager();
            tracker.addObserver(resetMgr.getSelectionObserver());
            eventRouter.set(0, resetMgr.getInputListener());
            resetMgr.addResetHandler(tracker);
            resetMgr.addResetHandler(this.mMonitor.asResettable());
            resetMgr.addResetHandler(gestureSelectionHelper);
            resetMgr.addResetHandler(gestureDetectorWrapper);
            resetMgr.addResetHandler(eventRouter);
            this.mOnDragInitiatedListener = this.mOnDragInitiatedListener != null ? this.mOnDragInitiatedListener : new OnDragInitiatedListener(){

                @Override
                public boolean onDragInitiated(@NonNull MotionEvent e) {
                    return false;
                }
            };
            this.mOnItemActivatedListener = this.mOnItemActivatedListener != null ? this.mOnItemActivatedListener : new OnItemActivatedListener<K>(){

                @Override
                public boolean onItemActivated(@NonNull ItemDetailsLookup.ItemDetails<K> item, @NonNull MotionEvent e) {
                    return false;
                }
            };
            this.mOnContextClickListener = this.mOnContextClickListener != null ? this.mOnContextClickListener : new OnContextClickListener(){

                @Override
                public boolean onContextClick(@NonNull MotionEvent e) {
                    return false;
                }
            };
            TouchInputHandler<K> touchHandler = new TouchInputHandler<K>(tracker, this.mKeyProvider, this.mDetailsLookup, this.mSelectionPredicate, new Runnable(){

                @Override
                public void run() {
                    if (mSelectionPredicate.canSelectMultiple()) {
                        gestureSelectionHelper.start();
                    }
                }
            }, this.mOnDragInitiatedListener, this.mOnItemActivatedListener, this.mFocusDelegate, new Runnable(){

                @Override
                public void run() {
                    mRecyclerView.performHapticFeedback(0);
                }
            });
            for (int toolType : this.mGestureToolTypes) {
                gestureRouter.register(toolType, touchHandler);
                eventRouter.set(toolType, gestureSelectionHelper);
            }
            MouseInputHandler<K> mouseHandler = new MouseInputHandler<K>(tracker, this.mKeyProvider, this.mDetailsLookup, this.mOnContextClickListener, this.mOnItemActivatedListener, this.mFocusDelegate);
            for (int toolType : this.mPointerToolTypes) {
                gestureRouter.register(toolType, mouseHandler);
            }
            BandSelectionHelper<K> bandHelper = null;
            if (this.mKeyProvider.hasAccess(0) && this.mSelectionPredicate.canSelectMultiple()) {
                bandHelper = BandSelectionHelper.create(this.mRecyclerView, scroller, this.mBandOverlayId, this.mKeyProvider, tracker, this.mSelectionPredicate, this.mBandPredicate, this.mFocusDelegate, this.mMonitor);
                resetMgr.addResetHandler(bandHelper);
            }
            PointerDragEventInterceptor pointerEventHandler = new PointerDragEventInterceptor(this.mDetailsLookup, this.mOnDragInitiatedListener, bandHelper);
            eventRouter.set(3, pointerEventHandler);
            return tracker;
        }
    }

    public static abstract class SelectionPredicate<K> {
        public abstract boolean canSetStateForKey(@NonNull K var1, boolean var2);

        public abstract boolean canSetStateAtPosition(int var1, boolean var2);

        public abstract boolean canSelectMultiple();
    }

    public static abstract class SelectionObserver<K> {
        public void onItemStateChanged(@NonNull K key, boolean selected) {
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        protected void onSelectionCleared() {
        }

        public void onSelectionRefresh() {
        }

        public void onSelectionChanged() {
        }

        public void onSelectionRestored() {
        }
    }
}

