/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.FocusDelegate;
import androidx.recyclerview.selection.ItemDetailsLookup;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.selection.MotionEvents;
import androidx.recyclerview.selection.MotionInputHandler;
import androidx.recyclerview.selection.OnDragInitiatedListener;
import androidx.recyclerview.selection.OnItemActivatedListener;
import androidx.recyclerview.selection.SelectionTracker;

final class TouchInputHandler<K>
extends MotionInputHandler<K> {
    private static final String TAG = "TouchInputHandler";
    private final ItemDetailsLookup<K> mDetailsLookup;
    private final SelectionTracker.SelectionPredicate<K> mSelectionPredicate;
    private final OnItemActivatedListener<K> mOnItemActivatedListener;
    private final OnDragInitiatedListener mOnDragInitiatedListener;
    private final Runnable mGestureStarter;
    private final Runnable mHapticPerformer;

    TouchInputHandler(@NonNull SelectionTracker<K> selectionTracker, @NonNull ItemKeyProvider<K> keyProvider, @NonNull ItemDetailsLookup<K> detailsLookup, @NonNull SelectionTracker.SelectionPredicate<K> selectionPredicate, @NonNull Runnable gestureStarter, @NonNull OnDragInitiatedListener onDragInitiatedListener, @NonNull OnItemActivatedListener<K> onItemActivatedListener, @NonNull FocusDelegate<K> focusDelegate, @NonNull Runnable hapticPerformer) {
        super(selectionTracker, keyProvider, focusDelegate);
        Preconditions.checkArgument((detailsLookup != null ? 1 : 0) != 0);
        Preconditions.checkArgument((selectionPredicate != null ? 1 : 0) != 0);
        Preconditions.checkArgument((gestureStarter != null ? 1 : 0) != 0);
        Preconditions.checkArgument((onItemActivatedListener != null ? 1 : 0) != 0);
        Preconditions.checkArgument((onDragInitiatedListener != null ? 1 : 0) != 0);
        Preconditions.checkArgument((hapticPerformer != null ? 1 : 0) != 0);
        this.mDetailsLookup = detailsLookup;
        this.mSelectionPredicate = selectionPredicate;
        this.mGestureStarter = gestureStarter;
        this.mOnItemActivatedListener = onItemActivatedListener;
        this.mOnDragInitiatedListener = onDragInitiatedListener;
        this.mHapticPerformer = hapticPerformer;
    }

    public boolean onSingleTapUp(@NonNull MotionEvent e) {
        ItemDetailsLookup.ItemDetails<K> item = this.mDetailsLookup.getItemDetails(e);
        if (item == null || !item.hasSelectionKey()) {
            return this.mSelectionTracker.clearSelection();
        }
        if (this.mSelectionTracker.hasSelection()) {
            if (this.shouldExtendRange(e)) {
                this.extendSelectionRange(item);
            } else if (this.mSelectionTracker.isSelected(item.getSelectionKey())) {
                this.mSelectionTracker.deselect(item.getSelectionKey());
            } else {
                this.selectItem(item);
            }
            return true;
        }
        return item.inSelectionHotspot(e) ? this.selectItem(item) : this.mOnItemActivatedListener.onItemActivated(item, e);
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        return MotionEvents.isActionUp(e) && this.onSingleTapUp(e);
    }

    public void onLongPress(@NonNull MotionEvent e) {
        if (!this.mDetailsLookup.overItemWithSelectionKey(e)) {
            return;
        }
        ItemDetailsLookup.ItemDetails<K> item = this.mDetailsLookup.getItemDetails(e);
        if (item == null) {
            return;
        }
        if (this.shouldExtendRange(e)) {
            this.extendSelectionRange(item);
            this.mHapticPerformer.run();
            return;
        }
        if (this.mSelectionTracker.isSelected(item.getSelectionKey())) {
            if (this.mOnDragInitiatedListener.onDragInitiated(e)) {
                this.mHapticPerformer.run();
            }
        } else if (this.mSelectionPredicate.canSetStateForKey(item.getSelectionKey(), true) && this.selectItem(item)) {
            if (this.mSelectionPredicate.canSelectMultiple() && this.mSelectionTracker.isRangeActive()) {
                this.mGestureStarter.run();
            }
            this.mHapticPerformer.run();
        }
    }
}

