/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.ItemDetailsLookup;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public abstract class BandPredicate {
    public abstract boolean canInitiate(@NonNull MotionEvent var1);

    static boolean hasSupportedLayoutManager(@NonNull RecyclerView recyclerView) {
        RecyclerView.LayoutManager lm = recyclerView.getLayoutManager();
        return lm instanceof GridLayoutManager || lm instanceof LinearLayoutManager;
    }

    public static final class NonDraggableArea
    extends BandPredicate {
        private final RecyclerView mRecyclerView;
        private final ItemDetailsLookup<?> mDetailsLookup;

        public NonDraggableArea(@NonNull RecyclerView recyclerView, @NonNull ItemDetailsLookup<?> detailsLookup) {
            Preconditions.checkArgument((recyclerView != null ? 1 : 0) != 0);
            Preconditions.checkArgument((detailsLookup != null ? 1 : 0) != 0);
            this.mRecyclerView = recyclerView;
            this.mDetailsLookup = detailsLookup;
        }

        @Override
        public boolean canInitiate(@NonNull MotionEvent e) {
            if (!NonDraggableArea.hasSupportedLayoutManager(this.mRecyclerView) || this.mRecyclerView.hasPendingAdapterUpdates()) {
                return false;
            }
            ItemDetailsLookup.ItemDetails<?> details = this.mDetailsLookup.getItemDetails(e);
            return details == null || !details.inDragRegion(e);
        }
    }

    public static final class EmptyArea
    extends BandPredicate {
        private final RecyclerView mRecyclerView;

        public EmptyArea(@NonNull RecyclerView recyclerView) {
            Preconditions.checkArgument((recyclerView != null ? 1 : 0) != 0);
            this.mRecyclerView = recyclerView;
        }

        @Override
        public boolean canInitiate(@NonNull MotionEvent e) {
            if (!EmptyArea.hasSupportedLayoutManager(this.mRecyclerView) || this.mRecyclerView.hasPendingAdapterUpdates()) {
                return false;
            }
            View itemView = this.mRecyclerView.findChildViewUnder(e.getX(), e.getY());
            int position = itemView != null ? this.mRecyclerView.getChildAdapterPosition(itemView) : -1;
            return position == -1;
        }
    }
}

