/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.recyclerview.selection.MotionEvents;
import androidx.recyclerview.selection.Resettable;
import androidx.recyclerview.widget.RecyclerView;

class DisallowInterceptFilter
implements RecyclerView.OnItemTouchListener,
Resettable {
    private final RecyclerView.OnItemTouchListener mDelegate;
    private boolean mDisallowIntercept;

    DisallowInterceptFilter(@NonNull RecyclerView.OnItemTouchListener delegate) {
        this.mDelegate = delegate;
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        if (this.mDisallowIntercept && MotionEvents.isActionDown(e)) {
            this.mDisallowIntercept = false;
        }
        return !this.mDisallowIntercept && this.mDelegate.onInterceptTouchEvent(rv, e);
    }

    public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        this.mDelegate.onInterceptTouchEvent(rv, e);
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        this.mDisallowIntercept = true;
    }

    @Override
    public boolean isResetRequired() {
        return this.mDisallowIntercept;
    }

    @Override
    public void reset() {
        this.mDisallowIntercept = false;
    }
}

