/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.DummyOnItemTouchListener;
import androidx.recyclerview.selection.ItemDetailsLookup;
import androidx.recyclerview.selection.MotionEvents;
import androidx.recyclerview.selection.OnDragInitiatedListener;
import androidx.recyclerview.widget.RecyclerView;

final class PointerDragEventInterceptor
implements RecyclerView.OnItemTouchListener {
    private final ItemDetailsLookup<?> mEventDetailsLookup;
    private final OnDragInitiatedListener mDragListener;
    private RecyclerView.OnItemTouchListener mDelegate;

    PointerDragEventInterceptor(ItemDetailsLookup<?> eventDetailsLookup, OnDragInitiatedListener dragListener, @Nullable RecyclerView.OnItemTouchListener delegate) {
        Preconditions.checkArgument((eventDetailsLookup != null ? 1 : 0) != 0);
        Preconditions.checkArgument((dragListener != null ? 1 : 0) != 0);
        this.mEventDetailsLookup = eventDetailsLookup;
        this.mDragListener = dragListener;
        this.mDelegate = delegate != null ? delegate : new DummyOnItemTouchListener();
    }

    public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
        if (MotionEvents.isPointerDragEvent(e) && this.mEventDetailsLookup.inItemDragRegion(e)) {
            return this.mDragListener.onDragInitiated(e);
        }
        return this.mDelegate.onInterceptTouchEvent(rv, e);
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent e) {
        this.mDelegate.onTouchEvent(rv, e);
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        this.mDelegate.onRequestDisallowInterceptTouchEvent(disallowIntercept);
    }
}

