/*
 * Decompiled with CFR 0.152.
 */
package androidx.remotecallback.compiler;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class CallableMethod {
    private static final String EXTERNAL_INPUT = "androidx.remotecallback.ExternalInput";
    private static final String BYTE = "byte";
    private static final String CHAR = "char";
    private static final String SHORT = "short";
    private static final String INT = "int";
    private static final String LONG = "long";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String BOOLEAN = "boolean";
    private static final String BYTE_ARRAY = "byte[]";
    private static final String CHAR_ARRAY = "char[]";
    private static final String SHORT_ARRAY = "short[]";
    private static final String INT_ARRAY = "int[]";
    private static final String LONG_ARRAY = "long[]";
    private static final String FLOAT_ARRAY = "float[]";
    private static final String DOUBLE_ARRAY = "double[]";
    private static final String BOOLEAN_ARRAY = "boolean[]";
    private static final String STRING_ARRAY = "java.lang.String[]";
    private static final String CONTEXT = "android.content.Context";
    private static final String STRING = "java.lang.String";
    private static final String URI = "android.net.Uri";
    private static final String OBJ_BYTE = "java.lang.Byte";
    private static final String CHARACTER = "java.lang.Character";
    private static final String OBJ_SHORT = "java.lang.Short";
    private static final String INTEGER = "java.lang.Integer";
    private static final String OBJ_LONG = "java.lang.Long";
    private static final String OBJ_FLOAT = "java.lang.Float";
    private static final String OBJ_DOUBLE = "java.lang.Double";
    private static final String OBJ_BOOLEAN = "java.lang.Boolean";
    private final Element mElement;
    private final ArrayList<TypeMirror> mTypes = new ArrayList();
    private final ArrayList<String> mNames = new ArrayList();
    private final ArrayList<String> mExtInputKeys = new ArrayList();
    private final String mClsName;
    private final ProcessingEnvironment mEnv;
    private TypeMirror mReturnType;

    public CallableMethod(String name, Element element, ProcessingEnvironment env) {
        this.mClsName = name;
        this.mElement = element;
        this.mEnv = env;
        this.init();
    }

    public String getName() {
        return this.mElement.getSimpleName().toString();
    }

    private void init() {
        ExecutableType type = (ExecutableType)this.mElement.asType();
        ExecutableElement element = (ExecutableElement)this.mElement;
        List<? extends TypeMirror> types = type.getParameterTypes();
        List<? extends VariableElement> vars = element.getParameters();
        this.mReturnType = element.getReturnType();
        for (int i = 0; i < types.size(); ++i) {
            this.mTypes.add(types.get(i));
            AnnotationMirror mirror = this.findAnnotation(vars.get(i), EXTERNAL_INPUT);
            this.mExtInputKeys.add(mirror != null ? this.getValue(mirror, "value", null) : null);
            this.mNames.add(vars.get(i).getSimpleName().toString());
        }
    }

    private AnnotationMirror findAnnotation(VariableElement element, String cls) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(cls)) continue;
            return annotationMirror;
        }
        return null;
    }

    private String getValue(AnnotationMirror annotation, String name, String defValue) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotation.getElementValues();
        for (ExecutableElement executableElement : elementValues.keySet()) {
            if (!Objects.equals(executableElement.getSimpleName().toString(), name)) continue;
            AnnotationValue v = elementValues.get(executableElement);
            return v != null ? v.toString() : executableElement.getDefaultValue().getValue().toString();
        }
        if (defValue != null) {
            return defValue;
        }
        this.mEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Can't find annotation value");
        return null;
    }

    public void addMethods(TypeSpec.Builder genClass, MethodSpec.Builder runBuilder, ProcessingEnvironment env, Messager messager) {
        for (int i = 0; i < this.mTypes.size(); ++i) {
            if (!this.checkType(this.mTypes.get(i).toString(), messager)) continue;
            messager.printMessage(Diagnostic.Kind.ERROR, "Invalid type " + this.mTypes.get(i));
            return;
        }
        if (!"androidx.remotecallback.RemoteCallback".equals(this.mReturnType.toString())) {
            messager.printMessage(Diagnostic.Kind.ERROR, "RemoteCallable methods must return RemoteCallback.LOCAL.");
            return;
        }
        ClassName callbackHandlerRegistry = ClassName.get((String)"androidx.remotecallback", (String)"CallbackHandlerRegistry", (String[])new String[0]);
        ClassName callbackHandler = ClassName.get((String)"androidx.remotecallback", (String)"CallbackHandlerRegistry.CallbackHandler", (String[])new String[0]);
        ClassName remoteInputHolder = ClassName.get((String)"androidx.remotecallback", (String)"RemoteInputHolder", (String[])new String[0]);
        ClassName bundle = ClassName.get((String)"android.os", (String)"Bundle", (String[])new String[0]);
        ClassName context = ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]);
        CodeBlock.Builder code = CodeBlock.builder();
        String methodName = this.mElement.getSimpleName().toString();
        code.add("$L.registerCallbackHandler($L.class, $S, ", new Object[]{callbackHandlerRegistry, this.mClsName, methodName});
        code.beginControlFlow("new $L<$L>()", new Object[]{callbackHandler, this.mClsName});
        code.beginControlFlow("  public void executeCallback($L context, $L receiver, $L args)", new Object[]{context, this.mClsName, bundle});
        StringBuilder methodCall = new StringBuilder();
        methodCall.append("receiver.");
        methodCall.append(this.mElement.getSimpleName());
        methodCall.append("(");
        for (int i = 0; i < this.mNames.size(); ++i) {
            if (i != 0) {
                methodCall.append(", ");
            }
            methodCall.append("p" + i);
            if (this.mTypes.get(i).toString().equals(context.toString())) {
                code.addStatement("$L p" + i + " = context", new Object[]{this.mTypes.get(i)});
                continue;
            }
            code.addStatement("$L p" + i, new Object[]{this.mTypes.get(i)});
            String key = this.mExtInputKeys.get(i) != null ? this.mExtInputKeys.get(i) : this.getBundleKey(i);
            code.addStatement("p$L = $L", new Object[]{i, this.getBundleParam(this.mTypes.get(i).toString(), key)});
        }
        methodCall.append(")");
        code.addStatement(methodCall.toString(), new Object[0]);
        code.endControlFlow();
        code.endControlFlow();
        code.add(");\n", new Object[0]);
        runBuilder.addCode(code.build());
        code = CodeBlock.builder();
        ClassName remoteCallback = ClassName.get((String)"androidx.remotecallback", (String)"RemoteCallback", (String[])new String[0]);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).returns((TypeName)remoteCallback).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.bestGuess((String)"Override")).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        code.addStatement("$L b = new $L()", new Object[]{bundle, bundle});
        for (int i = 0; i < this.mNames.size(); ++i) {
            builder.addParameter(TypeName.get((TypeMirror)this.mTypes.get(i)), "p" + i, new Modifier[0]);
            if (this.mTypes.get(i).toString().equals(context.toString())) continue;
            boolean isNative = this.isNative(this.mTypes.get(i).toString());
            if (!isNative) {
                code.beginControlFlow("if (p$L != null)", new Object[]{i});
            }
            code.addStatement("b.put$L($L, ($L) p$L)", new Object[]{this.getTypeMethod(this.mTypes.get(i).toString()), this.getBundleKey(i), this.mTypes.get(i), i});
            if (!isNative) {
                code.nextControlFlow("else", new Object[0]);
            }
            if (!isNative) {
                code.addStatement("b.putString($L, null)", new Object[]{this.getBundleKey(i)});
            }
            if (isNative) continue;
            code.endControlFlow();
        }
        code.addStatement("return androidx.remotecallback.CallbackHandlerRegistry.stubToRemoteCallback(this, $L.class, b, $S)", new Object[]{this.mClsName, this.mElement.getSimpleName()});
        builder.addCode(code.build());
        genClass.addMethod(builder.build());
    }

    private int countArgs(ClassName context) {
        int ct = 0;
        for (int i = 0; i < this.mTypes.size(); ++i) {
            if (this.mTypes.get(i).toString().equals(context.toString())) continue;
            ++ct;
        }
        return ct;
    }

    private String getBundleParam(String type, int index) {
        String key = this.getBundleKey(index);
        return this.getBundleParam(type, key);
    }

    private boolean isNative(String type) {
        switch (type) {
            case "byte": 
            case "char": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "boolean": {
                return true;
            }
        }
        return false;
    }

    private String getBundleParam(String type, String key) {
        switch (type) {
            case "byte": {
                return "args.getByte(" + key + ", (byte) 0)";
            }
            case "char": {
                return "args.getChar(" + key + ", (char) 0)";
            }
            case "short": {
                return "args.getShort(" + key + ", (short) 0)";
            }
            case "int": {
                return "args.getInt(" + key + ", 0)";
            }
            case "long": {
                return "args.getLong(" + key + ", 0)";
            }
            case "float": {
                return "args.getFloat(" + key + ", 0f)";
            }
            case "double": {
                return "args.getDouble(" + key + ", 0.0)";
            }
            case "boolean": {
                return "args.getBoolean(" + key + ", false)";
            }
        }
        return "(" + type + ") args.get(" + key + ")";
    }

    private String getTypeMethod(String type) {
        switch (type) {
            case "byte": {
                return "Byte";
            }
            case "char": {
                return "Char";
            }
            case "short": {
                return "Short";
            }
            case "int": {
                return "Int";
            }
            case "long": {
                return "Long";
            }
            case "float": {
                return "Float";
            }
            case "double": {
                return "Double";
            }
            case "boolean": {
                return "Boolean";
            }
            case "java.lang.String": {
                return "String";
            }
            case "android.net.Uri": {
                return "Parcelable";
            }
            case "byte[]": {
                return "ByteArray";
            }
            case "char[]": {
                return "CharArray";
            }
            case "short[]": {
                return "ShortArray";
            }
            case "int[]": {
                return "IntArray";
            }
            case "long[]": {
                return "LongArray";
            }
            case "float[]": {
                return "FloatArray";
            }
            case "double[]": {
                return "DoubleArray";
            }
            case "boolean[]": {
                return "BooleanArray";
            }
            case "java.lang.String[]": {
                return "StringArray";
            }
            case "java.lang.Byte": {
                return "Byte";
            }
            case "java.lang.Character": {
                return "Char";
            }
            case "java.lang.Short": {
                return "Short";
            }
            case "java.lang.Integer": {
                return "Int";
            }
            case "java.lang.Long": {
                return "Long";
            }
            case "java.lang.Float": {
                return "Float";
            }
            case "java.lang.Double": {
                return "Double";
            }
            case "java.lang.Boolean": {
                return "Boolean";
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    private String getBundleKey(int index) {
        return "\"p" + index + "\"";
    }

    private boolean checkType(String type, Messager messager) {
        switch (type) {
            case "byte": 
            case "char": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "boolean": 
            case "java.lang.String": 
            case "android.content.Context": 
            case "byte[]": 
            case "char[]": 
            case "short[]": 
            case "int[]": 
            case "long[]": 
            case "float[]": 
            case "double[]": 
            case "boolean[]": 
            case "java.lang.String[]": 
            case "android.net.Uri": 
            case "java.lang.Byte": 
            case "java.lang.Character": 
            case "java.lang.Short": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Float": 
            case "java.lang.Double": 
            case "java.lang.Boolean": {
                return false;
            }
        }
        return true;
    }
}

