/*
 * Decompiled with CFR 0.152.
 */
package androidx.remotecallback.compiler;

import androidx.remotecallback.compiler.CallableMethod;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class CallbackReceiver {
    private static final String RESET = "reset";
    private static final String GET_METHOD = "getMethod";
    private static final String GET_ARGUMENTS = "getArguments";
    private static final String GET_CLS_NAME = "getClsName";
    private final ProcessingEnvironment mEnv;
    private final Element mElement;
    private final String mClsName;
    private final ArrayList<CallableMethod> mMethods = new ArrayList();
    private final Messager mMessager;

    public CallbackReceiver(Element c, ProcessingEnvironment env, Messager messager) {
        this.mEnv = env;
        this.mElement = c;
        this.mClsName = c.toString();
        this.mMessager = messager;
    }

    public void addMethod(Element element) {
        for (CallableMethod method : this.mMethods) {
            if (!method.getName().equals(element.getSimpleName().toString())) continue;
            this.mMessager.printMessage(Diagnostic.Kind.ERROR, "Multiple methods named " + element.getSimpleName());
            return;
        }
        this.mMethods.add(new CallableMethod(this.mClsName, element, this.mEnv));
    }

    public void finish(ProcessingEnvironment env, Messager messager) {
        if (this.mMethods.size() == 0) {
            messager.printMessage(Diagnostic.Kind.ERROR, "No methods found for " + this.mClsName);
            return;
        }
        TypeSpec.Builder genClass = TypeSpec.classBuilder((String)this.findInitClass(this.mElement)).superclass(TypeName.get((TypeMirror)this.mElement.asType())).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder runBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (CallableMethod method : this.mMethods) {
            method.addMethods(genClass, runBuilder, env, messager);
        }
        genClass.addMethod(runBuilder.build());
        try {
            TypeSpec typeSpec = genClass.build();
            String pkg = this.getPkg(this.mElement);
            JavaFile.builder((String)pkg, (TypeSpec)typeSpec).build().writeTo(this.mEnv.getFiler());
        }
        catch (IOException e) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Exception writing " + e);
        }
    }

    private String findInitClass(Element element) {
        return String.format("%sInitializer", element.getSimpleName());
    }

    private String getPkg(Element s) {
        String pkg = this.mEnv.getElementUtils().getPackageOf(s).toString();
        return pkg;
    }
}

