/*
 * Decompiled with CFR 0.152.
 */
package androidx.remotecallback.compiler;

import androidx.remotecallback.compiler.CallbackReceiver;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"androidx.remotecallback.RemoteCallable"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class RemoteCallbackProcessor
extends AbstractProcessor {
    public static final String REMOTE_CALLABLE = "androidx.remotecallback.RemoteCallable";
    private HashMap<Element, CallbackReceiver> mMap = new HashMap();
    private ProcessingEnvironment mEnv;
    private Messager mMessager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        this.mEnv = processingEnvironment;
        this.mMessager = processingEnvironment.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (set.isEmpty()) {
            return true;
        }
        TypeElement remoteCallable = this.findAnnotation(set, REMOTE_CALLABLE);
        for (Element element : roundEnvironment.getElementsAnnotatedWith(remoteCallable)) {
            Element cls = this.findClass(element);
            this.mMap.computeIfAbsent(cls, c -> new CallbackReceiver((Element)c, this.mEnv, this.mMessager)).addMethod(element);
        }
        for (CallbackReceiver callbackReceiver : this.mMap.values()) {
            callbackReceiver.finish(this.mEnv, this.mMessager);
        }
        return true;
    }

    private Element findClass(Element element) {
        if (element != null && element.getKind() != ElementKind.CLASS) {
            return this.findClass(element.getEnclosingElement());
        }
        return element;
    }

    private TypeElement findAnnotation(Set<? extends TypeElement> set, String name) {
        for (TypeElement typeElement : set) {
            if (!String.valueOf(typeElement).equals(name)) continue;
            return typeElement;
        }
        return null;
    }
}

