/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.util;

import androidx.room.compiler.processing.ExperimentalProcessingApi;
import androidx.room.compiler.processing.util.CompilationResult;
import androidx.room.compiler.processing.util.CompilationResultSubject;
import androidx.room.compiler.processing.util.DiagnosticMessage;
import androidx.room.compiler.processing.util.DiagnosticMessagesSubject;
import androidx.room.compiler.processing.util.Source;
import androidx.room.compiler.processing.util.SourceFileAssertionsKt;
import androidx.room.compiler.processing.util.SourceFileMismatch;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f*\u0001\u0018\b\u0007\u0018\u0000 82\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u00018B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\r\u0010\u0012\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0000J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u001dJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J.\u0010)\u001a\u00020*2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\n2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001f0-H\u0002J\u0006\u0010.\u001a\u00020\u0000J\u000e\u0010.\u001a\u00020*2\u0006\u0010'\u001a\u00020\u001fJ\u000e\u0010/\u001a\u00020*2\u0006\u0010'\u001a\u00020\u001fJ\u000e\u00100\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(J\u0006\u00101\u001a\u00020\u0000J\u000e\u00102\u001a\u00020*2\u0006\u0010'\u001a\u00020\u001fJ\u000e\u00103\u001a\u00020*2\u0006\u0010'\u001a\u00020\u001fJ\u000e\u00104\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u001fJ\u000e\u00105\u001a\u00020*2\u0006\u0010'\u001a\u00020\u001fJ\u000e\u00106\u001a\u00020*2\u0006\u0010'\u001a\u00020\u001fJ\u000e\u00107\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u00069"}, d2={"Landroidx/room/compiler/processing/util/CompilationResultSubject;", "Lcom/google/common/truth/Subject;", "Landroidx/room/compiler/processing/util/CompilationResult;", "failureMetadata", "Lcom/google/common/truth/FailureMetadata;", "compilationResult", "(Lcom/google/common/truth/FailureMetadata;Landroidx/room/compiler/processing/util/CompilationResult;)V", "getCompilationResult", "()Landroidx/room/compiler/processing/util/CompilationResult;", "shouldSucceed", "", "getShouldSucceed$room_compiler_processing_testing", "()Z", "setShouldSucceed$room_compiler_processing_testing", "(Z)V", "assertAllExpectedRoundsAreCompleted", "", "assertAllExpectedRoundsAreCompleted$room_compiler_processing_testing", "assertCompilationResult", "assertCompilationResult$room_compiler_processing_testing", "assertNoProcessorAssertionErrors", "assertNoProcessorAssertionErrors$room_compiler_processing_testing", "compilationDidFail", "createProcessorAssertionError", "androidx/room/compiler/processing/util/CompilationResultSubject$createProcessorAssertionError$1", "realError", "", "(Landroidx/room/compiler/processing/util/CompilationResult;Ljava/lang/Throwable;)Landroidx/room/compiler/processing/util/CompilationResultSubject$createProcessorAssertionError$1;", "findGeneratedSource", "Landroidx/room/compiler/processing/util/Source;", "relativePath", "", "generatedSource", "source", "generatedSourceFileWithPath", "Lcom/google/common/truth/StringSubject;", "hasDiagnosticCount", "kind", "Ljavax/tools/Diagnostic$Kind;", "expected", "", "hasDiagnosticWithMessage", "Landroidx/room/compiler/processing/util/DiagnosticMessagesSubject;", "acceptPartialMatch", "buildErrorMessage", "Lkotlin/Function0;", "hasError", "hasErrorContaining", "hasErrorCount", "hasNoWarnings", "hasNote", "hasNoteContaining", "hasRawOutputContaining", "hasWarning", "hasWarningContaining", "hasWarningCount", "Companion", "room-compiler-processing-testing"})
@ExperimentalProcessingApi
public final class CompilationResultSubject
extends Subject<CompilationResultSubject, CompilationResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompilationResult compilationResult;
    private boolean shouldSucceed;
    @NotNull
    private static final Subject.Factory<CompilationResultSubject, CompilationResult> FACTORY = CompilationResultSubject::FACTORY$lambda-8;

    public CompilationResultSubject(@NotNull FailureMetadata failureMetadata, @NotNull CompilationResult compilationResult) {
        Intrinsics.checkNotNullParameter((Object)failureMetadata, (String)"failureMetadata");
        Intrinsics.checkNotNullParameter((Object)compilationResult, (String)"compilationResult");
        super(failureMetadata, (Object)compilationResult);
        this.compilationResult = compilationResult;
        this.shouldSucceed = true;
    }

    @NotNull
    public final CompilationResult getCompilationResult() {
        return this.compilationResult;
    }

    public final boolean getShouldSucceed$room_compiler_processing_testing() {
        return this.shouldSucceed;
    }

    public final void setShouldSucceed$room_compiler_processing_testing(boolean bl) {
        this.shouldSucceed = bl;
    }

    @NotNull
    public final CompilationResultSubject compilationDidFail() {
        CompilationResultSubject compilationResultSubject = this;
        boolean bl = false;
        boolean bl2 = false;
        CompilationResultSubject $this$compilationDidFail_u24lambda_u2d0 = compilationResultSubject;
        boolean bl3 = false;
        $this$compilationDidFail_u24lambda_u2d0.setShouldSucceed$room_compiler_processing_testing(false);
        return compilationResultSubject;
    }

    @NotNull
    public final CompilationResultSubject hasRawOutputContaining(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        CompilationResultSubject compilationResultSubject = this;
        boolean bl = false;
        boolean bl2 = false;
        CompilationResultSubject $this$hasRawOutputContaining_u24lambda_u2d1 = compilationResultSubject;
        boolean bl3 = false;
        boolean found = StringsKt.contains$default((CharSequence)$this$hasRawOutputContaining_u24lambda_u2d1.getCompilationResult().rawOutput(), (CharSequence)expected, (boolean)false, (int)2, null);
        if (!found) {
            $this$hasRawOutputContaining_u24lambda_u2d1.failWithActual(Fact.simpleFact((String)("Did not find " + expected + " in the output.")), new Fact[0]);
        }
        return compilationResultSubject;
    }

    @NotNull
    public final CompilationResultSubject hasNoWarnings() {
        return this.hasDiagnosticCount(Diagnostic.Kind.WARNING, 0);
    }

    @NotNull
    public final CompilationResultSubject hasErrorCount(int expected) {
        return this.hasDiagnosticCount(Diagnostic.Kind.ERROR, expected);
    }

    @NotNull
    public final CompilationResultSubject hasWarningCount(int expected) {
        return this.hasDiagnosticCount(Diagnostic.Kind.WARNING, expected);
    }

    private final CompilationResultSubject hasDiagnosticCount(Diagnostic.Kind kind, int expected) {
        CompilationResultSubject compilationResultSubject = this;
        boolean bl = false;
        boolean bl2 = false;
        CompilationResultSubject $this$hasDiagnosticCount_u24lambda_u2d2 = compilationResultSubject;
        boolean bl3 = false;
        int actual = $this$hasDiagnosticCount_u24lambda_u2d2.getCompilationResult().diagnosticsOfKind(kind).size();
        if (actual != expected) {
            $this$hasDiagnosticCount_u24lambda_u2d2.failWithActual(Fact.simpleFact((String)("expected " + expected + ' ' + (Object)((Object)kind) + " messages, found " + actual)), new Fact[0]);
        }
        return compilationResultSubject;
    }

    @NotNull
    public final DiagnosticMessagesSubject hasWarning(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return this.hasDiagnosticWithMessage(Diagnostic.Kind.WARNING, expected, false, (Function0<String>)((Function0)new Function0<String>(expected){
            final /* synthetic */ String $expected;
            {
                this.$expected = $expected;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"expected warning: ", (Object)this.$expected);
            }
        }));
    }

    @NotNull
    public final DiagnosticMessagesSubject hasWarningContaining(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return this.hasDiagnosticWithMessage(Diagnostic.Kind.WARNING, expected, true, (Function0<String>)((Function0)new Function0<String>(expected){
            final /* synthetic */ String $expected;
            {
                this.$expected = $expected;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"expected warning: ", (Object)this.$expected);
            }
        }));
    }

    @NotNull
    public final DiagnosticMessagesSubject hasNote(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return this.hasDiagnosticWithMessage(Diagnostic.Kind.NOTE, expected, false, (Function0<String>)((Function0)new Function0<String>(expected){
            final /* synthetic */ String $expected;
            {
                this.$expected = $expected;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"expected note: ", (Object)this.$expected);
            }
        }));
    }

    @NotNull
    public final DiagnosticMessagesSubject hasNoteContaining(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return this.hasDiagnosticWithMessage(Diagnostic.Kind.NOTE, expected, true, (Function0<String>)((Function0)new Function0<String>(expected){
            final /* synthetic */ String $expected;
            {
                this.$expected = $expected;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"expected note: ", (Object)this.$expected);
            }
        }));
    }

    @NotNull
    public final DiagnosticMessagesSubject hasError(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        this.shouldSucceed = false;
        return this.hasDiagnosticWithMessage(Diagnostic.Kind.ERROR, expected, false, (Function0<String>)((Function0)new Function0<String>(expected){
            final /* synthetic */ String $expected;
            {
                this.$expected = $expected;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"expected error: ", (Object)this.$expected);
            }
        }));
    }

    @NotNull
    public final DiagnosticMessagesSubject hasErrorContaining(@NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        this.shouldSucceed = false;
        return this.hasDiagnosticWithMessage(Diagnostic.Kind.ERROR, expected, true, (Function0<String>)((Function0)new Function0<String>(expected){
            final /* synthetic */ String $expected;
            {
                this.$expected = $expected;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"expected error: ", (Object)this.$expected);
            }
        }));
    }

    @NotNull
    public final CompilationResultSubject hasError() {
        CompilationResultSubject compilationResultSubject = this;
        boolean bl = false;
        boolean bl2 = false;
        CompilationResultSubject $this$hasError_u24lambda_u2d3 = compilationResultSubject;
        boolean bl3 = false;
        $this$hasError_u24lambda_u2d3.setShouldSucceed$room_compiler_processing_testing(false);
        if ($this$hasError_u24lambda_u2d3.getCompilationResult().diagnosticsOfKind(Diagnostic.Kind.ERROR).isEmpty()) {
            $this$hasError_u24lambda_u2d3.failWithActual(Fact.simpleFact((String)"expected at least one failure message"), new Fact[0]);
        }
        return compilationResultSubject;
    }

    @NotNull
    public final StringSubject generatedSourceFileWithPath(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Source match = this.findGeneratedSource(relativePath);
        if (match == null) {
            this.failWithActual(Fact.simpleFact((String)Intrinsics.stringPlus((String)"Didn't generate file with path: ", (Object)relativePath)), new Fact[0]);
        }
        Source source = match;
        Intrinsics.checkNotNull((Object)source);
        StringSubject stringSubject = Truth.assertThat((String)source.getContents());
        Intrinsics.checkNotNullExpressionValue((Object)stringSubject, (String)"assertThat(match!!.contents)");
        return stringSubject;
    }

    private final Source findGeneratedSource(String relativePath) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.compilationResult.getGeneratedSources$room_compiler_processing_testing();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Source it = (Source)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRelativePath(), (Object)relativePath)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final CompilationResultSubject generatedSource(@NotNull Source source) {
        Object v0;
        CompilationResultSubject $this$generatedSource_u24lambda_u2d6;
        CompilationResultSubject compilationResultSubject;
        block4: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            compilationResultSubject = this;
            boolean bl = false;
            boolean bl2 = false;
            $this$generatedSource_u24lambda_u2d6 = compilationResultSubject;
            boolean bl3 = false;
            Iterable $this$firstOrNull$iv = $this$generatedSource_u24lambda_u2d6.getCompilationResult().getGeneratedSources$room_compiler_processing_testing();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Source it = (Source)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getRelativePath(), (Object)source.getRelativePath())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Source match = v0;
        if (match == null) {
            $this$generatedSource_u24lambda_u2d6.failWithActual(Fact.simpleFact((String)Intrinsics.stringPlus((String)"Didn't generate ", (Object)source)), new Fact[0]);
        } else {
            SourceFileMismatch mismatch = SourceFileAssertionsKt.findMismatch(source, match);
            if (mismatch != null) {
                Fact[] factArray = new Fact[]{Fact.fact((String)"mismatch", (Object)mismatch), Fact.fact((String)"expected", (Object)source.getContents()), Fact.fact((String)"actual", (Object)match.getContents())};
                $this$generatedSource_u24lambda_u2d6.failWithActual(Fact.simpleFact((String)"Generated code does not match expected"), factArray);
            }
        }
        return compilationResultSubject;
    }

    public final void assertCompilationResult$room_compiler_processing_testing() {
        if (this.compilationResult.getSuccessfulCompilation$room_compiler_processing_testing() != this.shouldSucceed) {
            this.failWithActual(Fact.simpleFact((String)("expected compilation result to be: " + this.shouldSucceed + " but was " + this.compilationResult.getSuccessfulCompilation$room_compiler_processing_testing())), new Fact[0]);
        }
    }

    public final void assertAllExpectedRoundsAreCompleted$room_compiler_processing_testing() {
        if (this.compilationResult.getProcessor$room_compiler_processing_testing().expectsAnotherRound()) {
            this.failWithActual(Fact.simpleFact((String)"Test runner requested another round but that didn't happen"), new Fact[0]);
        }
    }

    public final void assertNoProcessorAssertionErrors$room_compiler_processing_testing() {
        Throwable processingException = this.compilationResult.getProcessor$room_compiler_processing_testing().getProcessingException();
        if (processingException != null) {
            throw this.createProcessorAssertionError(this.compilationResult, processingException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final DiagnosticMessagesSubject hasDiagnosticWithMessage(Diagnostic.Kind kind, String expected, boolean acceptPartialMatch, Function0<String> buildErrorMessage) {
        void $this$filterTo$iv$iv;
        List<DiagnosticMessage> diagnostics = this.compilationResult.diagnosticsOfKind(kind);
        Iterable $this$filter$iv = diagnostics;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DiagnosticMessage it = (DiagnosticMessage)element$iv$iv;
            boolean bl = false;
            boolean bl2 = acceptPartialMatch ? StringsKt.contains$default((CharSequence)it.getMsg(), (CharSequence)expected, (boolean)false, (int)2, null) : Intrinsics.areEqual((Object)it.getMsg(), (Object)expected);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matches = (List)destination$iv$iv;
        if (matches.isEmpty()) {
            this.failWithActual(Fact.simpleFact((String)((String)buildErrorMessage.invoke())), new Fact[0]);
        }
        return DiagnosticMessagesSubject.Companion.assertThat(matches);
    }

    private final createProcessorAssertionError.1 createProcessorAssertionError(CompilationResult compilationResult, Throwable realError) {
        String string = Intrinsics.stringPlus((String)"processor did throw an error\n", (Object)compilationResult);
        return new AssertionError(realError, string){
            final /* synthetic */ Throwable $realError;
            {
                this.$realError = $realError;
                super($super_call_param$1, $realError);
            }

            @NotNull
            public Throwable fillInStackTrace() {
                return this.$realError;
            }
        };
    }

    private static final CompilationResultSubject FACTORY$lambda-8(FailureMetadata metadata, CompilationResult actual) {
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullExpressionValue((Object)actual, (String)"actual");
        return new CompilationResultSubject(metadata, actual);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/room/compiler/processing/util/CompilationResultSubject$Companion;", "", "()V", "FACTORY", "Lcom/google/common/truth/Subject$Factory;", "Landroidx/room/compiler/processing/util/CompilationResultSubject;", "Landroidx/room/compiler/processing/util/CompilationResult;", "assertThat", "compilationResult", "room-compiler-processing-testing"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompilationResultSubject assertThat(@NotNull CompilationResult compilationResult) {
            Intrinsics.checkNotNullParameter((Object)compilationResult, (String)"compilationResult");
            Subject subject = Truth.assertAbout((Subject.Factory)FACTORY).that((Object)compilationResult);
            Intrinsics.checkNotNullExpressionValue((Object)subject, (String)"assertAbout(FACTORY).tha\u2026ationResult\n            )");
            return (CompilationResultSubject)subject;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

