/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.util;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.AssumptionViolatedException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Landroidx/room/compiler/processing/util/CompilationTestCapabilities;", "", "()V", "canTestWithKsp", "", "getCanTestWithKsp", "()Z", "assumeKspIsEnabled", "", "Config", "room-compiler-processing-testing"})
public final class CompilationTestCapabilities {
    @NotNull
    public static final CompilationTestCapabilities INSTANCE = new CompilationTestCapabilities();
    private static final boolean canTestWithKsp;

    private CompilationTestCapabilities() {
    }

    public final boolean getCanTestWithKsp() {
        return canTestWithKsp;
    }

    public final void assumeKspIsEnabled() {
        if (!canTestWithKsp) {
            throw new AssumptionViolatedException("KSP tests are not enabled");
        }
    }

    static {
        Config config = Config.Companion.load();
        canTestWithKsp = config.canEnableKsp();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0080\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u001d\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0018"}, d2={"Landroidx/room/compiler/processing/util/CompilationTestCapabilities$Config;", "", "kotlinVersion", "", "kspVersion", "(Ljava/lang/String;Ljava/lang/String;)V", "getKotlinVersion", "()Ljava/lang/String;", "getKspVersion", "canEnableKsp", "", "component1", "component2", "copy", "equals", "other", "hashCode", "", "reduceVersions", "", "version", "(Ljava/lang/String;)[Ljava/lang/String;", "toString", "Companion", "room-compiler-processing-testing"})
    public static final class Config {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String kotlinVersion;
        @NotNull
        private final String kspVersion;

        public Config(@NotNull String kotlinVersion, @NotNull String kspVersion) {
            Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
            Intrinsics.checkNotNullParameter((Object)kspVersion, (String)"kspVersion");
            this.kotlinVersion = kotlinVersion;
            this.kspVersion = kspVersion;
        }

        @NotNull
        public final String getKotlinVersion() {
            return this.kotlinVersion;
        }

        @NotNull
        public final String getKspVersion() {
            return this.kspVersion;
        }

        public final boolean canEnableKsp() {
            Object[] reducedKotlin = this.reduceVersions(this.kotlinVersion);
            Object[] reducedKsp = this.reduceVersions(this.kspVersion);
            Object[] objectArray = reducedKotlin;
            boolean bl = false;
            return Arrays.equals(objectArray, reducedKsp);
        }

        private final String[] reduceVersions(String version) {
            Object[] objectArray = new char[]{'.'};
            List sections = StringsKt.split$default((CharSequence)version, (char[])objectArray, (boolean)false, (int)0, (int)6, null);
            objectArray = new String[2];
            objectArray[0] = (char)((String)CollectionsKt.getOrNull((List)sections, (int)0));
            objectArray[1] = (char)((String)CollectionsKt.getOrNull((List)sections, (int)1));
            return objectArray;
        }

        @NotNull
        public final String component1() {
            return this.kotlinVersion;
        }

        @NotNull
        public final String component2() {
            return this.kspVersion;
        }

        @NotNull
        public final Config copy(@NotNull String kotlinVersion, @NotNull String kspVersion) {
            Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
            Intrinsics.checkNotNullParameter((Object)kspVersion, (String)"kspVersion");
            return new Config(kotlinVersion, kspVersion);
        }

        public static /* synthetic */ Config copy$default(Config config, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = config.kotlinVersion;
            }
            if ((n & 2) != 0) {
                string2 = config.kspVersion;
            }
            return config.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Config(kotlinVersion=" + this.kotlinVersion + ", kspVersion=" + this.kspVersion + ')';
        }

        public int hashCode() {
            int result = this.kotlinVersion.hashCode();
            result = result * 31 + this.kspVersion.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            if (!Intrinsics.areEqual((Object)this.kotlinVersion, (Object)config.kotlinVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.kspVersion, (Object)config.kspVersion);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/room/compiler/processing/util/CompilationTestCapabilities$Config$Companion;", "", "()V", "load", "Landroidx/room/compiler/processing/util/CompilationTestCapabilities$Config;", "room-compiler-processing-testing"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Config load() {
                Properties props = new Properties();
                String resourceName = '/' + Config.class.getCanonicalName() + ".properties";
                Object object = CompilationTestCapabilities.class.getResource(resourceName).openStream();
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)object;
                    boolean bl3 = false;
                    props.load(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = props.getProperty("kotlinVersion");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                Object object2 = object;
                object = props.getProperty("kspVersion");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                return new Config((String)object2, (String)object);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

