/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.util;

import com.google.testing.compile.JavaFileObjects;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import javax.tools.JavaFileObject;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u00020\u0004H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Landroidx/room/compiler/processing/util/Source;", "", "()V", "contents", "", "getContents", "()Ljava/lang/String;", "relativePath", "getRelativePath", "equals", "", "other", "hashCode", "", "toJFO", "Ljavax/tools/JavaFileObject;", "toString", "Companion", "JavaSource", "KotlinSource", "Landroidx/room/compiler/processing/util/Source$JavaSource;", "Landroidx/room/compiler/processing/util/Source$KotlinSource;", "room-compiler-processing-testing"})
public abstract class Source {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private Source() {
    }

    @NotNull
    public abstract String getRelativePath();

    @NotNull
    public abstract String getContents();

    @NotNull
    public abstract JavaFileObject toJFO();

    @NotNull
    public String toString() {
        return "SourceFile[" + this.getRelativePath() + ']';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Source)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getRelativePath(), (Object)((Source)other).getRelativePath())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getContents(), (Object)((Source)other).getContents());
    }

    public int hashCode() {
        int result = this.getRelativePath().hashCode();
        result = 31 * result + this.getContents().hashCode();
        return result;
    }

    public /* synthetic */ Source(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\r"}, d2={"Landroidx/room/compiler/processing/util/Source$JavaSource;", "Landroidx/room/compiler/processing/util/Source;", "qName", "", "contents", "(Ljava/lang/String;Ljava/lang/String;)V", "getContents", "()Ljava/lang/String;", "getQName", "relativePath", "getRelativePath", "toJFO", "Ljavax/tools/JavaFileObject;", "room-compiler-processing-testing"})
    public static final class JavaSource
    extends Source {
        @NotNull
        private final String qName;
        @NotNull
        private final String contents;

        public JavaSource(@NotNull String qName, @NotNull String contents) {
            Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            super(null);
            this.qName = qName;
            this.contents = contents;
        }

        @NotNull
        public final String getQName() {
            return this.qName;
        }

        @Override
        @NotNull
        public String getContents() {
            return this.contents;
        }

        @Override
        @NotNull
        public JavaFileObject toJFO() {
            JavaFileObject javaFileObject = JavaFileObjects.forSourceString((String)this.qName, (String)this.getContents());
            Intrinsics.checkNotNullExpressionValue((Object)javaFileObject, (String)"forSourceString(\n       \u2026   contents\n            )");
            return javaFileObject;
        }

        @Override
        @NotNull
        public String getRelativePath() {
            return Intrinsics.stringPlus((String)StringsKt.replace$default((String)this.qName, (String)".", (String)"/", (boolean)false, (int)4, null), (Object)".java");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000b"}, d2={"Landroidx/room/compiler/processing/util/Source$KotlinSource;", "Landroidx/room/compiler/processing/util/Source;", "relativePath", "", "contents", "(Ljava/lang/String;Ljava/lang/String;)V", "getContents", "()Ljava/lang/String;", "getRelativePath", "toJFO", "Ljavax/tools/JavaFileObject;", "room-compiler-processing-testing"})
    public static final class KotlinSource
    extends Source {
        @NotNull
        private final String relativePath;
        @NotNull
        private final String contents;

        public KotlinSource(@NotNull String relativePath, @NotNull String contents) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            super(null);
            this.relativePath = relativePath;
            this.contents = contents;
        }

        @Override
        @NotNull
        public String getRelativePath() {
            return this.relativePath;
        }

        @Override
        @NotNull
        public String getContents() {
            return this.contents;
        }

        @Override
        @NotNull
        public JavaFileObject toJFO() {
            throw new IllegalStateException("cannot include kotlin code in javac compilation");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\tJ\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t\u00a8\u0006\u0013"}, d2={"Landroidx/room/compiler/processing/util/Source$Companion;", "", "()V", "fromJavaFileObject", "Landroidx/room/compiler/processing/util/Source;", "javaFileObject", "Ljavax/tools/JavaFileObject;", "java", "qName", "", "code", "kotlin", "filePath", "load", "file", "Ljava/io/File;", "relativePath", "loadJavaSource", "loadKotlinSource", "room-compiler-processing-testing"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Source java(@NotNull String qName, @Language(value="java") @NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return new JavaSource(qName, code);
        }

        @NotNull
        public final Source kotlin(@NotNull String filePath, @Language(value="kotlin") @NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return new KotlinSource(filePath, code);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Source fromJavaFileObject(@NotNull JavaFileObject javaFileObject) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter((Object)javaFileObject, (String)"javaFileObject");
            URI uri = javaFileObject.toUri();
            Closeable closeable = javaFileObject.openReader(true);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Reader it = (Reader)closeable;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                string3 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String contents = string3;
            if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"mem")) {
                string2 = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.path");
                string = StringsKt.replace$default((String)StringsKt.substringAfter$default((String)string2, (String)"SOURCE_OUTPUT/", null, (int)2, null), (char)'/', (char)'.', (boolean)false, (int)4, null);
            } else {
                string2 = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.path");
                string = StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
            }
            String qName = string;
            String javaExt = ".java";
            boolean bl4 = StringsKt.endsWith$default((String)qName, (String)javaExt, (boolean)false, (int)2, null);
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string4 = "expected a java source file, " + qName + " does not seem like one";
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            return this.java(StringsKt.dropLast((String)qName, (int)javaExt.length()), contents);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Source loadKotlinSource(@NotNull File file, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            if (!file.exists()) ** GOTO lbl-1000
            var3_3 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"file.name");
            if (StringsKt.endsWith$default((String)var3_3, (String)".kt", (boolean)false, (int)2, null)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            var3_4 = v0;
            var4_5 = false;
            var5_6 = false;
            var5_6 = false;
            var6_7 = false;
            if (!var3_4) {
                var7_9 = false;
                var6_8 = "Check failed.";
                throw (Throwable)new IllegalStateException(var6_8.toString());
            }
            return this.kotlin(relativePath, FilesKt.readText$default((File)file, null, (int)1, null));
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Source loadJavaSource(@NotNull File file, @NotNull String qName) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
            if (!file.exists()) ** GOTO lbl-1000
            var3_3 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"file.name");
            if (StringsKt.endsWith$default((String)var3_3, (String)".java", (boolean)false, (int)2, null)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            var3_4 = v0;
            var4_5 = false;
            var5_6 = false;
            var5_6 = false;
            var6_7 = false;
            if (!var3_4) {
                var7_9 = false;
                var6_8 = "Check failed.";
                throw (Throwable)new IllegalStateException(var6_8.toString());
            }
            return this.java(qName, FilesKt.readText$default((File)file, null, (int)1, null));
        }

        @NotNull
        public final Source load(@NotNull File file, @NotNull String qName, @NotNull String relativePath) {
            Source source;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            boolean bl = file.exists();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = Intrinsics.stringPlus((String)"file does not exist: ", (Object)file.getCanonicalPath());
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null)) {
                source = this.loadKotlinSource(file, relativePath);
            } else {
                string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null)) {
                    source = this.loadJavaSource(file, qName);
                } else {
                    string = Intrinsics.stringPlus((String)"invalid file extension ", (Object)file.getName());
                    bl2 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
            return source;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

