/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.util.compiler;

import androidx.room.compiler.processing.util.compiler.steps.RawDiagnosticMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0010J\"\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019*\u00020\u0015H\u0002J\f\u0010\u001b\u001a\u00020\u0015*\u00020\u0015H\u0002J\f\u0010\u001c\u001a\u00020\u0015*\u00020\u0015H\u0002J\f\u0010\u001d\u001a\u00020\u0015*\u00020\u0015H\u0002J\f\u0010\u001e\u001a\u00020\u001a*\u00020\u0017H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Landroidx/room/compiler/processing/util/compiler/DiagnosticsMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "()V", "diagnostics", "", "Landroidx/room/compiler/processing/util/compiler/steps/RawDiagnosticMessage;", "kind", "Ljavax/tools/Diagnostic$Kind;", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "getKind", "(Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;)Ljavax/tools/Diagnostic$Kind;", "clear", "", "getDiagnostics", "", "hasErrors", "", "hasWarnings", "report", "severity", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "parseLocation", "Lkotlin/Pair;", "Landroidx/room/compiler/processing/util/compiler/steps/RawDiagnosticMessage$Location;", "stripKind", "stripKspPrefix", "stripPrefixes", "toRawLocation", "Companion", "room-compiler-processing-testing"})
public final class DiagnosticsMessageCollector
implements MessageCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<RawDiagnosticMessage> diagnostics;
    @NotNull
    private static final Regex KAPT_LOCATION_AND_KIND_REGEX;
    @NotNull
    private static final Regex KSP_LOCATION_REGEX;
    @NotNull
    private static final Regex KIND_REGEX;
    @NotNull
    private static final Regex KSP_PREFIX_REGEX;

    public DiagnosticsMessageCollector() {
        boolean bl = false;
        this.diagnostics = new ArrayList();
    }

    @NotNull
    public final List<RawDiagnosticMessage> getDiagnostics() {
        return this.diagnostics;
    }

    public void clear() {
        this.diagnostics.clear();
    }

    public final boolean hasWarnings() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.diagnostics;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RawDiagnosticMessage it = (RawDiagnosticMessage)element$iv;
                    boolean bl2 = false;
                    if (!(it.getKind() == Diagnostic.Kind.WARNING || it.getKind() == Diagnostic.Kind.MANDATORY_WARNING)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean hasErrors() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.diagnostics;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RawDiagnosticMessage it = (RawDiagnosticMessage)element$iv;
                    boolean bl2 = false;
                    if (!(it.getKind() == Diagnostic.Kind.ERROR)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Pair pair2 = location == null ? ((pair = this.parseLocation(message)) == null ? TuplesKt.to((Object)this.stripPrefixes(message), null) : pair) : TuplesKt.to((Object)this.stripPrefixes(message), (Object)this.toRawLocation(location));
        String strippedMessage = (String)pair2.component1();
        RawDiagnosticMessage.Location rawLocation = (RawDiagnosticMessage.Location)pair2.component2();
        this.diagnostics.add(new RawDiagnosticMessage(this.getKind(severity), strippedMessage, rawLocation));
    }

    private final Pair<String, RawDiagnosticMessage.Location> parseLocation(String $this$parseLocation) {
        MatchResult match;
        MatchResult matchResult;
        String string = (String)SequencesKt.firstOrNull((Sequence)StringsKt.lineSequence((CharSequence)$this$parseLocation));
        if (string == null) {
            return null;
        }
        String firstLine = string;
        Object object = Regex.find$default((Regex)KSP_LOCATION_REGEX, (CharSequence)firstLine, (int)0, (int)2, null);
        if (object == null) {
            MatchResult matchResult2 = Regex.find$default((Regex)KAPT_LOCATION_AND_KIND_REGEX, (CharSequence)firstLine, (int)0, (int)2, null);
            if (matchResult2 == null) {
                return null;
            }
            matchResult = matchResult2;
        } else {
            matchResult = match = object;
        }
        if (match.getGroups().size() != 4) {
            return null;
        }
        object = $this$parseLocation;
        int n = match.getRange().getLast() + 1;
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)object2).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        object = (String)match.getGroupValues().get(3);
        n = 0;
        return TuplesKt.to((Object)string2, (Object)new RawDiagnosticMessage.Location((String)match.getGroupValues().get(1), Integer.parseInt((String)object)));
    }

    private final String stripPrefixes(String $this$stripPrefixes) {
        return this.stripKspPrefix(this.stripKind($this$stripPrefixes));
    }

    private final String stripKind(String $this$stripKind) {
        String string = (String)SequencesKt.firstOrNull((Sequence)StringsKt.lineSequence((CharSequence)$this$stripKind));
        if (string == null) {
            return $this$stripKind;
        }
        String firstLine = string;
        Object object = Regex.find$default((Regex)KIND_REGEX, (CharSequence)firstLine, (int)0, (int)2, null);
        if (object == null) {
            return $this$stripKind;
        }
        MatchResult match = object;
        object = $this$stripKind;
        int n = match.getRange().getLast() + 1;
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)object2).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        return string2;
    }

    private final String stripKspPrefix(String $this$stripKspPrefix) {
        String string = (String)SequencesKt.firstOrNull((Sequence)StringsKt.lineSequence((CharSequence)$this$stripKspPrefix));
        if (string == null) {
            return $this$stripKspPrefix;
        }
        String firstLine = string;
        Object object = Regex.find$default((Regex)KSP_PREFIX_REGEX, (CharSequence)firstLine, (int)0, (int)2, null);
        if (object == null) {
            return $this$stripKspPrefix;
        }
        MatchResult match = object;
        object = $this$stripKspPrefix;
        int n = match.getRange().getLast() + 1;
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)object2).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        return string2;
    }

    private final RawDiagnosticMessage.Location toRawLocation(CompilerMessageSourceLocation $this$toRawLocation) {
        int n = $this$toRawLocation.getLine();
        String string = $this$toRawLocation.getPath();
        return new RawDiagnosticMessage.Location(string, n);
    }

    private final Diagnostic.Kind getKind(CompilerMessageSeverity $this$kind) {
        Diagnostic.Kind kind;
        CompilerMessageSeverity compilerMessageSeverity = $this$kind;
        int n = WhenMappings.$EnumSwitchMapping$0[compilerMessageSeverity.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                kind = Diagnostic.Kind.ERROR;
                break;
            }
            case 3: 
            case 4: {
                kind = Diagnostic.Kind.NOTE;
                break;
            }
            case 5: 
            case 6: {
                kind = Diagnostic.Kind.WARNING;
                break;
            }
            default: {
                kind = Diagnostic.Kind.OTHER;
            }
        }
        return kind;
    }

    static {
        String string = "^(.*\\.(kt|java)):(\\d+): \\w+: ";
        boolean bl = false;
        KAPT_LOCATION_AND_KIND_REGEX = new Regex(string);
        string = "^\\[ksp] (.*\\.(kt|java)):(\\d+): ";
        bl = false;
        KSP_LOCATION_REGEX = new Regex(string);
        string = "^\\w+: ";
        bl = false;
        KIND_REGEX = new Regex(string);
        string = "^\\[ksp] ";
        bl = false;
        KSP_PREFIX_REGEX = new Regex(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/room/compiler/processing/util/compiler/DiagnosticsMessageCollector$Companion;", "", "()V", "KAPT_LOCATION_AND_KIND_REGEX", "Lkotlin/text/Regex;", "KIND_REGEX", "KSP_LOCATION_REGEX", "KSP_PREFIX_REGEX", "room-compiler-processing-testing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilerMessageSeverity.values().length];
            nArray[CompilerMessageSeverity.ERROR.ordinal()] = 1;
            nArray[CompilerMessageSeverity.EXCEPTION.ordinal()] = 2;
            nArray[CompilerMessageSeverity.INFO.ordinal()] = 3;
            nArray[CompilerMessageSeverity.LOGGING.ordinal()] = 4;
            nArray[CompilerMessageSeverity.WARNING.ordinal()] = 5;
            nArray[CompilerMessageSeverity.STRONG_WARNING.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

