/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.util.compiler;

import androidx.room.compiler.processing.util.Source;
import androidx.room.compiler.processing.util.compiler.SourceSetKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010 \u001a\u00020!R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR&\u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0012\u00a2\u0006\u0002\b\u00130\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0014\u0010\u0015R&\u0010\u0017\u001a\r\u0012\t\u0012\u00070\u0018\u00a2\u0006\u0002\b\u00130\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\r\u001a\u0004\b\u0019\u0010\u0015R\u0019\u0010\u0002\u001a\n \u001b*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015\u00a8\u0006#"}, d2={"Landroidx/room/compiler/processing/util/compiler/SourceSet;", "", "root", "Ljava/io/File;", "sources", "", "Landroidx/room/compiler/processing/util/Source;", "(Ljava/io/File;Ljava/util/List;)V", "hasJavaSource", "", "getHasJavaSource", "()Z", "hasJavaSource$delegate", "Lkotlin/Lazy;", "hasKotlinSource", "getHasKotlinSource", "hasKotlinSource$delegate", "javaSources", "Landroidx/room/compiler/processing/util/Source$JavaSource;", "Lkotlin/internal/NoInfer;", "getJavaSources", "()Ljava/util/List;", "javaSources$delegate", "kotlinSources", "Landroidx/room/compiler/processing/util/Source$KotlinSource;", "getKotlinSources", "kotlinSources$delegate", "kotlin.jvm.PlatformType", "getRoot", "()Ljava/io/File;", "getSources", "findSourceFile", "path", "", "Companion", "room-compiler-processing-testing"})
public final class SourceSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Source> sources;
    private final File root;
    @NotNull
    private final Lazy hasJavaSource$delegate;
    @NotNull
    private final Lazy hasKotlinSource$delegate;
    @NotNull
    private final Lazy javaSources$delegate;
    @NotNull
    private final Lazy kotlinSources$delegate;

    public SourceSet(@NotNull File root, @NotNull List<? extends Source> sources) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        this.sources = sources;
        this.root = root.getCanonicalFile();
        boolean bl = root.isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = root + " must be a directory";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.hasJavaSource$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SourceSet this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Collection collection = this.this$0.getJavaSources();
                boolean bl = false;
                return !collection.isEmpty();
            }
        }));
        this.hasKotlinSource$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SourceSet this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Collection collection = this.this$0.getKotlinSources();
                boolean bl = false;
                return !collection.isEmpty();
            }
        }));
        this.javaSources$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Source.JavaSource>>(this){
            final /* synthetic */ SourceSet this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Source.JavaSource> invoke() {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = this.this$0.getSources();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Source.JavaSource)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }));
        this.kotlinSources$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Source.KotlinSource>>(this){
            final /* synthetic */ SourceSet this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Source.KotlinSource> invoke() {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = this.this$0.getSources();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Source.KotlinSource)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    @NotNull
    public final List<Source> getSources() {
        return this.sources;
    }

    public final File getRoot() {
        return this.root;
    }

    public final boolean getHasJavaSource() {
        Lazy lazy = this.hasJavaSource$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    public final boolean getHasKotlinSource() {
        Lazy lazy = this.hasKotlinSource$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final List<Source.JavaSource> getJavaSources() {
        Lazy lazy = this.javaSources$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<Source.KotlinSource> getKotlinSources() {
        Lazy lazy = this.kotlinSources$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @Nullable
    public final Source findSourceFile(@NotNull String path) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File file = new File(path).getCanonicalFile();
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            String string2 = string;
            string = this.root.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"root.path");
            if (!StringsKt.startsWith$default((String)string2, (String)string, (boolean)false, (int)2, null)) {
                return null;
            }
            String relativePath = StringsKt.substringAfter$default((String)path, (String)Intrinsics.stringPlus((String)this.root.getCanonicalPath(), (Object)"/"), null, (int)2, null);
            Iterable $this$firstOrNull$iv = this.sources;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Source it = (Source)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRelativePath(), (Object)relativePath)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/room/compiler/processing/util/compiler/SourceSet$Companion;", "", "()V", "fromExistingFiles", "Landroidx/room/compiler/processing/util/compiler/SourceSet;", "root", "Ljava/io/File;", "room-compiler-processing-testing"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SourceSet fromExistingFiles(@NotNull File root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            return new SourceSet(root, SequencesKt.toList((Sequence)SourceSetKt.access$collectSources(root)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

