/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.util.compiler;

import androidx.room.compiler.processing.util.DiagnosticMessage;
import androidx.room.compiler.processing.util.Source;
import androidx.room.compiler.processing.util.compiler.SourceSet;
import androidx.room.compiler.processing.util.compiler.SourceSetKt;
import androidx.room.compiler.processing.util.compiler.TestCompilationArguments;
import androidx.room.compiler.processing.util.compiler.TestCompilationResult;
import androidx.room.compiler.processing.util.compiler.steps.CompilationStepArguments;
import androidx.room.compiler.processing.util.compiler.steps.CompilationStepResult;
import androidx.room.compiler.processing.util.compiler.steps.JavaSourceCompilationStep;
import androidx.room.compiler.processing.util.compiler.steps.KaptCompilationStep;
import androidx.room.compiler.processing.util.compiler.steps.KotlinCompilationStep;
import androidx.room.compiler.processing.util.compiler.steps.KotlinSourceCompilationStep;
import androidx.room.compiler.processing.util.compiler.steps.KspCompilationStep;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\u0006\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0003H\u0000\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\f\u0010\u000e\u001a\u00020\u0005*\u00020\u0005H\u0000\u00a8\u0006\u000f"}, d2={"compile", "Landroidx/room/compiler/processing/util/compiler/TestCompilationResult;", "workingDir", "Ljava/io/File;", "arguments", "Landroidx/room/compiler/processing/util/compiler/TestCompilationArguments;", "copyTo", "Landroidx/room/compiler/processing/util/Source;", "kotlinRootDir", "javaRootDir", "ensureEmptyDirectory", "", "toInternal", "Landroidx/room/compiler/processing/util/compiler/steps/CompilationStepArguments;", "withAtLeastOneKotlinSource", "room-compiler-processing-testing"})
public final class TestKotlinCompilerKt {
    @NotNull
    public static final TestCompilationArguments withAtLeastOneKotlinSource(@NotNull TestCompilationArguments $this$withAtLeastOneKotlinSource) {
        boolean hasKotlinSource2;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$this$withAtLeastOneKotlinSource, (String)"<this>");
            Iterable $this$any$iv = $this$withAtLeastOneKotlinSource.getSources();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Source it = (Source)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof Source.KotlinSource)) continue;
                    bl = true;
                    break block4;
                }
                bl = hasKotlinSource2 = false;
            }
        }
        if (hasKotlinSource2) {
            return $this$withAtLeastOneKotlinSource;
        }
        return TestCompilationArguments.copy$default($this$withAtLeastOneKotlinSource, CollectionsKt.plus((Collection)$this$withAtLeastOneKotlinSource.getSources(), (Object)Source.Companion.kotlin("SyntheticSource", "package xprocessing.generated\nclass SyntheticKotlinSource")), null, false, null, null, null, null, null, 254, null);
    }

    private static final File copyTo(Source $this$copyTo, File kotlinRootDir, File javaRootDir) {
        File file;
        Source source = $this$copyTo;
        if (source instanceof Source.KotlinSource) {
            file = kotlinRootDir;
        } else if (source instanceof Source.JavaSource) {
            file = javaRootDir;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        File locationRoot = file;
        File location = FilesKt.resolve((File)locationRoot, (String)$this$copyTo.getRelativePath());
        boolean bl = !location.exists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "duplicate source file: " + location + " (" + $this$copyTo + ')';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        location.getParentFile().mkdirs();
        FilesKt.writeText((File)location, (String)$this$copyTo.getContents(), (Charset)Charsets.UTF_8);
        return location;
    }

    /*
     * WARNING - void declaration
     */
    private static final CompilationStepArguments toInternal(TestCompilationArguments $this$toInternal, File workingDir) {
        void $this$mapTo$iv$iv;
        File file = FilesKt.resolve((File)workingDir, (String)"src");
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean $i$a$-let-TestKotlinCompilerKt$toInternal$22 = false;
        Pair pair = TuplesKt.to((Object)FilesKt.resolve((File)it, (String)"kotlin"), (Object)FilesKt.resolve((File)it, (String)"java"));
        File kotlinRoot = (File)pair.component1();
        File javaRoot = (File)pair.component2();
        Iterable $this$map$iv = $this$toInternal.getSources();
        boolean $i$f$map = false;
        Iterable $i$a$-let-TestKotlinCompilerKt$toInternal$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Source source = (Source)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            File file2 = TestKotlinCompilerKt.copyTo((Source)it2, kotlinRoot, javaRoot);
            collection.add(file2);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Object[] objectArray = new SourceSet[]{SourceSetKt.toSourceSet(javaRoot), SourceSetKt.toSourceSet(kotlinRoot)};
        return new CompilationStepArguments(CollectionsKt.listOfNotNull((Object[])objectArray), $this$toInternal.getClasspath(), $this$toInternal.getInheritClasspath(), $this$toInternal.getJavacArguments(), $this$toInternal.getKotlincArguments());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TestCompilationResult compile(@NotNull File workingDir, @NotNull TestCompilationArguments arguments) {
        List list;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        boolean bl;
        Iterable $this$all$iv;
        Map combinedDiagnostics;
        List resultFromEachStep;
        block10: {
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Object[] objectArray = new KotlinCompilationStep[]{new KaptCompilationStep(arguments.getKaptProcessors(), arguments.getProcessorOptions()), new KspCompilationStep(arguments.getSymbolProcessorProviders(), arguments.getProcessorOptions()), KotlinSourceCompilationStep.INSTANCE, JavaSourceCompilationStep.INSTANCE};
            List steps = CollectionsKt.listOf((Object[])objectArray);
            TestKotlinCompilerKt.ensureEmptyDirectory(workingDir);
            CompilationStepArguments initialArgs = TestKotlinCompilerKt.toInternal(arguments, FilesKt.resolve((File)workingDir, (String)"input"));
            List initial = CollectionsKt.listOf((Object)new CompilationStepResult(true, CollectionsKt.emptyList(), CollectionsKt.emptyList(), initialArgs, CollectionsKt.emptyList()));
            Iterable $this$fold$iv = steps;
            boolean $i$f$fold = false;
            List accumulator$iv = initial;
            for (Object element$iv : $this$fold$iv) {
                void step;
                KotlinCompilationStep kotlinCompilationStep = (KotlinCompilationStep)element$iv;
                List prevResults = accumulator$iv;
                boolean bl2 = false;
                CompilationStepResult prev = (CompilationStepResult)CollectionsKt.last((List)prevResults);
                accumulator$iv = prev.getSuccess() ? CollectionsKt.plus((Collection)prevResults, (Object)step.execute(FilesKt.resolve((File)workingDir, (String)step.getName()), prev.getNextCompilerArguments())) : prevResults;
            }
            resultFromEachStep = accumulator$iv;
            $i$f$fold = false;
            combinedDiagnostics = new LinkedHashMap();
            Iterable $this$forEach$iv = resultFromEachStep;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompilationStepResult result = (CompilationStepResult)element$iv;
                boolean bl3 = false;
                Iterable $this$forEach$iv2 = result.getDiagnostics();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object object;
                    void key$iv;
                    void $this$getOrPut$iv;
                    DiagnosticMessage diagnostic = (DiagnosticMessage)element$iv2;
                    boolean bl4 = false;
                    Map map = combinedDiagnostics;
                    Diagnostic.Kind kind = diagnostic.getKind();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl5 = false;
                        boolean bl6 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((List)object).add(diagnostic);
                }
            }
            $this$all$iv = resultFromEachStep;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CompilationStepResult it = (CompilationStepResult)element$iv;
                    boolean bl7 = false;
                    if (it.getSuccess()) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        boolean bl8 = bl;
        $this$all$iv = resultFromEachStep;
        boolean $i$f$flatMap = false;
        Iterator iterator = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CompilationStepResult it = (CompilationStepResult)element$iv$iv;
            boolean bl9 = false;
            Iterable list$iv$iv = it.getGeneratedSources();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$flatMap$iv = resultFromEachStep;
        Map map = combinedDiagnostics;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CompilationStepResult it = (CompilationStepResult)element$iv$iv;
            boolean bl10 = false;
            Iterable list$iv$iv = it.getOutputClasspath();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = list = (List)destination$iv$iv;
        Map map2 = map;
        List list4 = list2;
        boolean bl11 = bl8;
        return new TestCompilationResult(bl11, list4, map2, list3);
    }

    /*
     * Unable to fully structure code
     */
    public static final void ensureEmptyDirectory(@NotNull File $this$ensureEmptyDirectory) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)$this$ensureEmptyDirectory, (String)"<this>");
                if (!$this$ensureEmptyDirectory.exists()) break block5;
                var1_1 = $this$ensureEmptyDirectory.isDirectory();
                var2_4 = false;
                var3_7 = false;
                if (!var1_1) {
                    $i$a$-check-TestKotlinCompilerKt$ensureEmptyDirectory$1 = false;
                    var3_8 = $this$ensureEmptyDirectory + " cannot be a file";
                    throw (Throwable)new IllegalStateException(var3_8.toString());
                }
                existingFiles = $this$ensureEmptyDirectory.listFiles();
                if (existingFiles == null) ** GOTO lbl-1000
                var2_5 = existingFiles;
                var3_7 = false;
                if (var2_5.length == 0) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                var2_4 = v0;
                var3_7 = false;
                $i$a$-check-TestKotlinCompilerKt$ensureEmptyDirectory$1 = false;
                if (!var2_4) {
                    $i$a$-check-TestKotlinCompilerKt$ensureEmptyDirectory$2 = false;
                    $i$a$-check-TestKotlinCompilerKt$ensureEmptyDirectory$1 = $this$ensureEmptyDirectory + " must be empty, found: " + ((var6_16 = existingFiles) == null ? null : ArraysKt.joinToString$default((Object[])var6_16, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                    throw (Throwable)new IllegalStateException($i$a$-check-TestKotlinCompilerKt$ensureEmptyDirectory$1.toString());
                }
                break block6;
            }
            var1_3 = $this$ensureEmptyDirectory.mkdirs();
            var2_6 = false;
            var3_9 = false;
            if (!var1_3) {
                $i$a$-check-TestKotlinCompilerKt$ensureEmptyDirectory$3 = false;
                var3_10 = "failed to create working directory (" + $this$ensureEmptyDirectory + ')';
                throw (Throwable)new IllegalStateException(var3_10.toString());
            }
        }
    }
}

