/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.util.compiler.steps;

import androidx.room.compiler.processing.util.DiagnosticMessage;
import androidx.room.compiler.processing.util.compiler.DiagnosticsMessageCollector;
import androidx.room.compiler.processing.util.compiler.KotlinCliRunner;
import androidx.room.compiler.processing.util.compiler.SourceSet;
import androidx.room.compiler.processing.util.compiler.SourceSetKt;
import androidx.room.compiler.processing.util.compiler.TestKapt3Registrar;
import androidx.room.compiler.processing.util.compiler.steps.CompilationStepArguments;
import androidx.room.compiler.processing.util.compiler.steps.CompilationStepResult;
import androidx.room.compiler.processing.util.compiler.steps.KotlinCompilationStep;
import androidx.room.compiler.processing.util.compiler.steps.KotlinCompilationStepKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Processor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.base.kapt3.AptMode;
import org.jetbrains.kotlin.base.kapt3.KaptFlag;
import org.jetbrains.kotlin.base.kapt3.KaptOptions;
import org.jetbrains.kotlin.cli.common.ExitCode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/room/compiler/processing/util/compiler/steps/KaptCompilationStep;", "Landroidx/room/compiler/processing/util/compiler/steps/KotlinCompilationStep;", "annotationProcessors", "", "Ljavax/annotation/processing/Processor;", "processorOptions", "", "", "(Ljava/util/List;Ljava/util/Map;)V", "name", "getName", "()Ljava/lang/String;", "createKaptArgs", "Lorg/jetbrains/kotlin/base/kapt3/KaptOptions$Builder;", "workingDir", "Ljava/io/File;", "javacArguments", "execute", "Landroidx/room/compiler/processing/util/compiler/steps/CompilationStepResult;", "arguments", "Landroidx/room/compiler/processing/util/compiler/steps/CompilationStepArguments;", "Companion", "room-compiler-processing-testing"})
public final class KaptCompilationStep
implements KotlinCompilationStep {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Processor> annotationProcessors;
    @NotNull
    private final Map<String, String> processorOptions;
    @NotNull
    private final String name;
    @NotNull
    private static final String JAVA_SRC_OUT_FOLDER_NAME = "kapt-java-src-out";
    @NotNull
    private static final String KOTLIN_SRC_OUT_FOLDER_NAME = "kapt-kotlin-src-out";
    @NotNull
    private static final String RESOURCES_OUT_FOLDER_NAME = "kapt-classes-out";
    @NotNull
    private static final String CLASS_OUT_FOLDER_NAME = "class-out";

    public KaptCompilationStep(@NotNull List<? extends Processor> annotationProcessors, @NotNull Map<String, String> processorOptions) {
        Intrinsics.checkNotNullParameter(annotationProcessors, (String)"annotationProcessors");
        Intrinsics.checkNotNullParameter(processorOptions, (String)"processorOptions");
        this.annotationProcessors = annotationProcessors;
        this.processorOptions = processorOptions;
        this.name = "kapt";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    private final KaptOptions.Builder createKaptArgs(File workingDir, List<String> javacArguments) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        KaptOptions.Builder builder = new KaptOptions.Builder();
        boolean bl = false;
        boolean bl2 = false;
        KaptOptions.Builder it = builder;
        boolean bl3 = false;
        it.setStubsOutputDir(FilesKt.resolve((File)workingDir, (String)"kapt-stubs"));
        it.setSourcesOutputDir(FilesKt.resolve((File)workingDir, (String)JAVA_SRC_OUT_FOLDER_NAME));
        it.setClassesOutputDir(FilesKt.resolve((File)workingDir, (String)RESOURCES_OUT_FOLDER_NAME));
        it.setProjectBaseDir(workingDir);
        Object object = it.getProcessingOptions();
        String string = "kapt.kotlin.generated";
        File file = FilesKt.resolve((File)workingDir, (String)KOTLIN_SRC_OUT_FOLDER_NAME);
        boolean bl4 = false;
        boolean bl5 = false;
        File it2 = file;
        boolean bl62 = false;
        it2.mkdirs();
        Object object2 = file.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"workingDir.resolve(KOTLI\u2026           .canonicalPath");
        boolean bl7 = false;
        object.put(string, object2);
        it.getProcessingOptions().putAll(this.processorOptions);
        it.setMode(AptMode.STUBS_AND_APT);
        object = this.annotationProcessors;
        List list = it.getProcessors();
        boolean $i$f$map = false;
        object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            Processor bl62 = (Processor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl8 = false;
            String string2 = it3.getClass().getName();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        list.addAll((Collection)collection);
        it.getFlags().add(KaptFlag.MAP_DIAGNOSTIC_LOCATIONS);
        Iterable $this$forEach$iv = javacArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String javacArg = (String)element$iv;
            boolean bl9 = false;
            Map map = it.getJavacOptions();
            String string3 = StringsKt.substringBefore$default((String)javacArg, (String)"=", null, (int)2, null);
            String string4 = StringsKt.substringAfter((String)javacArg, (String)"=", (String)"");
            boolean bl10 = false;
            map.put(string3, string4);
        }
        return builder;
    }

    @Override
    @NotNull
    public CompilationStepResult execute(@NotNull File workingDir, @NotNull CompilationStepArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (this.annotationProcessors.isEmpty()) {
            return CompilationStepResult.Companion.skip(arguments);
        }
        DiagnosticsMessageCollector kaptMessages = new DiagnosticsMessageCollector();
        KotlinCliRunner.KotlinCliResult result = KotlinCliRunner.INSTANCE.runKotlinCli(arguments, FilesKt.resolve((File)workingDir, (String)CLASS_OUT_FOLDER_NAME), CollectionsKt.listOf((Object)new TestKapt3Registrar(this.annotationProcessors, this.createKaptArgs(workingDir, arguments.getJavacArguments()), kaptMessages)));
        Object[] objectArray = new SourceSet[]{SourceSetKt.toSourceSet(FilesKt.resolve((File)workingDir, (String)JAVA_SRC_OUT_FOLDER_NAME)), SourceSetKt.toSourceSet(FilesKt.resolve((File)workingDir, (String)KOTLIN_SRC_OUT_FOLDER_NAME))};
        List generatedSources2 = CollectionsKt.listOfNotNull((Object[])objectArray);
        List<DiagnosticMessage> diagnostics = KotlinCompilationStepKt.resolveDiagnostics(CollectionsKt.plus((Collection)result.getDiagnostics(), (Iterable)kaptMessages.getDiagnostics()), CollectionsKt.plus((Collection)arguments.getSourceSets(), (Iterable)generatedSources2));
        List outputClasspath = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)result.getCompiledClasspath()), (Object)FilesKt.resolve((File)workingDir, (String)RESOURCES_OUT_FOLDER_NAME));
        return new CompilationStepResult(result.getExitCode() == ExitCode.OK, generatedSources2, diagnostics, CompilationStepArguments.copy$default(arguments, CollectionsKt.plus((Collection)arguments.getSourceSets(), (Iterable)generatedSources2), null, false, null, null, 30, null), outputClasspath);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/room/compiler/processing/util/compiler/steps/KaptCompilationStep$Companion;", "", "()V", "CLASS_OUT_FOLDER_NAME", "", "JAVA_SRC_OUT_FOLDER_NAME", "KOTLIN_SRC_OUT_FOLDER_NAME", "RESOURCES_OUT_FOLDER_NAME", "room-compiler-processing-testing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

