/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.util.compiler.steps;

import androidx.room.compiler.processing.util.DiagnosticMessage;
import androidx.room.compiler.processing.util.compiler.KotlinCliRunner;
import androidx.room.compiler.processing.util.compiler.SourceSet;
import androidx.room.compiler.processing.util.compiler.steps.CompilationStepArguments;
import androidx.room.compiler.processing.util.compiler.steps.CompilationStepResult;
import androidx.room.compiler.processing.util.compiler.steps.KotlinCompilationStep;
import androidx.room.compiler.processing.util.compiler.steps.KotlinCompilationStepKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ExitCode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Landroidx/room/compiler/processing/util/compiler/steps/KotlinSourceCompilationStep;", "Landroidx/room/compiler/processing/util/compiler/steps/KotlinCompilationStep;", "()V", "CLASS_OUT_FOLDER_NAME", "", "name", "getName", "()Ljava/lang/String;", "execute", "Landroidx/room/compiler/processing/util/compiler/steps/CompilationStepResult;", "workingDir", "Ljava/io/File;", "arguments", "Landroidx/room/compiler/processing/util/compiler/steps/CompilationStepArguments;", "room-compiler-processing-testing"})
public final class KotlinSourceCompilationStep
implements KotlinCompilationStep {
    @NotNull
    public static final KotlinSourceCompilationStep INSTANCE = new KotlinSourceCompilationStep();
    @NotNull
    private static final String name = "kotlinSourceCompilation";
    @NotNull
    private static final String CLASS_OUT_FOLDER_NAME = "class-out";

    private KotlinSourceCompilationStep() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public CompilationStepResult execute(@NotNull File workingDir, @NotNull CompilationStepArguments arguments) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Iterable $this$none$iv = arguments.getSourceSets();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    SourceSet it = (SourceSet)element$iv;
                    boolean bl2 = false;
                    if (!it.getHasKotlinSource()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return CompilationStepResult.Companion.skip(arguments);
        }
        KotlinCliRunner.KotlinCliResult result = KotlinCliRunner.INSTANCE.runKotlinCli(arguments, FilesKt.resolve((File)workingDir, (String)CLASS_OUT_FOLDER_NAME), CollectionsKt.emptyList());
        List<DiagnosticMessage> diagnostics = KotlinCompilationStepKt.resolveDiagnostics(result.getDiagnostics(), arguments.getSourceSets());
        List list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)FilesKt.resolve((File)workingDir, (String)CLASS_OUT_FOLDER_NAME)), (Iterable)arguments.getAdditionalClasspaths());
        List<SourceSet> list2 = arguments.getSourceSets();
        return new CompilationStepResult(result.getExitCode() == ExitCode.OK, CollectionsKt.emptyList(), diagnostics, CompilationStepArguments.copy$default(arguments, list2, list, false, null, null, 28, null), CollectionsKt.listOf((Object)result.getCompiledClasspath()));
    }
}

