/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.util.compiler.steps;

import androidx.room.compiler.processing.util.DiagnosticMessage;
import androidx.room.compiler.processing.util.compiler.DiagnosticsMessageCollector;
import androidx.room.compiler.processing.util.compiler.KotlinCliRunner;
import androidx.room.compiler.processing.util.compiler.SourceSet;
import androidx.room.compiler.processing.util.compiler.SourceSetKt;
import androidx.room.compiler.processing.util.compiler.TestKspRegistrar;
import androidx.room.compiler.processing.util.compiler.steps.CompilationStepArguments;
import androidx.room.compiler.processing.util.compiler.steps.CompilationStepResult;
import androidx.room.compiler.processing.util.compiler.steps.KotlinCompilationStep;
import androidx.room.compiler.processing.util.compiler.steps.KotlinCompilationStepKt;
import com.google.devtools.ksp.KspOptions;
import com.google.devtools.ksp.processing.SymbolProcessorProvider;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ExitCode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\t\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/room/compiler/processing/util/compiler/steps/KspCompilationStep;", "Landroidx/room/compiler/processing/util/compiler/steps/KotlinCompilationStep;", "symbolProcessorProviders", "", "Lcom/google/devtools/ksp/processing/SymbolProcessorProvider;", "processorOptions", "", "", "(Ljava/util/List;Ljava/util/Map;)V", "name", "getName", "()Ljava/lang/String;", "createKspOptions", "Lcom/google/devtools/ksp/KspOptions$Builder;", "workingDir", "Ljava/io/File;", "execute", "Landroidx/room/compiler/processing/util/compiler/steps/CompilationStepResult;", "arguments", "Landroidx/room/compiler/processing/util/compiler/steps/CompilationStepArguments;", "Companion", "room-compiler-processing-testing"})
public final class KspCompilationStep
implements KotlinCompilationStep {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<SymbolProcessorProvider> symbolProcessorProviders;
    @NotNull
    private final Map<String, String> processorOptions;
    @NotNull
    private final String name;
    @NotNull
    private static final String JAVA_OUT_DIR = "generatedJava";
    @NotNull
    private static final String KOTLIN_OUT_DIR = "generatedKotlin";
    @NotNull
    private static final String CLASS_OUT_FOLDER_NAME = "class-out";

    public KspCompilationStep(@NotNull List<? extends SymbolProcessorProvider> symbolProcessorProviders, @NotNull Map<String, String> processorOptions) {
        Intrinsics.checkNotNullParameter(symbolProcessorProviders, (String)"symbolProcessorProviders");
        Intrinsics.checkNotNullParameter(processorOptions, (String)"processorOptions");
        this.symbolProcessorProviders = symbolProcessorProviders;
        this.processorOptions = processorOptions;
        this.name = "ksp";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    private final KspOptions.Builder createKspOptions(File workingDir) {
        KspOptions.Builder builder = new KspOptions.Builder();
        boolean bl = false;
        boolean bl2 = false;
        KspOptions.Builder $this$createKspOptions_u24lambda_u2d0 = builder;
        boolean bl3 = false;
        $this$createKspOptions_u24lambda_u2d0.setJavaOutputDir(FilesKt.resolve((File)workingDir, (String)JAVA_OUT_DIR));
        $this$createKspOptions_u24lambda_u2d0.setKotlinOutputDir(FilesKt.resolve((File)workingDir, (String)KOTLIN_OUT_DIR));
        $this$createKspOptions_u24lambda_u2d0.getProcessingOptions().putAll(this.processorOptions);
        return builder;
    }

    @Override
    @NotNull
    public CompilationStepResult execute(@NotNull File workingDir, @NotNull CompilationStepArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (this.symbolProcessorProviders.isEmpty()) {
            return CompilationStepResult.Companion.skip(arguments);
        }
        DiagnosticsMessageCollector kspMessages = new DiagnosticsMessageCollector();
        KotlinCliRunner.KotlinCliResult result = KotlinCliRunner.INSTANCE.runKotlinCli(arguments, FilesKt.resolve((File)workingDir, (String)CLASS_OUT_FOLDER_NAME), CollectionsKt.listOf((Object)new TestKspRegistrar(FilesKt.resolve((File)workingDir, (String)"ksp-compiler"), this.createKspOptions(workingDir), this.symbolProcessorProviders, kspMessages)));
        boolean failureDueToWarnings = result.getKotlinCliArguments().getAllWarningsAsErrors() && kspMessages.hasWarnings();
        Object[] objectArray = new SourceSet[]{SourceSetKt.toSourceSet(FilesKt.resolve((File)workingDir, (String)KOTLIN_OUT_DIR)), SourceSetKt.toSourceSet(FilesKt.resolve((File)workingDir, (String)JAVA_OUT_DIR))};
        List generatedSources2 = CollectionsKt.listOfNotNull((Object[])objectArray);
        List<DiagnosticMessage> diagnostics = KotlinCompilationStepKt.resolveDiagnostics(CollectionsKt.plus((Collection)result.getDiagnostics(), (Iterable)kspMessages.getDiagnostics()), CollectionsKt.plus((Collection)arguments.getSourceSets(), (Iterable)generatedSources2));
        return new CompilationStepResult(result.getExitCode() == ExitCode.OK && !failureDueToWarnings, generatedSources2, diagnostics, CompilationStepArguments.copy$default(arguments, CollectionsKt.plus((Collection)arguments.getSourceSets(), (Iterable)generatedSources2), null, false, null, null, 30, null), CollectionsKt.listOf((Object)result.getCompiledClasspath()));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/room/compiler/processing/util/compiler/steps/KspCompilationStep$Companion;", "", "()V", "CLASS_OUT_FOLDER_NAME", "", "JAVA_OUT_DIR", "KOTLIN_OUT_DIR", "room-compiler-processing-testing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

