/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.util.runner;

import androidx.room.compiler.processing.ExperimentalProcessingApi;
import androidx.room.compiler.processing.SyntheticJavacProcessor;
import androidx.room.compiler.processing.util.CompilationResult;
import androidx.room.compiler.processing.util.KotlinCompilationResult;
import androidx.room.compiler.processing.util.Source;
import androidx.room.compiler.processing.util.compiler.TestCompilationArguments;
import androidx.room.compiler.processing.util.compiler.TestCompilationResult;
import androidx.room.compiler.processing.util.compiler.TestKotlinCompilerKt;
import androidx.room.compiler.processing.util.runner.CompilationTestRunner;
import androidx.room.compiler.processing.util.runner.TestCompilationParameters;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Landroidx/room/compiler/processing/util/runner/KaptCompilationTestRunner;", "Landroidx/room/compiler/processing/util/runner/CompilationTestRunner;", "()V", "name", "", "getName", "()Ljava/lang/String;", "canRun", "", "params", "Landroidx/room/compiler/processing/util/runner/TestCompilationParameters;", "compile", "Landroidx/room/compiler/processing/util/CompilationResult;", "workingDir", "Ljava/io/File;", "room-compiler-processing-testing"})
@ExperimentalProcessingApi
public final class KaptCompilationTestRunner
implements CompilationTestRunner {
    @NotNull
    public static final KaptCompilationTestRunner INSTANCE = new KaptCompilationTestRunner();
    @NotNull
    private static final String name = "kapt";

    private KaptCompilationTestRunner() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    public boolean canRun(@NotNull TestCompilationParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return true;
    }

    @Override
    @NotNull
    public CompilationResult compile(@NotNull File workingDir, @NotNull TestCompilationParameters params) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        SyntheticJavacProcessor syntheticJavacProcessor = new SyntheticJavacProcessor(params.getHandlers());
        List<Source> list = params.getSources();
        List<File> list2 = params.getClasspath();
        List list3 = CollectionsKt.listOf((Object)syntheticJavacProcessor);
        Map<String, String> map = params.getOptions();
        List<String> list4 = params.getJavacArguments();
        List<String> list5 = params.getKotlincArguments();
        TestCompilationArguments args = TestKotlinCompilerKt.withAtLeastOneKotlinSource(new TestCompilationArguments(list, list2, false, list4, list5, list3, null, map, 68, null));
        TestCompilationResult result = TestKotlinCompilerKt.compile(workingDir, args);
        return new KotlinCompilationResult(this, syntheticJavacProcessor, result);
    }
}

