/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Database;
import androidx.room.SkipQueryVerification;
import androidx.room.ext.AnnotationBox;
import androidx.room.ext.Element_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.log.RLog;
import androidx.room.parser.Table;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.DaoProcessor;
import androidx.room.processor.DatabaseViewProcessor;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.verifier.DatabaseVerificaitonErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.Dao;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.Field;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.Index;
import androidx.room.vo.InsertionMethod;
import androidx.room.vo.Pojo;
import androidx.room.vo.ShortcutMethod;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0013J\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u001e\u0010$\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J,\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u001e\u0010(\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J,\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cH\u0002J$\u0010*\u001a\u00020!2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010,\u001a\u00020-H\u0002R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006."}, d2={"Landroidx/room/processor/DatabaseProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "element", "Ljavax/lang/model/element/TypeElement;", "(Landroidx/room/processor/Context;Ljavax/lang/model/element/TypeElement;)V", "baseClassElement", "Ljavax/lang/model/type/TypeMirror;", "getBaseClassElement", "()Ljavax/lang/model/type/TypeMirror;", "baseClassElement$delegate", "Lkotlin/Lazy;", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/TypeElement;", "doProcess", "Landroidx/room/vo/Database;", "process", "processDatabaseViews", "", "Landroidx/room/vo/DatabaseView;", "dbAnnotation", "Landroidx/room/ext/AnnotationBox;", "Landroidx/room/Database;", "processEntities", "", "Landroidx/room/vo/Entity;", "resolveDatabaseViews", "views", "validateExternalContentFts", "", "dbElement", "entities", "validateForeignKeys", "validateUniqueDaoClasses", "daoMethods", "Landroidx/room/vo/DaoMethod;", "validateUniqueIndices", "validateUniqueTableAndViewNames", "verifyDatabaseViews", "map", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "room-compiler"})
public final class DatabaseProcessor {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy baseClassElement$delegate;
    @NotNull
    private final TypeElement element;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DatabaseProcessor.class), "baseClassElement", "getBaseClassElement()Ljavax/lang/model/type/TypeMirror;"))};
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final TypeMirror getBaseClassElement() {
        Lazy lazy = this.baseClassElement$delegate;
        DatabaseProcessor databaseProcessor = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (TypeMirror)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final androidx.room.vo.Database process() {
        try {
            androidx.room.vo.Database database = this.doProcess();
            return database;
        }
        finally {
            block3: {
                DatabaseVerifier databaseVerifier = this.context.getDatabaseVerifier();
                if (databaseVerifier == null) break block3;
                databaseVerifier.closeConnection(this.context);
            }
        }
    }

    private final androidx.room.vo.Database doProcess() {
        List<DatabaseView> list;
        boolean bl;
        List daoMethods;
        List<DatabaseView> resolvedViews;
        List<Entity> entities;
        AnnotationBox<Database> dbAnnotation;
        block8: {
            Element it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            AnnotationBox<Database> annotationBox = Element_extKt.toAnnotationBox(this.element, Reflection.getOrCreateKotlinClass(Database.class));
            if (annotationBox == null) {
                Intrinsics.throwNpe();
            }
            dbAnnotation = annotationBox;
            entities = this.processEntities(dbAnnotation, this.element);
            Map<TypeElement, DatabaseView> viewsMap = this.processDatabaseViews(dbAnnotation);
            this.validateForeignKeys(this.element, entities);
            this.validateExternalContentFts(this.element, entities);
            boolean extendsRoomDb = this.context.getProcessingEnv().getTypeUtils().isAssignable(MoreElements.asType((Element)this.element).asType(), this.getBaseClassElement());
            this.context.getChecker().check(extendsRoomDb, this.element, ProcessorErrors.INSTANCE.getDB_MUST_EXTEND_ROOM_DB(), new Object[0]);
            List<? extends Element> allMembers = this.context.getProcessingEnv().getElementUtils().getAllMembers(this.element);
            List views = CollectionsKt.toList((Iterable)viewsMap.values());
            DatabaseVerifier dbVerifier = Element_extKt.hasAnnotation((Element)this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(SkipQueryVerification.class)) ? null : DatabaseVerifier.Companion.create(this.context, this.element, entities, views);
            this.context.setDatabaseVerifier(dbVerifier);
            if (dbVerifier != null) {
                this.verifyDatabaseViews(viewsMap, dbVerifier);
            }
            resolvedViews = this.resolveDatabaseViews(views);
            this.validateUniqueTableAndViewNames(this.element, entities, views);
            DeclaredType declaredType = MoreTypes.asDeclared((TypeMirror)this.element.asType());
            List<? extends Element> list2 = allMembers;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"allMembers");
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Element element = it = (Element)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                if (!(Element_extKt.hasAnyOf(element, Modifier.ABSTRACT) && it.getKind() == ElementKind.METHOD)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Element element = it = (Element)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
                Element containing = element.getEnclosingElement();
                if (MoreElements.isType((Element)containing) && Intrinsics.areEqual((Object)TypeName.get((TypeMirror)containing.asType()), (Object)RoomTypeNames.INSTANCE.getROOM_DB())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                ExecutableElement executable;
                it = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                ExecutableElement executableElement = executable = MoreElements.asExecutable((Element)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)executableElement, (String)"executable");
                TypeMirror typeMirror2 = executableElement.getReturnType();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"executable.returnType");
                TypeElement daoType = Type_mirror_extKt.asTypeElement(typeMirror2);
                DeclaredType declaredType2 = declaredType;
                Intrinsics.checkExpressionValueIsNotNull((Object)declaredType2, (String)"declaredType");
                Dao dao = new DaoProcessor(this.context, daoType, declaredType2, dbVerifier).process();
                DaoMethod daoMethod = new DaoMethod(executable, executable.getSimpleName().toString(), dao);
                collection.add(daoMethod);
            }
            daoMethods = (List)destination$iv$iv;
            this.validateUniqueDaoClasses(this.element, daoMethods, entities);
            this.validateUniqueIndices(this.element, entities);
            Iterable $receiver$iv2 = entities;
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv2) {
                    Entity it2 = (Entity)element$iv;
                    list = (List<DatabaseView>)it2.getForeignKeys();
                    if (!(!list.isEmpty())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean hasForeignKeys = bl;
        int n = dbAnnotation.getValue().version();
        TypeMirror typeMirror3 = MoreElements.asType((Element)this.element).asType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror3, (String)"MoreElements.asType(element).asType()");
        boolean bl2 = hasForeignKeys;
        boolean bl3 = dbAnnotation.getValue().exportSchema();
        List list3 = daoMethods;
        list = resolvedViews;
        List<Entity> list4 = entities;
        TypeMirror typeMirror4 = typeMirror3;
        TypeElement typeElement = this.element;
        int n2 = n;
        androidx.room.vo.Database database = new androidx.room.vo.Database(typeElement, typeMirror4, list4, list, list3, n2, bl3, bl2);
        return database;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateForeignKeys(TypeElement element, List<? extends Entity> entities) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = entities;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            Entity entity = (Entity)element$iv$iv;
            Map map2 = destination$iv$iv;
            String string = it.getTableName();
            map2.put(string, element$iv$iv);
        }
        Map byTableName = destination$iv$iv;
        $receiver$iv = entities;
        for (Object element$iv : $receiver$iv) {
            Entity entity = (Entity)element$iv;
            Iterable $receiver$iv2 = entity.getForeignKeys();
            for (Object element$iv2 : $receiver$iv2) {
                Collection<String> collection;
                void $receiver$iv$iv2;
                void $receiver$iv3;
                void $receiver$iv$iv22;
                List<String> $receiver$iv32;
                ForeignKey foreignKey = (ForeignKey)element$iv2;
                Entity parent = (Entity)byTableName.get(foreignKey.getParentTable());
                if (parent == null) {
                    this.context.getLogger().e(element, ProcessorErrors.INSTANCE.foreignKeyMissingParentEntityInDatabase(foreignKey.getParentTable(), entity.getElement().getQualifiedName().toString()), new Object[0]);
                    continue;
                }
                List<String> list = $receiver$iv32 = (List<String>)foreignKey.getParentColumns();
                Collection destination$iv$iv2 = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv22;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    Field field;
                    Object element$iv$iv = element$iv$iv$iv;
                    String columnName = (String)element$iv$iv;
                    Field parentField = HasFieldsKt.findFieldByColumnName(parent, columnName);
                    if (parentField == null) {
                        this.context.getLogger().e(entity.getElement(), ProcessorErrors.INSTANCE.foreignKeyParentColumnDoesNotExist(parent.getElement().getQualifiedName().toString(), columnName, HasFieldsKt.getColumnNames(parent)), new Object[0]);
                    }
                    if (parentField == null) continue;
                    Field it$iv$iv = field;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List parentFields = (List)destination$iv$iv2;
                if (parentFields.size() != foreignKey.getParentColumns().size() || parent.isUnique(foreignKey.getParentColumns())) continue;
                $receiver$iv32 = foreignKey.getChildFields();
                List<String> list2 = foreignKey.getParentColumns();
                String string = entity.getElement().getQualifiedName().toString();
                String string2 = parent.getElement().getQualifiedName().toString();
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                Element element2 = parent.getElement();
                RLog rLog = this.context.getLogger();
                $receiver$iv$iv22 = $receiver$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object t : $receiver$iv$iv2) {
                    void it;
                    Object element$iv$iv$iv;
                    element$iv$iv$iv = (Field)t;
                    collection = destination$iv$iv3;
                    String string3 = it.getColumnName();
                    collection.add(string3);
                }
                Collection<String> collection2 = collection = (List)destination$iv$iv3;
                list = list2;
                String string4 = string;
                rLog.e(element2, processorErrors.foreignKeyMissingIndexInParent(string2, list, string4, (List<String>)collection2), new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueIndices(TypeElement element, List<? extends Entity> entities) {
        Object object;
        Object object2;
        Object object3;
        Object element$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv = entities;
        Object object4 = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        Object object5 = $receiver$iv$iv.iterator();
        while (object5.hasNext()) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            element$iv$iv = object5.next();
            Entity entity = (Entity)element$iv$iv;
            Iterable iterable = $receiver$iv2 = (Iterable)entity.getIndices();
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                object3 = (Index)item$iv$iv;
                object2 = destination$iv$iv2;
                object = new Pair((Object)it.getName(), (Object)entity);
                object2.add(object);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        object5 = $receiver$iv$iv.iterator();
        while (object5.hasNext()) {
            Object object6;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            element$iv$iv = object5.next();
            Pair pair = (Pair)element$iv$iv;
            String key$iv$iv = (String)pair.getFirst();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object6 = answer$iv$iv$iv;
            } else {
                object6 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object6;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        object5 = $receiver$iv$iv;
        for (Map.Entry entry : object5.entrySet()) {
            Map.Entry it = entry;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        $receiver$iv = destination$iv$iv;
        object4 = $receiver$iv;
        Iterator iterator = object4.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection;
            void $receiver$iv$iv3;
            TypeName key$iv;
            Pair it;
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = iterator.next();
            Iterable iterable = (Iterable)it2.getValue();
            Iterable<Object> set$iv = new HashSet<TypeName>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : iterable) {
                it = (Pair)e$iv;
                key$iv = ((Entity)it.getSecond()).getTypeName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            if (((List)list$iv).size() <= 1) continue;
            Iterable iterable2 = (Iterable)it2.getValue();
            object3 = (String)it2.getKey();
            object2 = ProcessorErrors.INSTANCE;
            object = element;
            RLog rLog = this.context.getLogger();
            set$iv = iterable2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv3) {
                key$iv = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                String string = ((Entity)it.getSecond()).getTypeName() + " > " + (String)it.getFirst();
                collection.add(string);
            }
            collection = (List)destination$iv$iv3;
            rLog.e((Element)object, ((ProcessorErrors)object2).duplicateIndexInDatabase((String)object3, (List<String>)collection), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueDaoClasses(TypeElement dbElement, List<DaoMethod> daoMethods, List<? extends Entity> entities) {
        Iterable $receiver$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        Object $receiver$iv$iv$iv;
        Object it;
        Object $receiver$iv$iv;
        Object $receiver$iv2 = entities;
        Iterable iterable = $receiver$iv2;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            TypeName typeName2 = ((Pojo)it).getTypeName();
            collection.add(typeName2);
        }
        Set entityTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv = $receiver$iv2 = (Iterable)daoMethods;
        destination$iv$iv = new LinkedHashMap();
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator.next();
            it = (DaoMethod)element$iv$iv;
            key$iv$iv = ((DaoMethod)it).getDao().getTypeName();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv2 = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv2;
        for (Map.Entry element$iv : $receiver$iv$iv.entrySet()) {
            Collection<String> $i$f$groupByTo;
            Iterator $receiver$iv$iv2;
            Map.Entry it2 = element$iv;
            if (((List)it2.getValue()).size() <= 1) continue;
            it = (Iterable)it2.getValue();
            TypeName typeName3 = (TypeName)it2.getKey();
            key$iv$iv = ProcessorErrors.INSTANCE;
            $receiver$iv$iv$iv = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            answer$iv$iv$iv = $receiver$iv$iv2.iterator();
            while (answer$iv$iv$iv.hasNext()) {
                void it3;
                Object item$iv$iv = answer$iv$iv$iv.next();
                DaoMethod $i$f$getOrPut = (DaoMethod)item$iv$iv;
                $i$f$groupByTo = destination$iv$iv2;
                String $i$f$groupBy = it3.getName();
                $i$f$groupByTo.add($i$f$groupBy);
            }
            $i$f$groupByTo = (List)destination$iv$iv2;
            String error = ((ProcessorErrors)key$iv$iv).duplicateDao(typeName3, (List<String>)$i$f$groupByTo);
            $receiver$iv = (Iterable)it2.getValue();
            $receiver$iv$iv2 = $receiver$iv.iterator();
            while ($receiver$iv$iv2.hasNext()) {
                Object element$iv2 = $receiver$iv$iv2.next();
                DaoMethod daoMethod = (DaoMethod)element$iv2;
                this.context.getLogger().e(daoMethod.getElement(), ProcessorErrors.INSTANCE.getDAO_METHOD_CONFLICTS_WITH_OTHERS(), new Object[0]);
            }
            this.context.getLogger().e(dbElement, error, new Object[0]);
        }
        Function3 check2 = (Function3)new Function3<Element, Dao, TypeName, Unit>(this, entityTypeNames, dbElement){
            final /* synthetic */ DatabaseProcessor this$0;
            final /* synthetic */ Set $entityTypeNames;
            final /* synthetic */ TypeElement $dbElement;

            public final void invoke(@NotNull Element element, @NotNull Dao dao, @Nullable TypeName typeName2) {
                block1: {
                    TypeName typeName3;
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    Intrinsics.checkParameterIsNotNull((Object)dao, (String)"dao");
                    TypeName typeName4 = typeName2;
                    if (typeName4 == null) break block1;
                    TypeName it = typeName3 = typeName4;
                    if (!this.$entityTypeNames.contains(typeName2)) {
                        RLog rLog = this.this$0.getContext().getLogger();
                        String string = this.$dbElement.getQualifiedName().toString();
                        String string2 = dao.getTypeName().toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dao.typeName.toString()");
                        String string3 = typeName2.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"typeName.toString()");
                        rLog.e(element, ProcessorErrors.INSTANCE.shortcutEntityIsNotInDatabase(string, string2, string3), new Object[0]);
                    }
                }
            }
            {
                this.this$0 = databaseProcessor;
                this.$entityTypeNames = set;
                this.$dbElement = typeElement;
                super(3);
            }
        };
        Iterable $receiver$iv3 = daoMethods;
        for (Map.Entry element$iv : $receiver$iv3) {
            Map.Entry<String, Entity> it4;
            Map.Entry<String, Entity> element$iv3;
            Iterator<Map.Entry<String, Entity>> iterator2;
            Map<String, Entity> map2;
            Map<String, Entity> $receiver$iv4;
            Object method;
            DaoMethod daoMethod = (DaoMethod)((Object)element$iv);
            $receiver$iv = daoMethod.getDao().getShortcutMethods();
            for (Object element$iv4 : $receiver$iv) {
                method = (ShortcutMethod)element$iv4;
                map2 = $receiver$iv4 = ((ShortcutMethod)method).getEntities();
                iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    it4 = element$iv3 = iterator2.next();
                    check2.invoke((Object)((ShortcutMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)it4.getValue().getTypeName());
                }
            }
            $receiver$iv = daoMethod.getDao().getInsertionMethods();
            for (Object element$iv4 : $receiver$iv) {
                method = (InsertionMethod)element$iv4;
                map2 = $receiver$iv4 = ((InsertionMethod)method).getEntities();
                iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    it4 = element$iv3 = iterator2.next();
                    check2.invoke((Object)((InsertionMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)it4.getValue().getTypeName());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueTableAndViewNames(TypeElement dbElement, List<? extends Entity> entities, List<DatabaseView> views) {
        List list$iv$iv;
        Map $receiver$iv;
        ProcessorErrors processorErrors;
        Map $receiver$iv$iv;
        Triple triple;
        Object object;
        Collection collection;
        Object item$iv$iv22;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Iterable iterable = $receiver$iv2 = (Iterable)entities;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv22 : $receiver$iv$iv2) {
            String string;
            void it;
            Entity entity = (Entity)item$iv$iv22;
            collection = destination$iv$iv;
            String object2 = it.getTableName();
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.US, (String)"Locale.US");
            String string2 = object2;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.toLowerCase((Locale)object), (String)"(this as java.lang.String).toLowerCase(locale)");
            TypeElement typeElement = it.getElement();
            String string3 = it.getTypeName().toString();
            String string4 = string;
            triple = new Triple((Object)string4, (Object)string3, (Object)typeElement);
            collection.add(triple);
        }
        List entitiesInfo = (List)destination$iv$iv;
        Iterable $receiver$iv22 = views;
        destination$iv$iv = $receiver$iv22;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv22, (int)10));
        item$iv$iv22 = $receiver$iv$iv.iterator();
        while (item$iv$iv22.hasNext()) {
            String $i$a$1$map;
            Object item$iv$iv3 = item$iv$iv22.next();
            DatabaseView databaseView = (DatabaseView)item$iv$iv3;
            collection = destination$iv$iv2;
            object = databaseView.getViewName();
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.US, (String)"Locale.US");
            Object object2 = object;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)object2).toLowerCase((Locale)((Object)processorErrors)), (String)"(this as java.lang.String).toLowerCase(locale)");
            TypeElement typeElement = databaseView.getElement();
            String string = databaseView.getTypeName().toString();
            String string4 = $i$a$1$map;
            triple = new Triple((Object)string4, (Object)string, (Object)typeElement);
            collection.add(triple);
        }
        List viewsInfo = (List)destination$iv$iv2;
        $receiver$iv22 = CollectionsKt.plus((Collection)entitiesInfo, (Iterable)viewsInfo);
        $receiver$iv$iv = $receiver$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        item$iv$iv22 = $receiver$iv$iv.iterator();
        while (item$iv$iv22.hasNext()) {
            Object object3;
            Map $receiver$iv$iv$iv = destination$iv$iv3;
            Object element$iv$iv = item$iv$iv22.next();
            Triple triple2 = (Triple)element$iv$iv;
            String name = (String)triple2.component1();
            String key$iv$iv = name;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv3;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv3 = new LinkedHashMap();
        item$iv$iv22 = $receiver$iv$iv;
        for (Map.Entry entry : item$iv$iv22.entrySet()) {
            Map.Entry it = entry;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv3.put(entry.getKey(), entry.getValue());
        }
        $receiver$iv = destination$iv$iv3;
        Map object5 = $receiver$iv;
        Iterator<Object> iterator = object5.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection2;
            void $receiver$iv$iv3;
            Map.Entry element$iv;
            Map.Entry byName = element$iv = (Map.Entry)iterator.next();
            Iterable iterable2 = (Iterable)byName.getValue();
            object = (String)byName.getKey();
            processorErrors = ProcessorErrors.INSTANCE;
            Iterable $i$f$filterTo = iterable2;
            Collection destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            for (Object item$iv$iv4 : $receiver$iv$iv3) {
                void $$_$_typeName_$_$;
                String typeName2;
                list$iv$iv = (Triple)item$iv$iv4;
                collection2 = destination$iv$iv32;
                String string = typeName2 = (String)$$_$_typeName_$_$.component2();
                collection2.add(string);
            }
            collection2 = (List)destination$iv$iv32;
            String error = processorErrors.duplicateTableNames((String)object, (List<String>)collection2);
            Iterable iterable3 = (Iterable)byName.getValue();
            for (Object element$iv2 : iterable3) {
                Triple $$_$_$_$_element = (Triple)element$iv2;
                TypeElement element = (TypeElement)$$_$_$_$_element.component3();
                this.context.getLogger().e(element, error, new Object[0]);
            }
            this.context.getLogger().e(dbElement, error, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateExternalContentFts(TypeElement dbElement, List<? extends Entity> entities) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.filterIsInstance((Iterable)entities, FtsEntity.class);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FtsEntity it = (FtsEntity)element$iv$iv;
            if (it.getFtsOptions().getContentEntity() == null || entities.contains(it.getFtsOptions().getContentEntity())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            FtsEntity it = (FtsEntity)element$iv;
            RLog rLog = this.context.getLogger();
            Element element = dbElement;
            String string = it.getElement().getQualifiedName().toString();
            Entity entity = it.getFtsOptions().getContentEntity();
            if (entity == null) {
                Intrinsics.throwNpe();
            }
            rLog.e(element, ProcessorErrors.INSTANCE.missingExternalContentEntity(string, entity.getElement().getQualifiedName().toString()), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> processEntities(AnnotationBox<Database> dbAnnotation, TypeElement element) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<TypeMirror> entityList = dbAnnotation.getAsTypeMirrorList("entities");
        Collection collection = entityList;
        Object object = this.context.getChecker();
        boolean bl = !collection.isEmpty();
        ((Checks)object).check(bl, element, ProcessorErrors.INSTANCE.getDATABASE_ANNOTATION_MUST_HAVE_LIST_OF_ENTITIES(), new Object[0]);
        Iterable iterable = $receiver$iv = (Iterable)entityList;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeMirror typeMirror2 = (TypeMirror)item$iv$iv;
            object = destination$iv$iv;
            Entity entity = EntityProcessorKt.EntityProcessor$default(this.context, Type_mirror_extKt.asTypeElement((TypeMirror)it), null, 4, null).process();
            object.add(entity);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<TypeElement, DatabaseView> processDatabaseViews(AnnotationBox<Database> dbAnnotation) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<TypeMirror> viewList = dbAnnotation.getAsTypeMirrorList("views");
        Iterable iterable = $receiver$iv = (Iterable)viewList;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeMirror typeMirror2 = (TypeMirror)item$iv$iv;
            Collection collection = destination$iv$iv;
            TypeElement viewElement = Type_mirror_extKt.asTypeElement((TypeMirror)it);
            Pair pair = TuplesKt.to((Object)viewElement, (Object)new DatabaseViewProcessor(this.context, viewElement, null, 4, null).process());
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final void verifyDatabaseViews(Map<TypeElement, DatabaseView> map2, DatabaseVerifier dbVerifier) {
        Map<TypeElement, DatabaseView> map3 = map2;
        Iterator<Map.Entry<TypeElement, DatabaseView>> iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TypeElement, DatabaseView> entry;
            Map.Entry<TypeElement, DatabaseView> entry2 = entry = iterator.next();
            TypeElement viewElement = entry2.getKey();
            entry2 = entry;
            DatabaseView view = entry2.getValue();
            if (Element_extKt.hasAnnotation((Element)viewElement, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(SkipQueryVerification.class))) continue;
            view.getQuery().setResultInfo(dbVerifier.analyze(view.getQuery().getOriginal()));
            QueryResultInfo queryResultInfo = view.getQuery().getResultInfo();
            if ((queryResultInfo != null ? queryResultInfo.getError() : null) == null) continue;
            RLog rLog = this.context.getLogger();
            Element element = viewElement;
            QueryResultInfo queryResultInfo2 = view.getQuery().getResultInfo();
            if (queryResultInfo2 == null) {
                Intrinsics.throwNpe();
            }
            SQLException sQLException = queryResultInfo2.getError();
            if (sQLException == null) {
                Intrinsics.throwNpe();
            }
            rLog.e(element, DatabaseVerificaitonErrors.INSTANCE.cannotVerifyQuery(sQLException), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DatabaseView> resolveDatabaseViews(@NotNull List<DatabaseView> views) {
        Collection collection;
        Object object;
        Object name;
        Object object2;
        Object object3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(views, (String)"views");
        if (views.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = $receiver$iv = (Iterable)views;
        Set<String> destination$iv$iv = (Set<String>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DatabaseView databaseView = (DatabaseView)item$iv$iv;
            object3 = destination$iv$iv;
            object2 = it.getViewName();
            object3.add(object2);
        }
        List viewNames = (List)((Object)destination$iv$iv);
        Function1<String, Boolean> isTable$ = new Function1<String, Boolean>(viewNames){
            final /* synthetic */ List $viewNames;

            public final boolean invoke(@NotNull String name) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Iterable $receiver$iv = this.$viewNames;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            String it = (String)element$iv;
                            if (!StringsKt.equals((String)it, (String)name, (boolean)true)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
            {
                this.$viewNames = list;
                super(1);
            }
        };
        for (DatabaseView view : views) {
            void $receiver$iv$iv2;
            void $receiver$iv2;
            Object item$iv$iv;
            Iterable iterable2 = view.getQuery().getTables();
            object3 = view.getTables();
            item$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                void $name_$_$;
                Table $i$f$map = (Table)item$iv$iv2;
                object2 = destination$iv$iv2;
                object = name = $name_$_$.component1();
                object2.add(object);
            }
            object2 = (List)destination$iv$iv2;
            object3.addAll((Collection)object2);
        }
        List unresolvedViews = CollectionsKt.toMutableList((Collection)views);
        Map resolvedViews = new LinkedHashMap();
        List result = new ArrayList();
        int step = 0;
        do {
            Iterable $receiver$iv2;
            Set<String> $receiver$iv3;
            Object view;
            Object $receiver$iv$iv3;
            Iterable $receiver$iv4;
            Object view222;
            String viewName;
            Object item$iv$iv2;
            item$iv$iv2 = resolvedViews;
            for (Map.Entry destination$iv$iv2 : item$iv$iv2.entrySet()) {
                name = destination$iv$iv2;
                viewName = (String)name.getKey();
                name = destination$iv$iv2;
                Set tables = (Set)name.getValue();
                for (Object view222 : unresolvedViews) {
                    if (!((DatabaseView)view222).getTables().removeIf(new Predicate<String>(viewName){
                        final /* synthetic */ String $viewName;

                        public final boolean test(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return StringsKt.equals((String)it, (String)this.$viewName, (boolean)true);
                        }
                        {
                            this.$viewName = string;
                        }
                    })) continue;
                    ((DatabaseView)view222).getTables().addAll(tables);
                }
            }
            int countNewlyResolved = 0;
            Iterable $i$a$1$map = unresolvedViews;
            viewName = $receiver$iv4;
            Collection destination$iv$iv3 = new ArrayList();
            view222 = $receiver$iv$iv3.iterator();
            while (view222.hasNext()) {
                boolean bl;
                Object element$iv$iv232;
                block14: {
                    element$iv$iv232 = view222.next();
                    view = (DatabaseView)element$iv$iv232;
                    $receiver$iv3 = ((DatabaseView)view).getTables();
                    if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object t : $receiver$iv3) {
                            String it = (String)t;
                            if (isTable$.invoke(it)) continue;
                            bl = false;
                            break block14;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv3.add(element$iv$iv232);
            }
            $receiver$iv4 = (List)destination$iv$iv3;
            $receiver$iv$iv3 = $receiver$iv2.iterator();
            while ($receiver$iv$iv3.hasNext()) {
                Object element$iv = $receiver$iv$iv3.next();
                DatabaseView view2 = (DatabaseView)element$iv;
                Map element$iv$iv232 = resolvedViews;
                view = view2.getViewName();
                $receiver$iv3 = view2.getTables();
                element$iv$iv232.put(view, $receiver$iv3);
                unresolvedViews.remove(view2);
                result.add(view2);
                int element$iv$iv232 = countNewlyResolved;
                countNewlyResolved = element$iv$iv232 + 1;
            }
            if (countNewlyResolved == 0) {
                Collection<String> collection2;
                void $receiver$iv$iv2;
                $receiver$iv2 = unresolvedViews;
                object = ProcessorErrors.INSTANCE;
                object2 = this.element;
                object3 = this.context.getLogger();
                $receiver$iv$iv3 = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void it;
                    view = (DatabaseView)item$iv$iv;
                    collection2 = destination$iv$iv2;
                    String string = it.getViewName();
                    collection2.add(string);
                }
                collection2 = (List)destination$iv$iv2;
                ((RLog)object3).e((Element)object2, ((ProcessorErrors)object).viewCircularReferenceDetected((List<String>)collection2), new Object[0]);
                break;
            }
            ++step;
        } while (!(collection = (Collection)unresolvedViews).isEmpty());
        return result;
    }

    @NotNull
    public final TypeElement getElement() {
        return this.element;
    }

    public DatabaseProcessor(@NotNull Context baseContext, @NotNull TypeElement element) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.element = element;
        this.context = baseContext.fork(this.element);
        this.baseClassElement$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TypeMirror>(this){
            final /* synthetic */ DatabaseProcessor this$0;

            public final TypeMirror invoke() {
                return this.this$0.getContext().getProcessingEnv().getElementUtils().getTypeElement(RoomTypeNames.INSTANCE.getROOM_DB().packageName() + "." + RoomTypeNames.INSTANCE.getROOM_DB().simpleName()).asType();
            }
            {
                this.this$0 = databaseProcessor;
                super(0);
            }
        }));
    }
}

