/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.jarjarred.org.antlr.v4.tool;

import androidx.room.jarjarred.org.antlr.runtime.Token;
import androidx.room.jarjarred.org.antlr.v4.tool.ErrorType;
import androidx.room.jarjarred.org.antlr.v4.tool.Grammar;
import androidx.room.jarjarred.org.stringtemplate.v4.ST;
import java.util.Arrays;

public class ANTLRMessage {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final ErrorType errorType;
    private final Object[] args;
    private final Throwable e;
    public String fileName;
    public int line = -1;
    public int charPosition = -1;
    public Grammar g;
    public Token offendingToken;

    public ANTLRMessage(ErrorType errorType) {
        this(errorType, (Throwable)null, Token.INVALID_TOKEN, new Object[0]);
    }

    public ANTLRMessage(ErrorType errorType, Token offendingToken, Object ... args2) {
        this(errorType, null, offendingToken, args2);
    }

    public ANTLRMessage(ErrorType errorType, Throwable e, Token offendingToken, Object ... args2) {
        this.errorType = errorType;
        this.e = e;
        this.args = args2;
        this.offendingToken = offendingToken;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public Object[] getArgs() {
        if (this.args == null) {
            return EMPTY_ARGS;
        }
        return this.args;
    }

    public ST getMessageTemplate(boolean verbose) {
        Throwable cause;
        ST messageST = new ST(this.getErrorType().msg);
        messageST.impl.name = this.errorType.name();
        messageST.add("verbose", verbose);
        Object[] args2 = this.getArgs();
        for (int i = 0; i < args2.length; ++i) {
            String attr = "arg";
            if (i > 0) {
                attr = attr + (i + 1);
            }
            messageST.add(attr, args2[i]);
        }
        if (args2.length < 2) {
            messageST.add("arg2", null);
        }
        if ((cause = this.getCause()) != null) {
            messageST.add("exception", cause);
            messageST.add("stackTrace", cause.getStackTrace());
        } else {
            messageST.add("exception", null);
            messageST.add("stackTrace", null);
        }
        return messageST;
    }

    public Throwable getCause() {
        return this.e;
    }

    public String toString() {
        return "Message{errorType=" + (Object)((Object)this.getErrorType()) + ", args=" + Arrays.asList(this.getArgs()) + ", e=" + this.getCause() + ", fileName='" + this.fileName + '\'' + ", line=" + this.line + ", charPosition=" + this.charPosition + '}';
    }
}

