/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.RawQuery;
import androidx.room.Transaction;
import androidx.room.ext.AnnotationBox;
import androidx.room.ext.Element_extKt;
import androidx.room.ext.Javapoet_extKt;
import androidx.room.ext.Processing_env_extKt;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.log.RLog;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.SqlParser;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.FieldProcessor;
import androidx.room.processor.MethodProcessorDelegate;
import androidx.room.processor.PojoProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.query.result.QueryResultBinder;
import androidx.room.vo.Entity;
import androidx.room.vo.Pojo;
import androidx.room.vo.RawQueryMethod;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Landroidx/room/processor/RawQueryMethodProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Ljavax/lang/model/type/DeclaredType;", "executableElement", "Ljavax/lang/model/element/ExecutableElement;", "(Landroidx/room/processor/Context;Ljavax/lang/model/type/DeclaredType;Ljavax/lang/model/element/ExecutableElement;)V", "getContaining", "()Ljavax/lang/model/type/DeclaredType;", "context", "getContext", "()Landroidx/room/processor/Context;", "getExecutableElement", "()Ljavax/lang/model/element/ExecutableElement;", "findRuntimeQueryParameter", "Landroidx/room/vo/RawQueryMethod$RuntimeQueryParameter;", "extractParams", "", "Ljavax/lang/model/element/VariableElement;", "process", "Landroidx/room/vo/RawQueryMethod;", "processObservedTables", "", "", "room-compiler"})
public final class RawQueryMethodProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final DeclaredType containing;
    @NotNull
    private final ExecutableElement executableElement;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final RawQueryMethod process() {
        MethodProcessorDelegate delegate = MethodProcessorDelegate.Companion.createFor(this.context, this.containing, this.executableElement);
        TypeMirror returnType = delegate.extractReturnType();
        this.context.getChecker().check(Element_extKt.hasAnnotation((Element)this.executableElement, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(RawQuery.class)), this.executableElement, ProcessorErrors.INSTANCE.getMISSING_RAWQUERY_ANNOTATION(), new Object[0]);
        TypeName returnTypeName = Javapoet_extKt.typeName(returnType);
        Checks checks = this.context.getChecker();
        TypeName typeName2 = returnTypeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"returnTypeName");
        checks.notUnbound(typeName2, this.executableElement, ProcessorErrors.INSTANCE.getCANNOT_USE_UNBOUND_GENERICS_IN_QUERY_METHODS(), new Object[0]);
        Set<String> observedTableNames = this.processObservedTables();
        ParsedQuery query2 = SqlParser.Companion.rawQueryForTables(observedTableNames);
        QueryResultBinder resultBinder = delegate.findResultBinder(returnType, query2);
        RawQueryMethod.RuntimeQueryParameter runtimeQueryParam = this.findRuntimeQueryParameter(delegate.extractParams());
        boolean inTransaction = Element_extKt.hasAnnotation((Element)this.executableElement, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Transaction.class));
        QueryResultBinder queryResultBinder = resultBinder;
        boolean bl = inTransaction;
        RawQueryMethod.RuntimeQueryParameter runtimeQueryParameter = runtimeQueryParam;
        TypeMirror typeMirror2 = returnType;
        Set<String> set = observedTableNames;
        RawQueryMethod rawQueryMethod = new RawQueryMethod(this.executableElement, Element_extKt.getName(this.executableElement), typeMirror2, bl, set, runtimeQueryParameter, queryResultBinder);
        this.context.getChecker().check(rawQueryMethod.getReturnsValue(), this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_BAD_RETURN_TYPE(), new Object[0]);
        return rawQueryMethod;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> processObservedTables() {
        Object object;
        block9: {
            block8: {
                void $this$flatMapTo$iv$iv;
                TypeElement it;
                Iterable $this$mapTo$iv$iv;
                AnnotationBox annotation = Element_extKt.toAnnotationBox(this.executableElement, Reflection.getOrCreateKotlinClass(RawQuery.class));
                object = annotation;
                if (object == null || (object = ((AnnotationBox)object).getAsTypeMirrorList("observedEntities")) == null) break block8;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    TypeMirror typeMirror2 = (TypeMirror)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    TypeElement typeElement = Type_mirror_extKt.asTypeElement((TypeMirror)((Object)it));
                    collection.add(typeElement);
                }
                Iterable $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                $this$mapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List<String> list;
                    it = (TypeElement)element$iv$iv;
                    boolean bl = false;
                    if (Element_extKt.isEntityElement(it)) {
                        Entity entity = EntityProcessorKt.EntityProcessor$default(this.context, it, null, 4, null).process();
                        list = CollectionsKt.arrayListOf((Object[])new String[]{entity.getTableName()});
                    } else {
                        Pojo pojo = PojoProcessor.Companion.createFor$default(PojoProcessor.Companion, this.context, it, FieldProcessor.BindingScope.READ_FROM_CURSOR, null, null, 16, null).process();
                        List<String> tableNames2 = pojo.accessedTableNames();
                        if (tableNames2.isEmpty()) {
                            RLog rLog = this.context.getLogger();
                            Element element = this.executableElement;
                            TypeName typeName2 = Javapoet_extKt.typeName(Element_extKt.getType(it));
                            Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"it.type.typeName()");
                            rLog.e(element, ProcessorErrors.INSTANCE.rawQueryBadEntity(typeName2), new Object[0]);
                        }
                        list = tableNames2;
                    }
                    Iterable list$iv$iv = list;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (object != null) break block9;
            }
            object = SetsKt.emptySet();
        }
        return object;
    }

    private final RawQueryMethod.RuntimeQueryParameter findRuntimeQueryParameter(List<? extends VariableElement> extractParams) {
        Types types = this.context.getProcessingEnv().getTypeUtils();
        if (extractParams.size() == 1 && !this.executableElement.isVarArgs()) {
            VariableElement variableElement = (VariableElement)CollectionsKt.first(extractParams);
            Types types2 = types;
            Intrinsics.checkExpressionValueIsNotNull((Object)types2, (String)"types");
            TypeMirror param = Element_extKt.asMemberOf(variableElement, types2, this.containing);
            ProcessingEnvironment processingEnv = this.context.getProcessingEnv();
            TypeMirror supportQueryType = Processing_env_extKt.requireTypeMirror(processingEnv, (TypeName)SupportDbTypeNames.INSTANCE.getQUERY());
            TypeMirror typeMirror2 = param;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"param");
            boolean isSupportSql = Type_mirror_extKt.isAssignableFrom(supportQueryType, types, typeMirror2);
            if (isSupportSql) {
                String string = Element_extKt.getName(extractParams.get(0));
                TypeName typeName2 = Javapoet_extKt.typeName(supportQueryType);
                Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"supportQueryType.typeName()");
                return new RawQueryMethod.RuntimeQueryParameter(string, typeName2);
            }
            TypeMirror stringType = Processing_env_extKt.requireTypeMirror(processingEnv, "java.lang.String");
            boolean isString = Type_mirror_extKt.isAssignableFrom(stringType, types, param);
            if (isString) {
                this.context.getLogger().e(this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_STRING_PARAMETER_REMOVED(), new Object[0]);
                return null;
            }
        }
        this.context.getLogger().e(this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_BAD_PARAMS(), new Object[0]);
        return null;
    }

    @NotNull
    public final DeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final ExecutableElement getExecutableElement() {
        return this.executableElement;
    }

    public RawQueryMethodProcessor(@NotNull Context baseContext, @NotNull DeclaredType containing, @NotNull ExecutableElement executableElement) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)containing, (String)"containing");
        Intrinsics.checkParameterIsNotNull((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = Context.fork$default(baseContext, this.executableElement, null, 2, null);
    }
}

