/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.annotation.NonNull;
import androidx.room.compiler.processing.JavaPoetExtKt;
import androidx.room.compiler.processing.XElement;
import androidx.room.ext.Javapoet_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.migration.bundle.DatabaseViewBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FtsEntityBundle;
import androidx.room.migration.bundle.IndexBundle;
import androidx.room.vo.AutoMigration;
import androidx.room.writer.ClassWriter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JD\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0,2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010/\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u00101\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00102\u001a\u00020)2\u0006\u0010.\u001a\u00020)2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0,H\u0002J\u0018\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u00105\u001a\u000206H\u0002J\n\u00107\u001a\u0004\u0018\u000106H\u0002J\b\u00108\u001a\u000209H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Landroidx/room/writer/AutoMigrationWriter;", "Landroidx/room/writer/ClassWriter;", "dbElement", "Landroidx/room/compiler/processing/XElement;", "autoMigration", "Landroidx/room/vo/AutoMigration;", "(Landroidx/room/compiler/processing/XElement;Landroidx/room/vo/AutoMigration;)V", "addedColumns", "", "", "Landroidx/room/vo/AutoMigration$AddedColumn;", "addedTables", "", "Landroidx/room/vo/AutoMigration$AddedTable;", "getAutoMigration", "()Landroidx/room/vo/AutoMigration;", "complexChangedTables", "Landroidx/room/vo/AutoMigration$ComplexChangedTable;", "deletedTables", "", "renamedTables", "addComplexChangeStatements", "", "migrateBuilder", "Lcom/squareup/javapoet/MethodSpec$Builder;", "addDatabaseExecuteSqlStatement", "sql", "addDeleteTableStatements", "addDropViewStatements", "addMigrationStatements", "addNewColumnStatements", "addNewTableStatements", "addRecreateViewStatements", "addRenameTableStatements", "addSimpleChangeStatements", "addStatementsToCheckForeignKeyConstraint", "tableName", "addStatementsToContentTransfer", "oldTableName", "tableNameWithNewPrefix", "oldEntityBundle", "Landroidx/room/migration/bundle/EntityBundle;", "newEntityBundle", "renamedColumnsMap", "", "addStatementsToCreateNewTable", "newTable", "addStatementsToDropTableAndRenameTempTable", "newTableName", "addStatementsToMigrateFtsTable", "oldTable", "addStatementsToRecreateIndexes", "table", "createConstructor", "Lcom/squareup/javapoet/MethodSpec;", "createMigrateMethod", "createTypeSpecBuilder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "room-compiler"})
public final class AutoMigrationWriter
extends ClassWriter {
    @NotNull
    private final XElement dbElement;
    @NotNull
    private final AutoMigration autoMigration;
    @NotNull
    private final Map<String, AutoMigration.AddedColumn> addedColumns;
    @NotNull
    private final Set<AutoMigration.AddedTable> addedTables;
    @NotNull
    private final Map<String, String> renamedTables;
    @NotNull
    private final Map<String, AutoMigration.ComplexChangedTable> complexChangedTables;
    @NotNull
    private final List<String> deletedTables;

    public AutoMigrationWriter(@NotNull XElement dbElement, @NotNull AutoMigration autoMigration) {
        Intrinsics.checkNotNullParameter((Object)dbElement, (String)"dbElement");
        Intrinsics.checkNotNullParameter((Object)autoMigration, (String)"autoMigration");
        super(autoMigration.getImplTypeName());
        this.dbElement = dbElement;
        this.autoMigration = autoMigration;
        this.addedColumns = this.autoMigration.getSchemaDiff().getAddedColumns();
        this.addedTables = this.autoMigration.getSchemaDiff().getAddedTables();
        this.renamedTables = this.autoMigration.getSchemaDiff().getRenamedTables();
        this.complexChangedTables = this.autoMigration.getSchemaDiff().getComplexChangedTables();
        this.deletedTables = this.autoMigration.getSchemaDiff().getDeletedTables();
    }

    @NotNull
    public final AutoMigration getAutoMigration() {
        return this.autoMigration;
    }

    @Override
    @NotNull
    public TypeSpec.Builder createTypeSpecBuilder() {
        TypeSpec.Builder builder;
        TypeSpec.Builder builder2 = builder = TypeSpec.classBuilder((ClassName)this.autoMigration.getImplTypeName());
        boolean bl = false;
        boolean bl2 = false;
        TypeSpec.Builder $this$createTypeSpecBuilder_u24lambda_u2d1 = builder2;
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$createTypeSpecBuilder_u24lambda_u2d1, (String)"");
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)$this$createTypeSpecBuilder_u24lambda_u2d1, (XElement)this.dbElement);
        $this$createTypeSpecBuilder_u24lambda_u2d1.superclass((TypeName)RoomTypeNames.INSTANCE.getMIGRATION());
        if (this.getAutoMigration().getSpecClassName() != null) {
            Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
            modifierArray = FieldSpec.builder((TypeName)((TypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC()), (String)"callback", (Modifier[])modifierArray);
            boolean bl4 = false;
            boolean bl5 = false;
            Modifier[] $this$createTypeSpecBuilder_u24lambda_u2d1_u24lambda_u2d0 = modifierArray;
            boolean bl6 = false;
            if (!this.getAutoMigration().isSpecProvided()) {
                Object[] objectArray = new Object[]{this.getAutoMigration().getSpecClassName()};
                $this$createTypeSpecBuilder_u24lambda_u2d1_u24lambda_u2d0.initializer("new " + Javapoet_extKt.getT() + "()", objectArray);
            }
            Modifier[] callbackField = modifierArray;
            builder.addField(callbackField.build());
        }
        $this$createTypeSpecBuilder_u24lambda_u2d1.addMethod(this.createConstructor());
        $this$createTypeSpecBuilder_u24lambda_u2d1.addMethod(this.createMigrateMethod());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        return builder;
    }

    private final MethodSpec createConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$createConstructor_u24lambda_u2d2 = builder;
        boolean bl3 = false;
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        $this$createConstructor_u24lambda_u2d2.addModifiers(objectArray);
        objectArray = new Object[]{this.getAutoMigration().getFrom(), this.getAutoMigration().getTo()};
        $this$createConstructor_u24lambda_u2d2.addStatement("super(" + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getL() + ')', objectArray);
        if (this.getAutoMigration().isSpecProvided()) {
            $this$createConstructor_u24lambda_u2d2.addParameter(ParameterSpec.builder((TypeName)((TypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC()), (String)"callback", (Modifier[])new Modifier[0]).addAnnotation(NonNull.class).build());
            $this$createConstructor_u24lambda_u2d2.addStatement("this.callback = callback", new Object[0]);
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"constructorBuilder().apply {\n            addModifiers(Modifier.PUBLIC)\n            addStatement(\n                \"super($L, $L)\",\n                autoMigration.from,\n                autoMigration.to\n            )\n            if (autoMigration.isSpecProvided) {\n                addParameter(\n                    ParameterSpec.builder(\n                        RoomTypeNames.AUTO_MIGRATION_SPEC,\n                        \"callback\"\n                    ).addAnnotation(NonNull::class.java).build()\n                )\n                addStatement(\"this.callback = callback\")\n            }\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createMigrateMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"migrate");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$createMigrateMethod_u24lambda_u2d3 = builder;
        boolean bl3 = false;
        $this$createMigrateMethod_u24lambda_u2d3.addParameter(ParameterSpec.builder((TypeName)((TypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)"database", (Modifier[])new Modifier[0]).addAnnotation(NonNull.class).build());
        $this$createMigrateMethod_u24lambda_u2d3.addAnnotation(Override.class);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        $this$createMigrateMethod_u24lambda_u2d3.addModifiers(modifierArray);
        $this$createMigrateMethod_u24lambda_u2d3.returns(TypeName.VOID);
        Intrinsics.checkNotNullExpressionValue((Object)$this$createMigrateMethod_u24lambda_u2d3, (String)"this");
        this.addMigrationStatements($this$createMigrateMethod_u24lambda_u2d3);
        if (this.getAutoMigration().getSpecClassName() != null) {
            $this$createMigrateMethod_u24lambda_u2d3.addStatement("callback.onPostMigrate(database)", new Object[0]);
        }
        MethodSpec.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"methodBuilder(\"migrate\")\n            .apply {\n                addParameter(\n                    ParameterSpec.builder(\n                        SupportDbTypeNames.DB,\n                        \"database\"\n                    ).addAnnotation(NonNull::class.java).build()\n                )\n                addAnnotation(Override::class.java)\n                addModifiers(Modifier.PUBLIC)\n                returns(TypeName.VOID)\n                addMigrationStatements(this)\n                if (autoMigration.specClassName != null) {\n                    addStatement(\"callback.onPostMigrate(database)\")\n                }\n            }");
        MethodSpec.Builder migrateFunctionBuilder = builder2;
        return migrateFunctionBuilder.build();
    }

    private final void addMigrationStatements(MethodSpec.Builder migrateBuilder) {
        this.addDropViewStatements(migrateBuilder);
        this.addSimpleChangeStatements(migrateBuilder);
        this.addComplexChangeStatements(migrateBuilder);
        this.addRecreateViewStatements(migrateBuilder);
    }

    private final void addDropViewStatements(MethodSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.autoMigration.getSchemaDiff().getFromViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseViewBundle view = (DatabaseViewBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, Intrinsics.stringPlus((String)"DROP VIEW ", (Object)view.getViewName()));
        }
    }

    private final void addRecreateViewStatements(MethodSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.autoMigration.getSchemaDiff().getToViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseViewBundle view = (DatabaseViewBundle)element$iv;
            boolean bl = false;
            String string = view.createView();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"view.createView()");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, string);
        }
    }

    private final void addComplexChangeStatements(MethodSpec.Builder migrateBuilder) {
        Iterable $this$sortedBy$iv = this.complexChangedTables.values();
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                AutoMigration.ComplexChangedTable it = (AutoMigration.ComplexChangedTable)a;
                boolean bl2 = false;
                Comparable comparable = Boolean.valueOf(it.getNewVersionEntityBundle() instanceof FtsEntityBundle);
                it = (AutoMigration.ComplexChangedTable)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Boolean bl3 = it.getNewVersionEntityBundle() instanceof FtsEntityBundle;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)bl3);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl2;
            Object object;
            AutoMigration.ComplexChangedTable $dstr$_u24__u24$tableNameWithNewPrefix$oldEntityBundle$newEntityBundle$renamedColumnsMap = (AutoMigration.ComplexChangedTable)element$iv;
            boolean bl3 = false;
            String tableNameWithNewPrefix = $dstr$_u24__u24$tableNameWithNewPrefix$oldEntityBundle$newEntityBundle$renamedColumnsMap.component2();
            EntityBundle oldEntityBundle = $dstr$_u24__u24$tableNameWithNewPrefix$oldEntityBundle$newEntityBundle$renamedColumnsMap.component3();
            EntityBundle newEntityBundle = $dstr$_u24__u24$tableNameWithNewPrefix$oldEntityBundle$newEntityBundle$renamedColumnsMap.component4();
            Map<String, String> renamedColumnsMap = $dstr$_u24__u24$tableNameWithNewPrefix$oldEntityBundle$newEntityBundle$renamedColumnsMap.component5();
            if (oldEntityBundle instanceof FtsEntityBundle) {
                object = ((FtsEntityBundle)oldEntityBundle).getFtsOptions().getContentTable();
                bl2 = false;
                boolean bl4 = false;
                if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                    this.addStatementsToMigrateFtsTable(migrateBuilder, oldEntityBundle, newEntityBundle, renamedColumnsMap);
                    continue;
                }
            }
            this.addStatementsToCreateNewTable(newEntityBundle, migrateBuilder);
            object = oldEntityBundle.getTableName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"oldEntityBundle.tableName");
            this.addStatementsToContentTransfer((String)object, tableNameWithNewPrefix, oldEntityBundle, newEntityBundle, renamedColumnsMap, migrateBuilder);
            object = oldEntityBundle.getTableName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"oldEntityBundle.tableName");
            CharSequence charSequence = object;
            object = newEntityBundle.getTableName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newEntityBundle.tableName");
            this.addStatementsToDropTableAndRenameTempTable((String)charSequence, (String)object, tableNameWithNewPrefix, migrateBuilder);
            this.addStatementsToRecreateIndexes(newEntityBundle, migrateBuilder);
            object = newEntityBundle.getForeignKeys();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newEntityBundle.foreignKeys");
            object = (Collection)object;
            bl2 = false;
            if (!(!object.isEmpty())) continue;
            object = newEntityBundle.getTableName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newEntityBundle.tableName");
            this.addStatementsToCheckForeignKeyConstraint((String)object, migrateBuilder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addStatementsToMigrateFtsTable(MethodSpec.Builder migrateBuilder, EntityBundle oldTable, EntityBundle newTable, Map<String, String> renamedColumnsMap) {
        void $this$addStatementsToMigrateFtsTable_u24lambda_u2d10;
        CharSequence it;
        void $this$filterTo$iv$iv;
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP TABLE `" + oldTable.getTableName() + '`');
        String string = newTable.createTable();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newTable.createTable()");
        this.addDatabaseExecuteSqlStatement(migrateBuilder, string);
        Iterable $this$filter$iv = oldTable.getFieldsByColumnName().keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl3 = false;
            boolean bl2 = oldTable.getFieldsByColumnName().keySet().contains(it) || renamedColumnsMap.containsKey(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newColumnSequence = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        $i$f$filter = false;
        List oldColumnSequence = new ArrayList();
        Iterable $this$forEach$iv = newColumnSequence;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String column = (String)element$iv;
            boolean bl = false;
            it = renamedColumnsMap.get(column);
            String bl3 = it == null ? column : it;
            Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"renamedColumnsMap[column] ?: column");
            oldColumnSequence.add(bl3);
        }
        if (oldTable instanceof FtsEntityBundle) {
            oldColumnSequence.add("rowid");
            newColumnSequence.add("docid");
        }
        String contentTable = ((FtsEntityBundle)newTable).getFtsOptions().getContentTable();
        Intrinsics.checkNotNullExpressionValue((Object)contentTable, (String)"contentTable");
        CharSequence charSequence = contentTable;
        boolean bl = false;
        String selectFromTable = charSequence.length() == 0 ? oldTable.getTableName() : contentTable;
        boolean bl4 = false;
        bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        it = stringBuilder;
        MethodSpec.Builder builder = migrateBuilder;
        AutoMigrationWriter autoMigrationWriter = this;
        boolean bl7 = false;
        $this$addStatementsToMigrateFtsTable_u24lambda_u2d10.append("INSERT INTO `" + ((FtsEntityBundle)newTable).getTableName() + "` (" + CollectionsKt.joinToString$default((Iterable)newColumnSequence, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ") SELECT " + CollectionsKt.joinToString$default((Iterable)oldColumnSequence, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + " FROM `" + selectFromTable + '`');
        Unit unit = Unit.INSTANCE;
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        autoMigrationWriter.addDatabaseExecuteSqlStatement(builder, string2);
    }

    private final void addSimpleChangeStatements(MethodSpec.Builder migrateBuilder) {
        this.addDeleteTableStatements(migrateBuilder);
        this.addRenameTableStatements(migrateBuilder);
        this.addNewColumnStatements(migrateBuilder);
        this.addNewTableStatements(migrateBuilder);
    }

    private final void addStatementsToCreateNewTable(EntityBundle newTable, MethodSpec.Builder migrateBuilder) {
        String string = newTable.createNewTable();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newTable.createNewTable()");
        this.addDatabaseExecuteSqlStatement(migrateBuilder, string);
    }

    /*
     * WARNING - void declaration
     */
    private final void addStatementsToContentTransfer(String oldTableName, String tableNameWithNewPrefix, EntityBundle oldEntityBundle, EntityBundle newEntityBundle, Map<String, String> renamedColumnsMap, MethodSpec.Builder migrateBuilder) {
        void $this$addStatementsToContentTransfer_u24lambda_u2d13;
        CharSequence column;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = newEntityBundle.getFieldsByColumnName().keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = oldEntityBundle.getFieldsByColumnName().keySet().contains(it) || renamedColumnsMap.containsKey(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newColumnSequence = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        $i$f$filter = false;
        List oldColumnSequence = new ArrayList();
        Iterable $this$forEach$iv = newColumnSequence;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            column = (String)element$iv;
            boolean bl = false;
            String string = renamedColumnsMap.get(column);
            String string2 = string == null ? column : string;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"renamedColumnsMap[column] ?: column");
            oldColumnSequence.add(string2);
        }
        boolean bl = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl4 = false;
        boolean bl5 = false;
        column = stringBuilder;
        MethodSpec.Builder builder = migrateBuilder;
        AutoMigrationWriter autoMigrationWriter = this;
        boolean bl6 = false;
        $this$addStatementsToContentTransfer_u24lambda_u2d13.append("INSERT INTO `" + tableNameWithNewPrefix + "` (" + CollectionsKt.joinToString$default((Iterable)newColumnSequence, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ") SELECT " + CollectionsKt.joinToString$default((Iterable)oldColumnSequence, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + " FROM `" + oldTableName + '`');
        Unit unit = Unit.INSTANCE;
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        autoMigrationWriter.addDatabaseExecuteSqlStatement(builder, string);
    }

    private final void addStatementsToDropTableAndRenameTempTable(String oldTableName, String newTableName, String tableNameWithNewPrefix, MethodSpec.Builder migrateBuilder) {
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP TABLE `" + oldTableName + '`');
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "ALTER TABLE `" + tableNameWithNewPrefix + "` RENAME TO `" + newTableName + '`');
    }

    private final void addStatementsToRecreateIndexes(EntityBundle table, MethodSpec.Builder migrateBuilder) {
        List list = table.getIndices();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"table.indices");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexBundle index = (IndexBundle)element$iv;
            boolean bl = false;
            String string = index.getCreateSql(table.getTableName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"index.getCreateSql(table.tableName)");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, string);
        }
    }

    private final void addStatementsToCheckForeignKeyConstraint(String tableName, MethodSpec.Builder migrateBuilder) {
        Object[] objectArray = new Object[]{RoomTypeNames.INSTANCE.getDB_UTIL(), tableName};
        migrateBuilder.addStatement(Javapoet_extKt.getT() + ".foreignKeyCheck(database, " + Javapoet_extKt.getS() + ')', objectArray);
    }

    private final void addDeleteTableStatements(MethodSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.deletedTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String deleteTableSql;
            String tableName = (String)element$iv;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl4 = false;
            boolean bl5 = false;
            StringBuilder $this$addDeleteTableStatements_u24lambda_u2d16_u24lambda_u2d15 = stringBuilder;
            boolean bl6 = false;
            $this$addDeleteTableStatements_u24lambda_u2d16_u24lambda_u2d15.append("DROP TABLE `" + tableName + '`');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, deleteTableSql);
        }
    }

    private final void addRenameTableStatements(MethodSpec.Builder migrateBuilder) {
        Map<String, String> $this$forEach$iv = this.renamedTables;
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String renameTableSql;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$oldName$newName = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$oldName$newName;
            boolean bl3 = false;
            String oldName = entry.getKey();
            Map.Entry<String, String> entry2 = $dstr$oldName$newName;
            boolean bl4 = false;
            String newName = entry2.getValue();
            bl4 = false;
            boolean bl5 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            StringBuilder $this$addRenameTableStatements_u24lambda_u2d18_u24lambda_u2d17 = stringBuilder;
            boolean bl8 = false;
            $this$addRenameTableStatements_u24lambda_u2d18_u24lambda_u2d17.append("ALTER TABLE `" + oldName + "` RENAME TO `" + newName + '`');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, renameTableSql);
        }
    }

    private final void addNewColumnStatements(MethodSpec.Builder migrateBuilder) {
        Map<String, AutoMigration.AddedColumn> $this$forEach$iv = this.addedColumns;
        boolean $i$f$forEach = false;
        Map<String, AutoMigration.AddedColumn> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, AutoMigration.AddedColumn>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String addNewColumnSql;
            Map.Entry<String, AutoMigration.AddedColumn> element$iv;
            Map.Entry<String, AutoMigration.AddedColumn> it = element$iv = iterator.next();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            StringBuilder $this$addNewColumnStatements_u24lambda_u2d20_u24lambda_u2d19 = stringBuilder;
            boolean bl7 = false;
            $this$addNewColumnStatements_u24lambda_u2d20_u24lambda_u2d19.append("ALTER TABLE `" + it.getValue().getTableName() + "` ADD COLUMN `" + it.getKey() + "` " + it.getValue().getFieldBundle().getAffinity() + ' ');
            if (it.getValue().getFieldBundle().isNonNull()) {
                $this$addNewColumnStatements_u24lambda_u2d20_u24lambda_u2d19.append(Intrinsics.stringPlus((String)"NOT NULL DEFAULT ", (Object)it.getValue().getFieldBundle().getDefaultValue()));
            } else {
                $this$addNewColumnStatements_u24lambda_u2d20_u24lambda_u2d19.append("DEFAULT NULL");
            }
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, addNewColumnSql);
        }
    }

    private final void addNewTableStatements(MethodSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.addedTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoMigration.AddedTable addedTable = (AutoMigration.AddedTable)element$iv;
            boolean bl = false;
            String string = addedTable.getEntityBundle().createTable();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"addedTable.entityBundle.createTable()");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, string);
            this.addStatementsToRecreateIndexes(addedTable.getEntityBundle(), migrateBuilder);
        }
    }

    private final void addDatabaseExecuteSqlStatement(MethodSpec.Builder migrateBuilder, String sql) {
        Object[] objectArray = new Object[]{sql};
        migrateBuilder.addStatement("database.execSQL(" + Javapoet_extKt.getS() + ')', objectArray);
    }
}

