/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.paging.rxjava2;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import androidx.paging.rxjava2.RxPagingSource;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.paging.util.RoomPagingUtilKt;
import androidx.room.paging.util.ThreadSafeInvalidationObserver;
import androidx.sqlite.db.SupportSQLiteQuery;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B+\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\fB)\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 2\u0006\u0010!\u001a\u00020\"H%J#\u0010#\u001a\u0004\u0018\u00010\u00042\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000%H\u0016\u00a2\u0006\u0002\u0010&J\"\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040*H\u0002J(\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000(0,2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040*H\u0016J*\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010.\u001a\u00020\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040*H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u00020\u00118\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u00020\u001b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u0013\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Landroidx/room/paging/rxjava2/LimitOffsetRxPagingSource;", "Value", "", "Landroidx/paging/rxjava2/RxPagingSource;", "", "supportSQLiteQuery", "Landroidx/sqlite/db/SupportSQLiteQuery;", "db", "Landroidx/room/RoomDatabase;", "tables", "", "", "(Landroidx/sqlite/db/SupportSQLiteQuery;Landroidx/room/RoomDatabase;[Ljava/lang/String;)V", "sourceQuery", "Landroidx/room/RoomSQLiteQuery;", "(Landroidx/room/RoomSQLiteQuery;Landroidx/room/RoomDatabase;[Ljava/lang/String;)V", "itemCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getItemCount$room_paging_rxjava2_release$annotations", "()V", "getItemCount$room_paging_rxjava2_release", "()Ljava/util/concurrent/atomic/AtomicInteger;", "jumpingSupported", "", "getJumpingSupported", "()Z", "observer", "Landroidx/room/paging/util/ThreadSafeInvalidationObserver;", "getObserver$room_paging_rxjava2_release$annotations", "getObserver$room_paging_rxjava2_release", "()Landroidx/room/paging/util/ThreadSafeInvalidationObserver;", "convertRows", "", "cursor", "Landroid/database/Cursor;", "getRefreshKey", "state", "Landroidx/paging/PagingState;", "(Landroidx/paging/PagingState;)Ljava/lang/Integer;", "initialLoad", "Landroidx/paging/PagingSource$LoadResult;", "params", "Landroidx/paging/PagingSource$LoadParams;", "loadSingle", "Lio/reactivex/Single;", "nonInitialLoad", "tempCount", "room-paging-rxjava2_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class LimitOffsetRxPagingSource<Value>
extends RxPagingSource<Integer, Value> {
    @NotNull
    private final RoomSQLiteQuery sourceQuery;
    @NotNull
    private final RoomDatabase db;
    @NotNull
    private final AtomicInteger itemCount;
    @NotNull
    private final ThreadSafeInvalidationObserver observer;

    public LimitOffsetRxPagingSource(@NotNull RoomSQLiteQuery sourceQuery, @NotNull RoomDatabase db, String ... tables) {
        Intrinsics.checkNotNullParameter((Object)sourceQuery, (String)"sourceQuery");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        this.sourceQuery = sourceQuery;
        this.db = db;
        this.itemCount = new AtomicInteger(-1);
        this.observer = new ThreadSafeInvalidationObserver(tables, (Function0)new Function0<Unit>(this){
            final /* synthetic */ LimitOffsetRxPagingSource<Value> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.invalidate();
            }
        });
    }

    public LimitOffsetRxPagingSource(@NotNull SupportSQLiteQuery supportSQLiteQuery, @NotNull RoomDatabase db, String ... tables) {
        Intrinsics.checkNotNullParameter((Object)supportSQLiteQuery, (String)"supportSQLiteQuery");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        this(RoomSQLiteQuery.Companion.copyFrom(supportSQLiteQuery), db, Arrays.copyOf(tables, tables.length));
    }

    @NotNull
    public final AtomicInteger getItemCount$room_paging_rxjava2_release() {
        return this.itemCount;
    }

    @VisibleForTesting
    public static /* synthetic */ void getItemCount$room_paging_rxjava2_release$annotations() {
    }

    @NotNull
    public final ThreadSafeInvalidationObserver getObserver$room_paging_rxjava2_release() {
        return this.observer;
    }

    @VisibleForTesting
    public static /* synthetic */ void getObserver$room_paging_rxjava2_release$annotations() {
    }

    @NotNull
    public Single<PagingSource.LoadResult<Integer, Value>> loadSingle(@NotNull PagingSource.LoadParams<Integer> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Scheduler scheduler = Schedulers.from((Executor)this.db.getQueryExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"from(db.queryExecutor)");
        Scheduler scheduler2 = scheduler;
        Single single = RxRoom.createSingle(() -> LimitOffsetRxPagingSource.loadSingle$lambda-0(this, params)).subscribeOn(scheduler2);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"createSingle {\n         \u2026 }.subscribeOn(scheduler)");
        return single;
    }

    private final PagingSource.LoadResult<Integer, Value> initialLoad(PagingSource.LoadParams<Integer> params) {
        Object object = this.db.runInTransaction(() -> LimitOffsetRxPagingSource.initialLoad$lambda-1(this, params));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"db.runInTransaction(\n   \u2026)\n            }\n        )");
        return (PagingSource.LoadResult)object;
    }

    private final PagingSource.LoadResult<Integer, Value> nonInitialLoad(int tempCount, PagingSource.LoadParams<Integer> params) {
        PagingSource.LoadResult loadResult;
        PagingSource.LoadResult result2 = RoomPagingUtilKt.queryDatabase$default(params, (RoomSQLiteQuery)this.sourceQuery, (RoomDatabase)this.db, (int)tempCount, null, (Function1)new Function1<Cursor, List<? extends Value>>((Object)this){

            @NotNull
            public final List<Value> invoke(@NotNull Cursor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LimitOffsetRxPagingSource)((Object)this.receiver)).convertRows(p0);
            }
        }, (int)16, null);
        this.db.getInvalidationTracker().refreshVersionsSync();
        if (this.getInvalid()) {
            PagingSource.LoadResult.Invalid invalid = RoomPagingUtilKt.getINVALID();
            Intrinsics.checkNotNull((Object)invalid, (String)"null cannot be cast to non-null type androidx.paging.PagingSource.LoadResult.Invalid<kotlin.Int, Value of androidx.room.paging.rxjava2.LimitOffsetRxPagingSource>");
            loadResult = (PagingSource.LoadResult)invalid;
        } else {
            loadResult = result2;
        }
        return loadResult;
    }

    @NonNull
    @NotNull
    protected abstract List<Value> convertRows(@NotNull Cursor var1);

    @Nullable
    public Integer getRefreshKey(@NotNull PagingState<Integer, Value> state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        return RoomPagingUtilKt.getClippedRefreshKey(state);
    }

    public boolean getJumpingSupported() {
        return true;
    }

    private static final PagingSource.LoadResult loadSingle$lambda-0(LimitOffsetRxPagingSource this$0, PagingSource.LoadParams $params) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        this$0.observer.registerIfNecessary(this$0.db);
        int tempCount = this$0.itemCount.get();
        return tempCount == -1 ? this$0.initialLoad((PagingSource.LoadParams<Integer>)$params) : this$0.nonInitialLoad(tempCount, (PagingSource.LoadParams<Integer>)$params);
    }

    private static final PagingSource.LoadResult initialLoad$lambda-1(LimitOffsetRxPagingSource this$0, PagingSource.LoadParams $params) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        int tempCount = RoomPagingUtilKt.queryItemCount((RoomSQLiteQuery)this$0.sourceQuery, (RoomDatabase)this$0.db);
        this$0.itemCount.set(tempCount);
        return RoomPagingUtilKt.queryDatabase$default((PagingSource.LoadParams)$params, (RoomSQLiteQuery)this$0.sourceQuery, (RoomDatabase)this$0.db, (int)tempCount, null, (Function1)new Function1<Cursor, List<? extends Value>>((Object)this$0){

            @NotNull
            public final List<Value> invoke(@NotNull Cursor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LimitOffsetRxPagingSource)((Object)this.receiver)).convertRows(p0);
            }
        }, (int)16, null);
    }
}

