/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.database.AbstractWindowedCursor;
import android.database.Cursor;
import android.os.Build;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.RoomDatabase;
import androidx.room.util.CursorUtil;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class DBUtil {
    @Deprecated
    @NonNull
    public static Cursor query(RoomDatabase db, SupportSQLiteQuery sqLiteQuery, boolean maybeCopy) {
        return DBUtil.query(db, sqLiteQuery, maybeCopy, null);
    }

    @NonNull
    public static Cursor query(@NonNull RoomDatabase db, @NonNull SupportSQLiteQuery sqLiteQuery, boolean maybeCopy, @Nullable CancellationSignal signal) {
        Cursor cursor = db.query(sqLiteQuery, signal);
        if (maybeCopy && cursor instanceof AbstractWindowedCursor) {
            AbstractWindowedCursor windowedCursor = (AbstractWindowedCursor)cursor;
            int rowsInCursor = windowedCursor.getCount();
            int rowsInWindow = windowedCursor.hasWindow() ? windowedCursor.getWindow().getNumRows() : rowsInCursor;
            if (Build.VERSION.SDK_INT < 23 || rowsInWindow < rowsInCursor) {
                return CursorUtil.copyAndClose((Cursor)windowedCursor);
            }
        }
        return cursor;
    }

    public static void dropFtsSyncTriggers(SupportSQLiteDatabase db) {
        ArrayList<String> existingTriggers = new ArrayList<String>();
        try (Cursor cursor = db.query("SELECT name FROM sqlite_master WHERE type = 'trigger'");){
            while (cursor.moveToNext()) {
                existingTriggers.add(cursor.getString(0));
            }
        }
        for (String triggerName : existingTriggers) {
            if (!triggerName.startsWith("room_fts_content_sync_")) continue;
            db.execSQL("DROP TRIGGER IF EXISTS " + triggerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void foreignKeyCheck(@NonNull SupportSQLiteDatabase db, @NonNull String tableName) {
        try (Cursor cursor = db.query("PRAGMA foreign_key_check(`" + tableName + "`)");){
            if (cursor.getCount() > 0) {
                String errorMsg = DBUtil.processForeignKeyCheckFailure(cursor);
                throw new IllegalStateException(errorMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readVersion(@NonNull File databaseFile) throws IOException {
        try (AbstractInterruptibleChannel input = null;){
            ByteBuffer buffer = ByteBuffer.allocate(4);
            input = new FileInputStream(databaseFile).getChannel();
            ((FileChannel)input).tryLock(60L, 4L, true);
            ((FileChannel)input).position(60L);
            int read = ((FileChannel)input).read(buffer);
            if (read != 4) {
                throw new IOException("Bad database header, unable to read 4 bytes at offset 60");
            }
            buffer.rewind();
            int n = buffer.getInt();
            return n;
        }
    }

    @Nullable
    public static CancellationSignal createCancellationSignal() {
        if (Build.VERSION.SDK_INT >= 16) {
            return SupportSQLiteCompat.Api16Impl.createCancellationSignal();
        }
        return null;
    }

    private static String processForeignKeyCheckFailure(Cursor cursor) {
        int rowCount = cursor.getCount();
        String childTableName = null;
        HashMap<String, String> fkParentTables = new HashMap<String, String>();
        while (cursor.moveToNext()) {
            String constraintIndex;
            if (childTableName == null) {
                childTableName = cursor.getString(0);
            }
            if (fkParentTables.containsKey(constraintIndex = cursor.getString(3))) continue;
            fkParentTables.put(constraintIndex, cursor.getString(2));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Foreign key violation(s) detected in '").append(childTableName).append("'.\n");
        sb.append("Number of different violations discovered: ").append(fkParentTables.keySet().size()).append("\n");
        sb.append("Number of rows in violation: ").append(rowCount).append("\n");
        sb.append("Violation(s) detected in the following constraint(s):\n");
        for (Map.Entry entry : fkParentTables.entrySet()) {
            sb.append("\tParent Table = ").append((String)entry.getValue());
            sb.append(", Foreign Key Constraint Index = ").append((String)entry.getKey()).append("\n");
        }
        return sb.toString();
    }

    private DBUtil() {
    }
}

