/*
 * Decompiled with CFR 0.152.
 */
package androidx.savedstate.bundle;

import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.savedstate.AbstractSavedStateRegistry;
import java.util.HashMap;
import java.util.Map;

public final class BundleSavedStateRegistry
extends AbstractSavedStateRegistry<Bundle> {
    private static final String SAVED_COMPONENTS_KEY = "androidx.lifecycle.BundlableSavedStateRegistry.key";

    @MainThread
    public void performRestore(@Nullable Bundle savedState) {
        Bundle componentsState;
        Bundle bundle = componentsState = savedState != null ? savedState.getBundle(SAVED_COMPONENTS_KEY) : null;
        if (componentsState == null || componentsState.isEmpty()) {
            this.restoreSavedState(null);
            return;
        }
        HashMap<String, Bundle> initialState = new HashMap<String, Bundle>();
        for (String key : componentsState.keySet()) {
            initialState.put(key, componentsState.getBundle(key));
        }
        this.restoreSavedState(initialState);
    }

    @MainThread
    public void performSave(@NonNull Bundle outBundle) {
        Map bundleMap = this.saveState();
        Bundle components = new Bundle();
        for (Map.Entry entry : bundleMap.entrySet()) {
            components.putBundle((String)entry.getKey(), (Bundle)entry.getValue());
        }
        outBundle.putBundle(SAVED_COMPONENTS_KEY, components);
    }
}

