/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.driver;

import android.database.sqlite.SQLiteDatabase;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteKt;
import androidx.sqlite.SQLiteStatement;
import androidx.sqlite.driver.AndroidSQLiteStatement;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/sqlite/driver/AndroidSQLiteConnection;", "Landroidx/sqlite/SQLiteConnection;", "db", "Landroid/database/sqlite/SQLiteDatabase;", "(Landroid/database/sqlite/SQLiteDatabase;)V", "close", "", "prepare", "Landroidx/sqlite/SQLiteStatement;", "sql", "", "sqlite-framework_release"})
public final class AndroidSQLiteConnection
implements SQLiteConnection {
    @NotNull
    private final SQLiteDatabase db;

    public AndroidSQLiteConnection(@NotNull SQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.db = db;
    }

    @NotNull
    public SQLiteStatement prepare(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        if (this.db.isOpen()) {
            return AndroidSQLiteStatement.Companion.create(this.db, sql);
        }
        SQLiteKt.throwSQLiteException((int)21, (String)"connection is closed");
        throw new KotlinNothingValueException();
    }

    public void close() {
        this.db.close();
    }
}

