/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.driver;

import android.database.Cursor;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQuery;
import androidx.sqlite.SQLiteKt;
import androidx.sqlite.SQLiteStatement;
import java.util.Arrays;
import java.util.Locale;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Landroidx/sqlite/driver/AndroidSQLiteStatement;", "Landroidx/sqlite/SQLiteStatement;", "db", "Landroid/database/sqlite/SQLiteDatabase;", "sql", "", "(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;)V", "getDb", "()Landroid/database/sqlite/SQLiteDatabase;", "isClosed", "", "()Z", "setClosed", "(Z)V", "getSql", "()Ljava/lang/String;", "throwIfClosed", "", "Companion", "OtherAndroidSQLiteStatement", "SelectAndroidSQLiteStatement", "Landroidx/sqlite/driver/AndroidSQLiteStatement$OtherAndroidSQLiteStatement;", "Landroidx/sqlite/driver/AndroidSQLiteStatement$SelectAndroidSQLiteStatement;", "sqlite-framework_release"})
public abstract class AndroidSQLiteStatement
implements SQLiteStatement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SQLiteDatabase db;
    @NotNull
    private final String sql;
    private boolean isClosed;

    private AndroidSQLiteStatement(SQLiteDatabase db, String sql) {
        this.db = db;
        this.sql = sql;
    }

    @NotNull
    protected final SQLiteDatabase getDb() {
        return this.db;
    }

    @NotNull
    protected final String getSql() {
        return this.sql;
    }

    protected final boolean isClosed() {
        return this.isClosed;
    }

    protected final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    protected final void throwIfClosed() {
        if (this.isClosed) {
            SQLiteKt.throwSQLiteException((int)21, (String)"statement is closed");
            throw new KotlinNothingValueException();
        }
    }

    public /* synthetic */ AndroidSQLiteStatement(SQLiteDatabase db, String sql, DefaultConstructorMarker $constructor_marker) {
        this(db, sql);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Landroidx/sqlite/driver/AndroidSQLiteStatement$Companion;", "", "()V", "create", "Landroidx/sqlite/driver/AndroidSQLiteStatement;", "db", "Landroid/database/sqlite/SQLiteDatabase;", "sql", "", "isRowStatement", "", "sqlite-framework_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AndroidSQLiteStatement create(@NotNull SQLiteDatabase db, @NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            return this.isRowStatement(sql) ? (AndroidSQLiteStatement)new SelectAndroidSQLiteStatement(db, sql) : (AndroidSQLiteStatement)new OtherAndroidSQLiteStatement(db, sql);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isRowStatement(String sql) {
            String prefix = ((Object)StringsKt.trim((CharSequence)sql)).toString();
            if (prefix.length() < 3) {
                return false;
            }
            String string = prefix.substring(0, 3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String string3 = string2;
            switch (string3.hashCode()) {
                case 85954: {
                    if (string3.equals("WIT")) return true;
                    return false;
                }
                case 81978: {
                    if (string3.equals("SEL")) return true;
                    return false;
                }
                case 79487: {
                    if (!string3.equals("PRA")) return false;
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010 \u001a\u00020\u000bH\u0016J\b\u0010!\u001a\u00020\u001fH\u0016R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/sqlite/driver/AndroidSQLiteStatement$OtherAndroidSQLiteStatement;", "Landroidx/sqlite/driver/AndroidSQLiteStatement;", "db", "Landroid/database/sqlite/SQLiteDatabase;", "sql", "", "(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;)V", "delegate", "Landroid/database/sqlite/SQLiteStatement;", "Landroidx/sqlite/driver/FrameworkStatement;", "bindBlob", "", "index", "", "value", "", "bindDouble", "", "bindLong", "", "bindNull", "bindText", "clearBindings", "close", "getBlob", "getColumnCount", "getColumnName", "getDouble", "getLong", "getText", "isNull", "", "reset", "step", "sqlite-framework_release"})
    private static final class OtherAndroidSQLiteStatement
    extends AndroidSQLiteStatement {
        @NotNull
        private final android.database.sqlite.SQLiteStatement delegate;

        public OtherAndroidSQLiteStatement(@NotNull SQLiteDatabase db, @NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            super(db, sql, null);
            android.database.sqlite.SQLiteStatement sQLiteStatement = db.compileStatement(sql);
            Intrinsics.checkNotNullExpressionValue((Object)sQLiteStatement, (String)"db.compileStatement(sql)");
            this.delegate = sQLiteStatement;
        }

        public void bindBlob(int index, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.throwIfClosed();
            this.delegate.bindBlob(index, value);
        }

        public void bindDouble(int index, double value) {
            this.throwIfClosed();
            this.delegate.bindDouble(index, value);
        }

        public void bindLong(int index, long value) {
            this.throwIfClosed();
            this.delegate.bindLong(index, value);
        }

        public void bindText(int index, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.throwIfClosed();
            this.delegate.bindString(index, value);
        }

        public void bindNull(int index) {
            this.throwIfClosed();
            this.delegate.bindNull(index);
        }

        @NotNull
        public byte[] getBlob(int index) {
            this.throwIfClosed();
            SQLiteKt.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        public double getDouble(int index) {
            this.throwIfClosed();
            SQLiteKt.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        public long getLong(int index) {
            this.throwIfClosed();
            SQLiteKt.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        @NotNull
        public String getText(int index) {
            this.throwIfClosed();
            SQLiteKt.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        public boolean isNull(int index) {
            this.throwIfClosed();
            SQLiteKt.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        public int getColumnCount() {
            this.throwIfClosed();
            return 0;
        }

        @NotNull
        public String getColumnName(int index) {
            this.throwIfClosed();
            SQLiteKt.throwSQLiteException((int)21, (String)"no row");
            throw new KotlinNothingValueException();
        }

        public boolean step() {
            this.throwIfClosed();
            this.delegate.execute();
            return false;
        }

        public void reset() {
        }

        public void clearBindings() {
            this.throwIfClosed();
            this.delegate.clearBindings();
        }

        public void close() {
            this.delegate.close();
            this.setClosed(true);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u0000 52\u00020\u0001:\u00015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0016H\u0016J\b\u0010$\u001a\u00020\u0016H\u0016J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010'\u001a\u00020\u0016H\u0002J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010)\u001a\u00020\u0018H\u0016J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u00100\u001a\u00020\u0016H\u0016J\b\u00101\u001a\u00020/H\u0016J\u0018\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u00104\u001a\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u00066"}, d2={"Landroidx/sqlite/driver/AndroidSQLiteStatement$SelectAndroidSQLiteStatement;", "Landroidx/sqlite/driver/AndroidSQLiteStatement;", "db", "Landroid/database/sqlite/SQLiteDatabase;", "sql", "", "(Landroid/database/sqlite/SQLiteDatabase;Ljava/lang/String;)V", "bindingTypes", "", "blobBindings", "", "", "[[B", "cursor", "Landroid/database/Cursor;", "doubleBindings", "", "longBindings", "", "stringBindings", "[Ljava/lang/String;", "bindBlob", "", "index", "", "value", "bindDouble", "", "bindLong", "", "bindNull", "bindText", "bindTo", "query", "Landroid/database/sqlite/SQLiteProgram;", "clearBindings", "close", "ensureCapacity", "columnType", "ensureCursor", "getBlob", "getColumnCount", "getColumnName", "getDouble", "getLong", "getText", "isNull", "", "reset", "step", "throwIfInvalidColumn", "c", "throwIfNoRow", "Companion", "sqlite-framework_release"})
    @SourceDebugExtension(value={"SMAP\nAndroidSQLiteStatement.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSQLiteStatement.android.kt\nandroidx/sqlite/driver/AndroidSQLiteStatement$SelectAndroidSQLiteStatement\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,354:1\n26#2:355\n26#2:356\n26#2:357\n26#2:358\n*S KotlinDebug\n*F\n+ 1 AndroidSQLiteStatement.android.kt\nandroidx/sqlite/driver/AndroidSQLiteStatement$SelectAndroidSQLiteStatement\n*L\n75#1:355\n76#1:356\n181#1:357\n182#1:358\n*E\n"})
    private static final class SelectAndroidSQLiteStatement
    extends AndroidSQLiteStatement {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private int[] bindingTypes;
        @NotNull
        private long[] longBindings;
        @NotNull
        private double[] doubleBindings;
        @NotNull
        private String[] stringBindings;
        @NotNull
        private byte[][] blobBindings;
        @Nullable
        private Cursor cursor;
        private static final int COLUMN_TYPE_LONG = 1;
        private static final int COLUMN_TYPE_DOUBLE = 2;
        private static final int COLUMN_TYPE_STRING = 3;
        private static final int COLUMN_TYPE_BLOB = 4;
        private static final int COLUMN_TYPE_NULL = 5;

        public SelectAndroidSQLiteStatement(@NotNull SQLiteDatabase db, @NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            super(db, sql, null);
            this.bindingTypes = new int[0];
            this.longBindings = new long[0];
            this.doubleBindings = new double[0];
            boolean $i$f$emptyArray = false;
            this.stringBindings = new String[0];
            $i$f$emptyArray = false;
            this.blobBindings = new byte[0][];
        }

        public void bindBlob(int index, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.throwIfClosed();
            this.ensureCapacity(4, index);
            this.bindingTypes[index] = 4;
            this.blobBindings[index] = value;
        }

        public void bindDouble(int index, double value) {
            this.throwIfClosed();
            this.ensureCapacity(2, index);
            this.bindingTypes[index] = 2;
            this.doubleBindings[index] = value;
        }

        public void bindLong(int index, long value) {
            this.throwIfClosed();
            this.ensureCapacity(1, index);
            this.bindingTypes[index] = 1;
            this.longBindings[index] = value;
        }

        public void bindText(int index, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.throwIfClosed();
            this.ensureCapacity(3, index);
            this.bindingTypes[index] = 3;
            this.stringBindings[index] = value;
        }

        public void bindNull(int index) {
            this.throwIfClosed();
            this.ensureCapacity(5, index);
            this.bindingTypes[index] = 5;
        }

        @NotNull
        public byte[] getBlob(int index) {
            this.throwIfClosed();
            Cursor c = this.throwIfNoRow();
            this.throwIfInvalidColumn(c, index);
            byte[] byArray = c.getBlob(index);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"c.getBlob(index)");
            return byArray;
        }

        public double getDouble(int index) {
            this.throwIfClosed();
            Cursor c = this.throwIfNoRow();
            this.throwIfInvalidColumn(c, index);
            return c.getDouble(index);
        }

        public long getLong(int index) {
            this.throwIfClosed();
            Cursor c = this.throwIfNoRow();
            this.throwIfInvalidColumn(c, index);
            return c.getLong(index);
        }

        @NotNull
        public String getText(int index) {
            this.throwIfClosed();
            Cursor c = this.throwIfNoRow();
            this.throwIfInvalidColumn(c, index);
            String string = c.getString(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"c.getString(index)");
            return string;
        }

        public boolean isNull(int index) {
            this.throwIfClosed();
            Cursor c = this.throwIfNoRow();
            this.throwIfInvalidColumn(c, index);
            return c.isNull(index);
        }

        public int getColumnCount() {
            this.throwIfClosed();
            this.ensureCursor();
            Cursor cursor = this.cursor;
            return cursor != null ? cursor.getColumnCount() : 0;
        }

        @NotNull
        public String getColumnName(int index) {
            this.throwIfClosed();
            this.ensureCursor();
            Cursor cursor = this.cursor;
            if (cursor == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Cursor c = cursor;
            this.throwIfInvalidColumn(c, index);
            String string = c.getColumnName(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"c.getColumnName(index)");
            return string;
        }

        public boolean step() {
            this.throwIfClosed();
            this.ensureCursor();
            Cursor cursor = this.cursor;
            if (cursor == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            return cursor.moveToNext();
        }

        public void reset() {
            this.throwIfClosed();
            Cursor cursor = this.cursor;
            if (cursor != null) {
                cursor.close();
            }
            this.cursor = null;
        }

        public void clearBindings() {
            this.throwIfClosed();
            this.bindingTypes = new int[0];
            this.longBindings = new long[0];
            this.doubleBindings = new double[0];
            boolean $i$f$emptyArray = false;
            this.stringBindings = new String[0];
            $i$f$emptyArray = false;
            this.blobBindings = new byte[0][];
        }

        public void close() {
            if (!this.isClosed()) {
                this.reset();
            }
            this.setClosed(true);
        }

        private final void ensureCapacity(int columnType, int index) {
            int requiredSize = index + 1;
            if (this.bindingTypes.length < requiredSize) {
                int[] nArray = Arrays.copyOf(this.bindingTypes, requiredSize);
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
                this.bindingTypes = nArray;
            }
            switch (columnType) {
                case 1: {
                    if (this.longBindings.length >= requiredSize) break;
                    long[] lArray = Arrays.copyOf(this.longBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(this, newSize)");
                    this.longBindings = lArray;
                    break;
                }
                case 2: {
                    if (this.doubleBindings.length >= requiredSize) break;
                    double[] dArray = Arrays.copyOf(this.doubleBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(this, newSize)");
                    this.doubleBindings = dArray;
                    break;
                }
                case 3: {
                    if (this.stringBindings.length >= requiredSize) break;
                    String[] stringArray = Arrays.copyOf(this.stringBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(this, newSize)");
                    this.stringBindings = stringArray;
                    break;
                }
                case 4: {
                    if (((Object[])this.blobBindings).length >= requiredSize) break;
                    Object[] objectArray = Arrays.copyOf((Object[])this.blobBindings, requiredSize);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
                    this.blobBindings = (byte[][])objectArray;
                }
            }
        }

        private final void ensureCursor() {
            if (this.cursor == null) {
                this.cursor = this.getDb().rawQueryWithFactory((arg_0, arg_1, arg_2, arg_3) -> SelectAndroidSQLiteStatement.ensureCursor$lambda$0(this, arg_0, arg_1, arg_2, arg_3), this.getSql(), new String[0], null);
            }
        }

        private final void bindTo(SQLiteProgram query2) {
            int n = this.bindingTypes.length;
            block7: for (int index = 1; index < n; ++index) {
                switch (this.bindingTypes[index]) {
                    case 1: {
                        query2.bindLong(index, this.longBindings[index]);
                        continue block7;
                    }
                    case 2: {
                        query2.bindDouble(index, this.doubleBindings[index]);
                        continue block7;
                    }
                    case 3: {
                        query2.bindString(index, this.stringBindings[index]);
                        continue block7;
                    }
                    case 4: {
                        query2.bindBlob(index, this.blobBindings[index]);
                        continue block7;
                    }
                    case 5: {
                        query2.bindNull(index);
                    }
                }
            }
        }

        private final Cursor throwIfNoRow() {
            Cursor cursor = this.cursor;
            if (cursor == null) {
                SQLiteKt.throwSQLiteException((int)21, (String)"no row");
                throw new KotlinNothingValueException();
            }
            return cursor;
        }

        private final void throwIfInvalidColumn(Cursor c, int index) {
            if (index < 0 || index >= c.getColumnCount()) {
                SQLiteKt.throwSQLiteException((int)25, (String)"column index out of range");
                throw new KotlinNothingValueException();
            }
        }

        private static final Cursor ensureCursor$lambda$0(SelectAndroidSQLiteStatement this$0, SQLiteDatabase sQLiteDatabase, SQLiteCursorDriver masterQuery, String editTable, SQLiteQuery query2) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"query");
            this$0.bindTo((SQLiteProgram)query2);
            return (Cursor)new SQLiteCursor(masterQuery, editTable, query2);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/sqlite/driver/AndroidSQLiteStatement$SelectAndroidSQLiteStatement$Companion;", "", "()V", "COLUMN_TYPE_BLOB", "", "COLUMN_TYPE_DOUBLE", "COLUMN_TYPE_LONG", "COLUMN_TYPE_NULL", "COLUMN_TYPE_STRING", "sqlite-framework_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

