/*
 * Decompiled with CFR 0.152.
 */
package androidx.startup;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.startup.InitializationProvider;
import androidx.startup.Initializer;
import androidx.startup.R;
import androidx.startup.StartupException;
import androidx.tracing.Trace;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AppInitializer {
    private static final String SECTION_NAME = "Startup";
    private static volatile AppInitializer sInstance;
    private static final Object sLock;
    @NonNull
    final Map<Class<?>, Object> mInitialized;
    @NonNull
    final Context mContext;

    AppInitializer(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.mInitialized = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static AppInitializer getInstance(@NonNull Context context) {
        if (sInstance == null) {
            Object object = sLock;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new AppInitializer(context);
                }
            }
        }
        return sInstance;
    }

    @NonNull
    public <T> T initializeComponent(@NonNull Class<? extends Initializer<T>> component) {
        return this.doInitialize(component, new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    <T> T doInitialize(@NonNull Class<? extends Initializer<?>> component, @NonNull Set<Class<?>> initializing) {
        Object object = sLock;
        synchronized (object) {
            Object result;
            boolean isTracingEnabled = Trace.isEnabled();
            if (isTracingEnabled) {
                Trace.beginSection((String)component.getSimpleName());
            }
            if (initializing.contains(component)) {
                String message = String.format("Cannot initialize %s. Cycle detected.", component.getName());
                throw new IllegalStateException(message);
            }
            if (!this.mInitialized.containsKey(component)) {
                initializing.add(component);
                try {
                    Initializer<?> instance;
                    Initializer<?> initializer = instance = component.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    List<Class<Initializer<?>>> dependencies = initializer.dependencies();
                    if (!dependencies.isEmpty()) {
                        for (Class<Initializer<?>> clazz : dependencies) {
                            if (this.mInitialized.containsKey(clazz)) continue;
                            this.doInitialize(clazz, initializing);
                        }
                    }
                    result = initializer.create(this.mContext);
                    initializing.remove(component);
                    this.mInitialized.put(component, result);
                }
                catch (Throwable throwable) {
                    throw new StartupException(throwable);
                }
            } else {
                result = this.mInitialized.get(component);
            }
            Object object2 = result;
            return (T)object2;
            finally {
                Trace.endSection();
            }
        }
    }

    void discoverAndInitialize() {
        try {
            Trace.beginSection((String)SECTION_NAME);
            ComponentName provider = new ComponentName(this.mContext.getPackageName(), InitializationProvider.class.getName());
            ProviderInfo providerInfo = this.mContext.getPackageManager().getProviderInfo(provider, 128);
            Bundle metadata = providerInfo.metaData;
            String startup = this.mContext.getString(R.string.androidx_startup);
            if (metadata != null) {
                HashSet initializing = new HashSet();
                Set keys = metadata.keySet();
                for (String key : keys) {
                    Class<?> clazz;
                    String value = metadata.getString(key, null);
                    if (!startup.equals(value) || !Initializer.class.isAssignableFrom(clazz = Class.forName(key))) continue;
                    Class<?> component = clazz;
                    this.doInitialize(component, initializing);
                }
            }
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException exception) {
            throw new StartupException(exception);
        }
        finally {
            Trace.endSection();
        }
    }

    static {
        sLock = new Object();
    }
}

