/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.app;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.ContentResolver;
import android.content.Intent;
import android.provider.Settings;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.test.core.app.ActivityScenario$$Lambda$0;
import androidx.test.core.app.ActivityScenario$$Lambda$1;
import androidx.test.core.app.InstrumentationActivityInvoker;
import androidx.test.internal.platform.ServiceLoaderWrapper;
import androidx.test.internal.platform.app.ActivityInvoker;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.runner.lifecycle.ActivityLifecycleCallback;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.io.Closeable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class ActivityScenario<A extends Activity>
implements AutoCloseable,
Closeable {
    private static final long TIMEOUT_MILLISECONDS = 45000L;
    private static final ActivityInvoker activityInvoker = (ActivityInvoker)ServiceLoaderWrapper.loadSingleService(ActivityInvoker.class, (ServiceLoaderWrapper.Factory)ActivityScenario$$Lambda$1.$instance);
    private static final Map<Stage, Lifecycle.State> STEADY_STATES = new EnumMap<Stage, Lifecycle.State>(Stage.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition stateChangedCondition = this.lock.newCondition();
    private final Intent startActivityIntent;
    @GuardedBy(value="lock")
    private Stage currentActivityStage;
    @GuardedBy(value="lock")
    @Nullable
    private A currentActivity;
    private final ActivityLifecycleCallback activityLifecycleObserver = new ActivityLifecycleCallback(){

        public void onActivityLifecycleChanged(Activity activity, Stage stage) {
            if (!ActivityScenario.this.startActivityIntent.filterEquals(activity.getIntent())) {
                return;
            }
            ActivityScenario.this.lock.lock();
            try {
                switch (ActivityScenario.this.currentActivityStage) {
                    case PRE_ON_CREATE: 
                    case DESTROYED: {
                        if (stage == Stage.CREATED) break;
                        return;
                    }
                    default: {
                        if (ActivityScenario.this.currentActivity == activity) break;
                        return;
                    }
                }
                ActivityScenario.this.currentActivityStage = stage;
                ActivityScenario.this.currentActivity = (Activity)(stage != Stage.DESTROYED ? activity : null);
                ActivityScenario.this.stateChangedCondition.signal();
            }
            finally {
                ActivityScenario.this.lock.unlock();
            }
        }
    };

    private ActivityScenario(Intent startActivityIntent) {
        Checks.checkState((Settings.System.getInt((ContentResolver)InstrumentationRegistry.getInstrumentation().getTargetContext().getContentResolver(), (String)"always_finish_activities", (int)0) == 0 ? 1 : 0) != 0, (Object)"\"Don't keep activities\" developer options must be disabled for ActivityScenario");
        this.startActivityIntent = (Intent)Checks.checkNotNull((Object)startActivityIntent);
        this.currentActivityStage = Stage.PRE_ON_CREATE;
    }

    public static <A extends Activity> ActivityScenario<A> launch(Class<A> activityClass) {
        return ActivityScenario.launch(activityInvoker.getIntentForActivity((Class)Checks.checkNotNull(activityClass)));
    }

    public static <A extends Activity> ActivityScenario<A> launch(Intent startActivityIntent) {
        Checks.checkNotMainThread();
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        ActivityScenario<A> scenario = new ActivityScenario<A>((Intent)Checks.checkNotNull((Object)startActivityIntent));
        ActivityLifecycleMonitorRegistry.getInstance().addLifecycleCallback(scenario.activityLifecycleObserver);
        activityInvoker.startActivity(scenario.startActivityIntent);
        super.waitForActivityToBecomeAnyOf(STEADY_STATES.values().toArray(new Lifecycle.State[0]));
        return scenario;
    }

    @Override
    public void close() {
        this.moveToState(Lifecycle.State.DESTROYED);
        ActivityLifecycleMonitorRegistry.getInstance().removeLifecycleCallback(this.activityLifecycleObserver);
    }

    private void waitForActivityToBecomeAnyOf(Lifecycle.State ... expectedStates) {
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        HashSet<Lifecycle.State> expectedStateSet = new HashSet<Lifecycle.State>(Arrays.asList(expectedStates));
        this.lock.lock();
        try {
            if (expectedStateSet.contains(STEADY_STATES.get(this.currentActivityStage))) {
                return;
            }
            long now = System.currentTimeMillis();
            long deadline = now + 45000L;
            while (now < deadline && !expectedStateSet.contains(STEADY_STATES.get(this.currentActivityStage))) {
                this.stateChangedCondition.await(deadline - now, TimeUnit.MILLISECONDS);
                now = System.currentTimeMillis();
            }
            if (!expectedStateSet.contains(STEADY_STATES.get(this.currentActivityStage))) {
                throw new AssertionError((Object)String.format("Activity never becomes requested state \"%s\" (last lifecycle transition = \"%s\")", expectedStateSet, this.currentActivityStage));
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)String.format("Activity never becomes requested state \"%s\" (last lifecycle transition = \"%s\")", expectedStateSet, this.currentActivityStage));
        }
        finally {
            this.lock.unlock();
        }
    }

    private ActivityState<A> getCurrentActivityState() {
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        this.lock.lock();
        try {
            ActivityState<A> activityState = new ActivityState<A>(this.currentActivity, STEADY_STATES.get(this.currentActivityStage), this.currentActivityStage);
            return activityState;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ActivityScenario<A> moveToState(Lifecycle.State newState) {
        Checks.checkNotMainThread();
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        ActivityState<A> currentState = this.getCurrentActivityState();
        Checks.checkNotNull((Object)currentState.state, (Object)String.format("Current state was null unexpectedly. Last stage = %s", currentState.stage));
        if (currentState.state == newState) {
            return this;
        }
        Checks.checkState((currentState.state != Lifecycle.State.DESTROYED && currentState.activity != null ? 1 : 0) != 0, (Object)String.format("Cannot move to state \"%s\" since the Activity has been destroyed already", newState));
        switch (newState) {
            case CREATED: {
                activityInvoker.stopActivity(currentState.activity);
                break;
            }
            case STARTED: {
                this.moveToState(Lifecycle.State.RESUMED);
                activityInvoker.pauseActivity(currentState.activity);
                break;
            }
            case RESUMED: {
                activityInvoker.resumeActivity(currentState.activity);
                break;
            }
            case DESTROYED: {
                activityInvoker.finishActivity(currentState.activity);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("A requested state \"%s\" is not supported", newState));
            }
        }
        this.waitForActivityToBecomeAnyOf(newState);
        return this;
    }

    public ActivityScenario<A> recreate() {
        ActivityState<A> activityState;
        Checks.checkNotMainThread();
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        ActivityState<A> prevActivityState = this.getCurrentActivityState();
        Checks.checkNotNull(prevActivityState.activity);
        Checks.checkNotNull((Object)prevActivityState.state);
        this.moveToState(Lifecycle.State.RESUMED);
        activityInvoker.recreateActivity(prevActivityState.activity);
        long now = System.currentTimeMillis();
        long deadline = now + 45000L;
        do {
            this.waitForActivityToBecomeAnyOf(Lifecycle.State.RESUMED);
            now = System.currentTimeMillis();
            activityState = this.getCurrentActivityState();
        } while (now < deadline && activityState.activity == prevActivityState.activity);
        if (activityState.activity == prevActivityState.activity) {
            throw new IllegalStateException("Requested a re-creation of Activity but didn't happen");
        }
        this.moveToState(prevActivityState.state);
        return this;
    }

    public ActivityScenario<A> onActivity(ActivityAction<A> action) {
        Checks.checkNotMainThread();
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)new ActivityScenario$$Lambda$0(this, action));
        return this;
    }

    public Instrumentation.ActivityResult getResult() {
        return activityInvoker.getActivityResult();
    }

    public Lifecycle.State getState() {
        return (Lifecycle.State)Checks.checkNotNull((Object)this.getCurrentActivityState().state, (Object)"Could not get current state due to the transition is incomplete.");
    }

    final /* synthetic */ void lambda$onActivity$1$ActivityScenario(ActivityAction action) {
        this.lock.lock();
        try {
            Checks.checkNotNull(this.currentActivity, (Object)"Cannot run onActivity since Activity has been destroyed already");
            action.perform(this.currentActivity);
        }
        finally {
            this.lock.unlock();
        }
    }

    static final /* synthetic */ ActivityInvoker lambda$static$0$ActivityScenario() {
        return new InstrumentationActivityInvoker();
    }

    static {
        STEADY_STATES.put(Stage.RESUMED, Lifecycle.State.RESUMED);
        STEADY_STATES.put(Stage.PAUSED, Lifecycle.State.STARTED);
        STEADY_STATES.put(Stage.STOPPED, Lifecycle.State.CREATED);
        STEADY_STATES.put(Stage.DESTROYED, Lifecycle.State.DESTROYED);
    }

    public static interface ActivityAction<A extends Activity> {
        public void perform(A var1);
    }

    private static class ActivityState<A extends Activity> {
        @Nullable
        final A activity;
        @Nullable
        final Lifecycle.State state;
        final Stage stage;

        ActivityState(@Nullable A activity, @Nullable Lifecycle.State state, Stage stage) {
            this.activity = activity;
            this.state = state;
            this.stage = stage;
        }
    }
}

